#include "creatblb.h"

CreateBLOBTable::CreateBLOBTable( char* tablename,
											 int numfiles,
											 PArray bmpfilenames,
											 BEngine *EngParm
										  )
	{
	//create instance of engine error handling mechanism
	err = new errorclassthing;

   //for reading in the BMP files 
	fstream *bmpfile = new fstream( );

	BEngine 		*Eng;
	BDatabase 	*BDb;
	BCursor   	*BCur;
	BRecord 		*BRec;
	struct BEnv *Env;

	int temp;

	int numfields = 2;
   //record description
   FieldDesc recdesc[] = {
 									{ 1, "Bitmap", 	fldBlob, fldstMemo, 240  },
									{ 2, "Filenames", fldChar, fldstNone, 40  }
								  };

	//if not passed BEngine pointer initialize engine
	//with instantiation of BEngine
	if ( !EngParm )
		Eng = new BEngine();
	else
		Eng = EngParm;

	Env = new BEnv;
	Eng->getDefaults( *Env );
	ThisError( Eng->lastError );

	//change environment settings
	//if under windows otherwise
	//keep defaults
   #ifdef _Windows
	Env->engineType = pxWin;
	#endif

	//enforce change
	Eng->setDefaults( *Env );
	ThisError( Eng->lastError );

	//open engine
	Eng->open();
	ThisError( Eng->lastError );
   
	BDb  = new BDatabase( Eng );
	ThisError( BDb->lastError );

	BDb->createTable( tablename, numfields, recdesc );
	ThisError( BDb->lastError );

	BCur = new BCursor( BDb, tablename );
	ThisError( BCur->lastError );

	BRec = new BRecord( BCur );
	ThisError( BRec->lastError );

	long filesize, offset;
	char *PCtemp = new char[MAXBLOBIO];

	for( int bmpfileindex = 0; bmpfileindex < numfiles; bmpfileindex++ )
		{
		//This is gnarly.  As I understand it at this moment
		//cast the returned object from the Array container class
		//to a String container and the compiler, expecting a 'char *',
		//gets the character array pointer from String (which can be derefernced using
      //the overloaded operator *).
		bmpfile->open((String&)((*bmpfilenames)[bmpfileindex]), ios::in | ios::ate | ios::binary );

		filesize = bmpfile->tellg();
		bmpfile->seekg( 0, ios::beg );

		BRec->clear();
		ThisError( BRec->lastError );
   
		BRec->putField( "Filenames", (String&)((*bmpfilenames)[bmpfileindex]) );
		ThisError( BRec->lastError );

		BRec->openBlobWrite( 1, filesize, FALSE );
		ThisError( BRec->lastError );

		//this loop, eventhough it only reads 37k max at a time,
		//shows one method for reading from a file and writing to the
      //blob a chunk at a time
		offset = temp = 0;
		while( filesize )
			{
			if ( filesize >= MAXBLOBIO )
				{
				temp = MAXBLOBIO;
				filesize -= MAXBLOBIO;
				}
			else
				{
				temp = filesize;
				filesize = 0;
				}

			bmpfile->read( (char *)PCtemp, temp );

			if ( bmpfile->gcount() <= temp && bmpfile->gcount() > 0 )
         	{
				BRec->putBlob( 1, temp, offset, (void *)PCtemp );
				ThisError( BRec->lastError );
				}
			offset += temp;
			}

		BRec->closeBlob( 1, PXBLOBACCEPT );
		ThisError( BRec->lastError );

		BCur->appendRec( BRec );
		ThisError( BCur->lastError );

		BRec->dropBlob( 1 );
		ThisError( BRec->lastError );

		bmpfile->close();

		}

	delete bmpfile;
	delete PCtemp;

	delete BRec;
	delete BCur;
	delete BDb;
	if( !EngParm )
		delete Eng;
	delete Env;

	delete err;
	}
