#include "blbdeque.h"

BLOBCLASS::BLOBCLASS( char *tablename, BEngine *BLOBEngParm )
		: BI_IDequeAsDoubleList<char huge>()
	{
	err = new errorclassthing;


	BEngine 		*BLOBEng;
	BDatabase 	*BLOBBDb;
	BCursor   	*BLOBBCur;
   BRecord	 	*BLOBRec;
	struct BEnv *BLOBEnv;

	//if not passed BEngine pointer initialize engine
	//with instantiation of BEngine
	if ( !BLOBEngParm )
   	{
		BLOBEng = new BEngine;
		ThisError( BLOBEng->lastError );
		}
	else
		{
		BLOBEng = BLOBEngParm;
		//if passed an engine with an error condition
		ThisError( BLOBEng->lastError );
		}

	BLOBEnv = new BEnv;
	BLOBEng->getDefaults( *BLOBEnv );
	ThisError( BLOBEng->lastError );

	//change environment settings
	#ifdef _Windows
	BLOBEnv->engineType = pxWin;
	#endif

	//enforce change
	BLOBEng->setDefaults( *BLOBEnv );
	ThisError( BLOBEng->lastError );

	//open engine
	BLOBEng->open();
	ThisError( BLOBEng->lastError );

	BLOBBDb  = new BDatabase( BLOBEng );
	ThisError( BLOBBDb->lastError );

	BLOBBCur = new BCursor( BLOBBDb, tablename );
	ThisError( BLOBBCur->lastError );

	BLOBRec  = new BRecord( BLOBBCur );
	ThisError( BLOBRec->lastError );

	char filename[256];
	BOOL isnull = 1;
	long blobsize;
	long offset = 0;
	unsigned int temp = 0;

	BLOBBCur->gotoBegin();
   ThisError( BLOBBCur->lastError );

	BLOBBCur->gotoNext();
   ThisError( BLOBBCur->lastError );

	while( BLOBBCur->lastError == PXSUCCESS )
		{

		BLOBBCur->getRecord( BLOBRec );
	   ThisError( BLOBBCur->lastError );

		BLOBRec->getField( "Filenames", filename, 255, isnull);
		ThisError( BLOBRec->lastError );

		BLOBRec->openBlobRead( 1, FALSE );
		ThisError( BLOBRec->lastError );

		blobsize = BLOBRec->getBlobSize( 1 );
		ThisError( BLOBRec->lastError );

		char huge *HPtemp = new char huge [blobsize];

		offset = 0;
		while( blobsize )
			{
			if ( blobsize > MAXBLOBIO )
				{
				temp = MAXBLOBIO;
				blobsize -= MAXBLOBIO;
				}
			else
				{
				temp = blobsize;
				blobsize = 0;
				}
			BLOBRec->getBlob( 1, temp, offset, HPtemp + offset );
			ThisError( BLOBRec->lastError );
			offset += temp;
			}
		putRight( HPtemp );

		BLOBRec->closeBlob( 1 );
      ThisError( BLOBRec->lastError );

      BLOBRec->dropBlob( 1 );
		ThisError( BLOBRec->lastError );

		BLOBBCur->gotoNext();
		}

	if( BLOBBCur->lastError != PXERR_ENDOFTABLE )
		ThisError( BLOBBCur->lastError );


	delete BLOBRec;
	delete BLOBBCur;
	delete BLOBBDb;
	if( !BLOBEngParm )
		delete BLOBEng;
	delete BLOBEnv;
	}


