`/******************************************************************************
`   MODULE        :    dlgwnd.cpp
`   Version        :    2.0
`   Description    :    The base class for the main window.  This class is
`                    derived from CDialog and is intended to be used as
`                    a main window in an application using a dialog
`                    as it's main window.
`******************************************************************************/
`
`#include "stdafx.h"
`#include "dlgwnd.h"
`
`
`#ifdef _DEBUG
`    #undef THIS_FILE
`    static char BASED_CODE THIS_FILE[] = __FILE__;
`#endif
`
`#define new DEBUG_NEW
`
`
`/////////////////////////////////////////////////////////////////////////////
`// Message Map -- CDialogWinApp
`
`BEGIN_MESSAGE_MAP(CDialogWinApp, CDialog)
`    //{{AFX_MSG_MAP(CDialogWinApp)
`#if defined (_STATBAR) || defined (_ALLOPTIONS)
`    ON_COMMAND(ID_VIEW_STATUS_BAR, OnViewStatusBar)
`    ON_UPDATE_COMMAND_UI(ID_VIEW_STATUS_BAR, OnUpdateViewStatusBar)
`
`    ON_WM_ENTERIDLE()
`    ON_MESSAGE(WM_SETMESSAGESTRING, OnSetMessageString)
`    ON_WM_MENUSELECT()
`
`    // turning on and off standard mode indicators
`    ON_UPDATE_COMMAND_UI(ID_INDICATOR_CAPS, OnUpdateKeyIndicator)
`    ON_UPDATE_COMMAND_UI(ID_INDICATOR_NUM, OnUpdateKeyIndicator)
`    ON_UPDATE_COMMAND_UI(ID_INDICATOR_SCRL, OnUpdateKeyIndicator)
`#endif    //_STATBAR
`#if defined (_TOOLBAR) || defined (_ALLOPTIONS)
`    ON_COMMAND(ID_VIEW_TOOLBAR, OnViewToolbar)
`    ON_UPDATE_COMMAND_UI(ID_VIEW_TOOLBAR, OnUpdateViewToolbar)
`#endif    //_TOOLBAR
`#if defined (_CTL3D) || defined (_ALLOPTIONS)
`    ON_WM_SYSCOLORCHANGE()
`#endif    //_CTL3D
`    ON_WM_INITMENUPOPUP()
`#if defined (_HELP) || defined (_ALLOPTIONS)
`    ON_MESSAGE(WM_COMMANDHELP, OnCommandHelp)
`    ON_WM_DESTROY()
`#endif //_HELP
`    //}}AFX_MSG_MAP
`END_MESSAGE_MAP()
`
`/////////////////////////////////////////////////////////////////////////////
`// CDialogWinApp::CDialogWinApp
`//    This is the constructor for the CDialogWinApp class.  
`
`CDialogWinApp::CDialogWinApp()
`{
`#if defined (_STATBAR) || defined (_ALLOPTIONS)
`    m_nIDTracking    = 0;
`    m_nIDLastMessage = 0;
`
`    m_lpaIDStatusBar = NULL;
`    m_cIDStatusBar   = 0;
`#endif    //_STATBAR
`#if defined (_TOOLBAR) || defined (_ALLOPTIONS)
`    m_lpaIDToolBar   = NULL;
`    m_cIDToolBar     = 0;
`    m_nIDBitmap      = 0;
`#endif    //_TOOLBAR
`}
`
`/////////////////////////////////////////////////////////////////////////////
`// CDialogWinApp::Create
`//     Create actually creates the modeless dialog.
`#if defined (_STATBAR) || defined (_ALLOPTIONS)
`//    Statusbar information is saved for processesing during CDialogWinApp::OnInitDialog.
`#endif    //_STATBAR
`#if defined (_TOOLBAR) || defined (_ALLOPTIONS)
`//    Toolbar information is saved for processesing during CDialogWinApp::OnInitDialog.
`#endif    //_TOOLBAR
`
`BOOL CDialogWinApp::Create(UINT nIDTemplate
`#if defined (_STATBAR) || defined (_ALLOPTIONS)
`    , UINT FAR *lpaIDStatus, int cIDStatus
`#endif    //_STATBAR
`#if defined (_TOOLBAR) || defined (_ALLOPTIONS)
`    , UINT FAR *lpaIDToolbar, int cIDToolbar, UINT nIDBitmap
`#endif    //_TOOLBAR
`    , CWnd *pParent)
`{
`#if defined (_STATBAR) || defined (_ALLOPTIONS)
`    m_lpaIDStatusBar = lpaIDStatus;
`    m_cIDStatusBar   = cIDStatus;
`#endif    //_STATBAR
`#if defined (_TOOLBAR) || defined (_ALLOPTIONS)
`    m_lpaIDToolBar   = lpaIDToolbar;
`    m_cIDToolBar     = cIDToolbar;
`    m_nIDBitmap      = nIDBitmap;
`#endif    //_TOOLBAR
`    return CDialog::Create(nIDTemplate, pParent);
`}
`
`/////////////////////////////////////////////////////////////////////////////
`// CDialogWinApp::OnOK
`//    Overload this function so the main window gets destroyed when the
`//    user presses <ENTER>
`
`void CDialogWinApp::OnOK()
`{
`    CDialog::OnOK();        // Call baseclass so usercode gets called properly
`    DestroyWindow();
`    PostQuitMessage(0);
`}
`
`/////////////////////////////////////////////////////////////////////////////
`// CDialogWinApp::OnCancel
`//    Overload this function so the main window gets destroyed when the
`//    user presses <ESCAPE>
`
`void CDialogWinApp::OnCancel()
`{
`    CDialog::OnCancel();    // Call baseclass so usercode gets called properly
`    DestroyWindow();
`    PostQuitMessage(0);
`}
`
`/////////////////////////////////////////////////////////////////////////////
`// CDialogWinApp::PostNcDestroy
`
`void CDialogWinApp::PostNcDestroy()
`{
`    delete this;
`}
`#if defined (_HELP) || defined (_ALLOPTIONS)
`
`/////////////////////////////////////////////////////////////////////////////
`// CDialogWinApp support for context sensitive help.  This code is based
`//  on CFrameWnd::IsTracking and CFrameWnd::OnCommandHelp.
`
`BOOL CDialogWinApp::IsTracking() const
`{
`    return m_nIDTracking != 0 &&
`        m_nIDTracking != AFX_IDS_HELPMODEMESSAGE &&
`        m_nIDTracking != AFX_IDS_IDLEMESSAGE;
`}
`
`LRESULT CDialogWinApp::OnCommandHelp(WPARAM, LPARAM lParam)
`{
`    if (lParam == 0)
`    {
`        if (IsTracking())
`            lParam = HID_BASE_COMMAND + m_nIDTracking;
`        else
`            lParam = HID_BASE_RESOURCE + m_nIDHelp;
`    }
`    
`    if (lParam != 0)
`    {
`        AfxGetApp()->WinHelp(lParam);
`        return TRUE;
`    }
`    return FALSE;
`}
`
`void CDialogWinApp::OnDestroy()
`{
`    // If the main window is closing, tell WinHelp to close as well
`    if (AfxGetApp()->m_pMainWnd == this)
`        ::WinHelp(m_hWnd, NULL, HELP_QUIT, 0L);
`
`    CDialog::OnDestroy();
`}
`#endif //_HELP
`
`/////////////////////////////////////////////////////////////////////////////
`// CDialogWinApp::OnInitDialog
`//    OnInitDialog centers the dialog on the screen
`#if defined (_STATBAR) || defined (_ALLOPTIONS)
`//    Creates the status bar
`#endif    //_STATBAR
`#if defined (_TOOLBAR) || defined (_ALLOPTIONS)
`//    Creates the tool bar
`#endif    //_TOOLBAR
`
`BOOL CDialogWinApp::OnInitDialog()
`{
`    CDialog::OnInitDialog();
`#if defined (_CTL3D) || defined (_ALLOPTIONS)
`    Ctl3dSubclassDlgEx(m_hWnd, CTL3D_ALL);    // 3D controls for the main window
`#endif
`    
`    CenterWindow();
`
`#if defined (_STATBAR) || defined (_ALLOPTIONS)
`    // Create status bar at bottom of window
`    if (m_wndStatusBar.Create(this))
`    {
`        RepositionBars(0, 0xFFFF, 0);
`        m_wndStatusBar.SetIndicators(m_lpaIDStatusBar, m_cIDStatusBar);
`        OnSetMessageString(AFX_IDS_IDLEMESSAGE);
`    }
`#endif    //_STATBAR
`
`#if defined (_TOOLBAR) || defined (_ALLOPTIONS)
`    // Create toolbar at top of window
`    if (m_wndToolBar.Create(this) &&
`        m_wndToolBar.LoadBitmap(m_nIDBitmap) &&
`        m_wndToolBar.SetButtons(m_lpaIDToolBar, m_cIDToolBar))
`    {
`        RepositionBars(0, 0xFFFF, 0);
`    }
`    
`#endif
`    return TRUE;
`}
`
`/////////////////////////////////////////////////////////////////////////////
`// CDialogWinApp::OnInitMenuPopup
`//    OnInitMenuPopup updates the state of items on a popup menu.  This
`//    code is based on CFrameWnd::OnInitMenuPopup.
`
`void CDialogWinApp::OnInitMenuPopup(CMenu *pMenu, UINT, BOOL bSysMenu)
`{
`    if (!bSysMenu)
`    {
`        ASSERT(pMenu != NULL);
`
`        // check the enabled state of various menu items
`        CCmdUI state;
`        state.m_pMenu = pMenu;
`        ASSERT(state.m_pOther == NULL);
`        
`        state.m_nIndexMax = pMenu->GetMenuItemCount();
`        
`        for (state.m_nIndex = 0; state.m_nIndex < state.m_nIndexMax;
`            state.m_nIndex++)
`        {
`            state.m_nID = pMenu->GetMenuItemID(state.m_nIndex);
`            if (state.m_nID == 0)
`                continue; // menu separator or invalid cmd - ignore it
`            
`            ASSERT(state.m_pOther == NULL);
`            ASSERT(state.m_pMenu != NULL);
`            
`            if (state.m_nID == (UINT)-1)
`            {
`                // possibly a popup menu, route to first item of that popup
`                state.m_pSubMenu = pMenu->GetSubMenu(state.m_nIndex);
`                
`                if (state.m_pSubMenu == NULL ||
`                    (state.m_nID = state.m_pSubMenu->GetMenuItemID(0)) == 0 ||
`                    state.m_nID == (UINT)-1)
`                {
`                       continue;       // first item of popup can't be routed to
`                }
`                state.DoUpdate(this, FALSE);    // popups are never auto disabled
`             }
`            else
`            {
`                // normal menu item
`                // Auto enable/disable if command is _not_ a system command.
`                state.m_pSubMenu = NULL;
`                state.DoUpdate(this, state.m_nID < 0xF000);
`            }
`        }
`    }
`}
`                                
`#if defined (_STATBAR) || defined (_ALLOPTIONS)
`/////////////////////////////////////////////////////////////////////////////
`// CDialogWinApp::OnViewStatusBar
`//    OnViewStatusBar toggles the state of the status bar when the 
`//    corresponding View option is selected from the menu.  
`
`void CDialogWinApp::OnViewStatusBar()
`{
`    m_wndStatusBar.ShowWindow(m_wndStatusBar.IsWindowVisible() ? SW_HIDE : SW_SHOWNA);
`}
`
`/////////////////////////////////////////////////////////////////////////////
`// CDialogWinApp::OnUpdateViewStatusBar
`//    OnUpdateViewStatusBar checks or unchecks the View Status Bar option
`//    on the dialog's menu, depending on whether or not the status bar
`//    is visible.
`
`void CDialogWinApp::OnUpdateViewStatusBar(CCmdUI* pCmdUI)
`{
`    ASSERT(pCmdUI->m_nID == ID_VIEW_STATUS_BAR);
`
`    pCmdUI->SetCheck(m_wndStatusBar.IsWindowVisible());
`}
`
`/////////////////////////////////////////////////////////////////////////////
`// CDialogWinApp::OnEnterIdle
`//    OnEnterIdle updates the status bar when there is nothing better
`//    to do.  This code is based on CFrameWnd::OnEnterIdle.
`
`void CDialogWinApp::OnEnterIdle(UINT nWhy, CWnd * /*pWho*/)
`{
`    if (nWhy != MSGF_MENU || m_nIDTracking == m_nIDLastMessage)
`        return;
`
`    OnSetMessageString(m_nIDTracking);
`    ASSERT(m_nIDTracking == m_nIDLastMessage);
`}
`
`/////////////////////////////////////////////////////////////////////////////
`// CDialogWinApp::OnMenuSelect
`//    OnMenuSelect updates the status bar message, based on the state
`//    of the dialog menu.  This code is based on CFrameWnd::OnMenuSelect.
`
`void CDialogWinApp::OnMenuSelect(UINT nItemID, UINT nFlags, HMENU /*hSysMenu*/)
`{
`    // set the tracking state
`    if (nFlags == 0xFFFF)
`    {
`        // cancel menu operation (go back to idle now)
`        m_nIDTracking = AFX_IDS_IDLEMESSAGE; 
`        OnSetMessageString(m_nIDTracking);   // set string now
`        ASSERT(m_nIDTracking == m_nIDLastMessage);
`    }
`    else if (nItemID == 0 || nFlags & (MF_SEPARATOR|MF_POPUP|MF_MENUBREAK|MF_MENUBARBREAK))
`    {
`        // nothing should be displayed
`        m_nIDTracking = 0;
`    }
`    else if (nItemID >= 0xF000 && nItemID < 0xF1F0)
`    {
`        // special string table entries for system commands
`        m_nIDTracking = ID_COMMAND_FROM_SC(nItemID);
`        
`        ASSERT(m_nIDTracking >= AFX_IDS_SCFIRST &&
`            m_nIDTracking < AFX_IDS_SCFIRST + 31);
`    }
`    else
`    {
`        // track on idle
`        m_nIDTracking = nItemID;
`    }
`}
`
`/////////////////////////////////////////////////////////////////////////////
`// CDialogWinApp::OnSetMessageString
`//    OnSetMessageString updates the status bar text.  This code is 
`//    based on CFrameWnd::OnSetMessageString.  We assume a string ID
`//    is always passed in wParam.
`
`LRESULT CDialogWinApp::OnSetMessageString(WPARAM wParam, LPARAM /*lParam*/)
`{
`    UINT    nIDMsg = (UINT)wParam;
`    CString strMsg;
`
`    if (wParam)
`    {
`        if (strMsg.LoadString(nIDMsg) != 0) 
`            m_wndStatusBar.SetWindowText(strMsg);
`        else
`            TRACE1("Warning: no message line prompt for ID 0x%04X\n", nIDMsg);
`    }
`    
`    UINT nIDLast = m_nIDLastMessage;
`    m_nIDLastMessage = nIDMsg;
`    m_nIDTracking = nIDMsg;
`    
`    return nIDLast;
`}
`
`/////////////////////////////////////////////////////////////////////////////
`// CDialogWinApp::OnUpdateKeyIndicator
`//    OnUpdateKeyIndicator updates the status bar indicators.  This code is 
`//    based on CFrameWnd::OnUpdateKeyIndicator.
`
`void CDialogWinApp::OnUpdateKeyIndicator(CCmdUI* pCmdUI)
`{
`    UINT nVK;
`
`    switch (pCmdUI->m_nID)
`    {
`    case ID_INDICATOR_CAPS:
`        nVK = VK_CAPITAL;
`        break;
`
`    case ID_INDICATOR_NUM:
`        nVK = VK_NUMLOCK;
`        break;
`
`    case ID_INDICATOR_SCRL:
`        nVK = VK_SCROLL;
`        break;
`
`    default:
`        TRACE1("Warning: OnUpdateKeyIndicator - unknown indicator 0x%04X\n",
`            pCmdUI->m_nID);
`        pCmdUI->ContinueRouting();
`        return; // not for us
`    }
`
`    pCmdUI->Enable(::GetKeyState(nVK) & 1);
`        // enable static text based on toggled key state
`    ASSERT(pCmdUI->m_bEnableChanged);
`}
`
`/////////////////////////////////////////////////////////////////////////////
`// Message Map -- CDlgStatusBar
`
`BEGIN_MESSAGE_MAP(CDlgStatusBar, CStatusBar)
`    //{{AFX_MSG_MAP(CDlgStatusBar)
`    ON_MESSAGE(WM_IDLEUPDATECMDUI, OnIdleUpdateCmdUI)
`    //}}AFX_MSG_MAP
`END_MESSAGE_MAP()
`
`/////////////////////////////////////////////////////////////////////////////
`// CDlgStatusBar::OnIdleUpdateCmdUI
`//    OnIdleUpdateCmdUI handles the WM_IDLEUPDATECMDUI message, which
`//    is used to update the status of user-interface elements within
`//    the MFC framework.  We have to get a little tricky here:
`//    CStatusBar::OnUpdateCmdUI expects a CFrameWnd pointer as its first
`//    parameter.  However, it does not appear to do anything but pass
`//    the parameter on to another function which only requires a 
`//    CCmdTarget pointer.  We can get a CWnd pointer to the parent 
`//    window, which is a CCmdTarget, but may not be a CFrameWnd.  So,
`//    to make CStatusBar::OnUpdateCmdUI happy, we will call our CWnd pointer
`//    a CFrameWnd pointer.
`
`LRESULT CDlgStatusBar::OnIdleUpdateCmdUI(WPARAM wParam, LPARAM)
`{
`    if (IsWindowVisible())
`    {
`        CFrameWnd *pParent = (CFrameWnd *)GetParent();
`        if (pParent)
`            OnUpdateCmdUI(pParent, (BOOL)wParam);
`    }
`    return 0L;
`}
`
`#endif    // _STATBAR
`#if defined (_TOOLBAR) || defined (_ALLOPTIONS)
`
`/////////////////////////////////////////////////////////////////////////////
`// CDialogWinApp::OnViewToolbar
`//    OnViewToolbar toggles the state of the tool bar when the 
`//    corresponding View option is selected from the menu.  
`
`void CDialogWinApp::OnViewToolbar()
`{
`    m_wndToolBar.ShowWindow(m_wndToolBar.IsWindowVisible() ? SW_HIDE : SW_SHOWNA);
`}
` 
`/////////////////////////////////////////////////////////////////////////////
`// CDialogWinApp::OnUpdateViewToolbar
`//    OnUpdateViewToolbar checks or unchecks the View Tool Bar option
`//    on the dialog's menu, depending on whether or not the tool bar
`//    is visible.
`
`void CDialogWinApp::OnUpdateViewToolbar(CCmdUI* pCmdUI)
`{
`    ASSERT(pCmdUI->m_nID == ID_VIEW_TOOLBAR);
`
`    pCmdUI->SetCheck(m_wndToolBar.IsWindowVisible());
`}
`
`/////////////////////////////////////////////////////////////////////////////
`// Message Map -- CDlgToolBar
`
`BEGIN_MESSAGE_MAP(CDlgToolBar, CToolBar)
`    //{{AFX_MSG_MAP(CDlgToolBar)
`    ON_MESSAGE(WM_IDLEUPDATECMDUI, OnIdleUpdateCmdUI)
`    //}}AFX_MSG_MAP
`END_MESSAGE_MAP()
`
`/////////////////////////////////////////////////////////////////////////////
`// CDlgToolBar::OnIdleUpdateCmdUI
`//    OnIdleUpdateCmdUI handles the WM_IDLEUPDATECMDUI message, which
`//    is used to update the status of user-interface elements within
`//    the MFC framework.  We have to get a little tricky here:
`//    CToolBar::OnUpdateCmdUI expects a CFrameWnd pointer as its first
`//    parameter.  However, it does not appear to do anything but pass
`//    the parameter on to another function which only requires a 
`//    CCmdTarget pointer.  We can get a CWnd pointer to the parent 
`//    window, which is a CCmdTarget, but may not be a CFrameWnd.  So,
`//    to make CToolBar::OnUpdateCmdUI happy, we will call our CWnd pointer
`//    a CFrameWnd pointer.
`
`LRESULT CDlgToolBar::OnIdleUpdateCmdUI(WPARAM wParam, LPARAM)
`{
`    if (IsWindowVisible())
`    {
`        CFrameWnd *pParent = (CFrameWnd *)GetParent();
`        if (pParent)
`            OnUpdateCmdUI(pParent, (BOOL)wParam);
`    }
`    return 0L;
`}
`
`#endif    //_TOOLBAR
`
`#if defined (_CTL3D) || defined (_ALLOPTIONS)
`void CDialogWinApp::OnSysColorChange()
`{
`    Ctl3dColorChange();
`    
`    // TODO: Add your message handler code here
`}
`#endif    //_CTL3D
