/*********************************************************************
* Function: DLFONT.C
* Purpose: A clipper function to download a binary font file to the
*          HPLJ II/III printer.
* Compile: cl /c /AL /Gs /Oalt dlfont.c (for clipper linking)
* Written: 24 June 1990
* By: Buck Webb
* Modification History
* Date     Programmer   Modification
* 06/24/90 Buck Webb		Initial Write.
*
*********************************************************************/

#include <io.h>    		/* For open/close/read/write/eof */
#include <fcntl.h> 		/* For open mode arguments */
#include <sys\types.h>  /* For file types */
#include <sys\stat.h>   /* For file status flags */
#include <stdio.h>      /* for error, information, and parse of bat file */
#include <nandef.h>     /* Clipper Defs. Only needed for def of byte */
#include <extend.h>     /* Clipper Defs. Only needed for the Ret() */
#include <string.h>     /* string tokenizer stuff */

char prefont[7] = { 0x1B, 0x2A, 0x63, 0x20, 0x20, 0x44, 0x00 }; /* <Esc>*c10D */
char makperm[6] = { 0x1B, 0x2A, 0x63, 0x35, 0x46, 0x00 };     /* <esc>*c5F */
char selfont[6] = { 0x1B, 0x28, 0x20, 0x20, 0x58, 0x00 };     /* <esc>(10X */
char path[10];
char fontid[3];
char srcfile[32];
char fntfile[32];
char batname[32];
FILE *batfile;

int getname();

CLIPPER dlfont()                  /* CLIPPER req'd for clipper link, */
                                  /* use int */
{
		int source, target; 			/* file handles */
		char buffer[1024];			/* buff for file i/o ops */
		int bytes_read;				/* holds actual count of bytes read */

		batname[0]=0x00;
		strcpy(path,"C:\\FONTS\\");            /* set up the path */
		strcpy(batname,path);
		strcat(batname,"DLFONTS.BAT");  /*The batch for fonts*/
      /* For the tokenizer to work, the format must be as follows:   */
      /* DOWNLOAD XXXXXX.XXX,fontid                                  */
      /* Example: DOWNLOAD tr14bld.sfp,27                           */
      /*          would set tr14bld as font # 27, permanent         */
      /* Get and setup the first font file, and discover its font id */
		/* All fonts are assumed to be Permanent, though this can be changed */

		if (! (batfile = fopen(batname,"r")))
			{
			fclose(batfile);
			_retl(FALSE);   /* Return Failure to Caller */
                         /* To use in straight C, give back FALSE via return */
			return;
			}

		while (!getname())   /* While there are files in batch to process.. */
			{
			if ((source = open(srcfile, O_BINARY | O_RDONLY)) == -1)
				{
				    close(source);
					_retl(FALSE);  /* Return Failure to Caller */
				   return;
					}
			else if ((target = open("PRN", O_BINARY | O_WRONLY)) == -1)
				{
				    close(target);
					_retl(FALSE);   /* Return Failure to Caller */
				   return;
					}
			else
				{
				prefont[3] = fontid[0];
				prefont[4] = fontid[1];
				write(target,prefont,sizeof(prefont));   /*Write Font DL Command */
				while (!eof(source))
					{
					if ((bytes_read = read(source,buffer,sizeof(buffer))) <= 0)
						{
						close(source);
						_retl(FALSE);   /* Return a failure */
					   return;
						}
					else
						if (write(target, buffer, bytes_read) != bytes_read)
						{
						    close(target);
							_retl(FALSE); /* Return a failure */
						   return;
							}
			    	}
					close(source);
					write(target,makperm,sizeof(makperm));  /*Write Make Perm Command */
					selfont[2] = fontid[0];
					selfont[3] = fontid[1];
					write(target,selfont,sizeof(selfont));  /*Select This new Font */
					close(target);
				}
			}
		fclose(batfile);
		_retl(TRUE);        /* return a success */
		return;
}
/*End of dlfont.c*/
/***************************Function getname***************************/
int getname()
/* A fn to read the batch file, and get the source file name and font id */
{
	char linein[50], token[20];
   char tempval[15];

	tempval[0] = 0x00;
	linein[0] = 0x00;
	token[0] = 0x00;
   
	strcpy(tempval,"DOWNLOAD");  /* set up the compare string */

	if (!feof(batfile))
	{
		fgets(linein,sizeof(linein),batfile);
		strcpy(linein,strupr(linein));
		strcpy(token,strtok(linein," ,"));
		if (strcmp(token,tempval) != 0)     		/* At end of download commands */
			return (1);
		strcpy(srcfile,path);
		strcat(srcfile,strtok(NULL," ,")); 	 	/* Next should be file name */
		strcpy(fontid,strtok(NULL," ,")); 		/* should be the font id */
		return(0);
	}
}
/* end of fn getname */


