/*
  (c) Copyright 1992 Eric Backus

  This software may be used freely so long as this copyright notice is
  left intact.  There is no warrantee on this software.
*/

#include <grp.h>
#include <string.h>		/* For strcmp() */
#include <stdlib.h>		/* For getenv(), getgid() */

static struct group	gr;
static char		*null_ptr = NULL;
static int              counter = 0;

static void
fill_in()
{
    char	*p;

    p = getenv("GROUP");
    if (p)
	gr.gr_name = p;
    else
	gr.gr_name = "other";

    gr.gr_passwd = "*";
    gr.gr_gid = getgid();
    gr.gr_mem = &null_ptr;
}

struct group *
getgrent(void)
{
    if (counter == 0)
    {
	counter++;
	fill_in();
	return &gr;
    }
    return NULL;
}

struct group *
fgetgrent(FILE *f)
{
    if (counter == 0)
    {
	counter++;
	fill_in();
	return &gr;
    }
    return NULL;
}

struct group *
getgrgid(int gid)
{
    fill_in();
    if (gr.gr_gid == gid) return &gr;
    return NULL;
}

struct group *
getgrnam(char *name)
{
    fill_in();
    if (strcmp(gr.gr_name, name) == 0) return &gr;
    return NULL;
}

void
setgrent(void)
{
  counter = 0;
}

void
endgrent(void)
{
  counter = 0;
}
