/*   fnsplit.c replacement for Borland version pjbk */

#include <dir.h>
#include <ctype.h>
#include <string.h>

int fnsplit (const char *path, char *drive, char *dir, 
	     char *name, char *ext)
{
  int flags = 0, len;
  const char *pp, *pe;

  if ( drive ) *drive = '\0'; /* clear out any previous contents */
  if ( dir ) *dir = '\0';
  if ( name ) *name = '\0';
  if ( ext ) *ext = '\0';

  pp = path;
  if( isalpha( *pp) && (pp[1] == ':'))
    {
      flags |= DRIVE;
      if ( drive )
	{
	  strncpy( drive, pp, 2);
	  drive[2] = '\0';
	}
      pp += 2;
    }
  pe = strrchr( pp, '\\'); /* find terminating \ */
  if ( pe ) 
    { 
      flags |= DIRECTORY ;
      pe++;
      len = pe - pp;
      if ( dir )
	{
	  strncpy( dir, pp, len);
	  dir[len] = '\0';
	}
      pp = pe;
    }
  pe = strrchr( pp, '.'); /* find separator */
  if ( pe )
    {
      flags |= EXTENSION;
      if ( ext ) 
	{
	  strcpy( ext, pe);
	}
    }
  else 
    pe = strchr( pp, '\0');
  if ( pp != pe )
    {
      flags |= FILENAME;
      len = pe - pp;
      if ( name ) 
	{
	  strncpy( name, pp, len);
	  name[len] = '\0';
	}
    }
  if ( strchr( pp, '*') || strchr( pp, '?'))
    flags |= WILDCARDS;
  return flags;
  
}
