/* This is file TMPNAM.C */
/* This file may have been modified by DJ Delorie (Jan 1991).  If so,
** these modifications are Coyright (C) 1993 DJ Delorie, 24 Kirsten Ave,
** Rochester NH, 03867-2954, USA.
*/

/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted provided
 * that: (1) source distributions retain this entire copyright notice and
 * comment, and (2) distributions including binaries display the following
 * acknowledgement:  ``This product includes software developed by the
 * University of California, Berkeley and its contributors'' in the
 * documentation or other materials provided with the distribution and in
 * all advertising materials mentioning features or use of this software.
 * Neither the name of the University nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)tmpnam.c	4.8 (Berkeley) 6/22/90";
#endif /* LIBC_SCCS and not lint */

#include <sys/param.h>
#include <sys/types.h>
#include <stdio.h>

#ifndef P_tmpdir
#define	P_tmpdir	"/usr/tmp"
#endif

typedef struct FILE_a {
  char *name;
  struct FILE_a *next;
} FILE_a;

static int close_registered=0;
static FILE_a *file_a=0;
static void tmp_close()
{
  while (file_a)
  {
    FILE_a *n = file_a->next;
    unlink(file_a->name);
    free(file_a->name);
    free(file_a);
    file_a = n;
  }
}

FILE *
tmpfile()
{
	FILE *fp;
	FILE_a *filea;
	char *f, *tmpnam();

	if (!(f = tmpnam((char *)NULL)) || !(fp = fopen(f, "w+"))) {
		fprintf(stderr, "tmpfile: cannot open %s.\n", f);
		return(NULL);
	}
	if (close_registered == 0)
	{
	  atexit(tmp_close);
	  close_registered = 1;
	}
	filea = (FILE_a *)malloc(sizeof(FILE_a));
	if (filea)
	{
	  filea->name = strdup(f);
	  filea->next = file_a;
	  file_a = filea;
	}
	return(fp);
}

static char *tmpnam_buf;

char *
tmpnam(s)
	char *s;
{
	char *malloc(), *mktemp();

	if (!s)
	{
	  if (tmpnam_buf == 0)
	  tmpnam_buf = malloc((u_int)MAXPATHLEN);
	  if (tmpnam_buf == 0)
	    return(NULL);
	  s = tmpnam_buf;
	}
	(void)sprintf(s, "%s/XXXXXX", P_tmpdir);
	return(mktemp(s));
}

char *
tempnam(dir, pfx)
	char *dir, *pfx;
{
	char *f, *name, *getenv(), *malloc(), *mktemp();

	if (!(name = malloc((u_int)MAXPATHLEN)))
		return(NULL);

	if (f = getenv("TMPDIR")) {
		(void)sprintf(name, "%s/%sXXXXXX", f, pfx ? pfx : "");
		if (f = mktemp(name))
			return(f);
	}
	if (dir) {
		(void)sprintf(name, "%s/%sXXXXXX", dir, pfx ? pfx : "");
		if (f = mktemp(name))
			return(f);
	}
	(void)sprintf(name, "%s/%sXXXXXX", P_tmpdir, pfx ? pfx : "");
	if (f = mktemp(name))
		return(f);
	(void)sprintf(name, "/tmp/%sXXXXXX", pfx ? pfx : "");
	if (!(f = mktemp(name)))
		(void)free(name);
	return(f);
}
