//
// $Header$
// $Log$
//
// Copyright 1991
//
// Objective Systems, Inc.
//  Richard A. Doust        3/13/91
//  Phone:                  (201) 335-0691
//

#include <ui_win.hpp>
#include <pxengine.h>
#include <pdxpp.h>
#include "menu.hpp"

#define BUFSIZ 128

/*
 * This file contains the implementation of a Menu Object which is
 * persistent.  That is, it is stored external to the application itself.
 * It is stored in a set of Paradox tables.
 */

// Initialization of the static members of PxMenu

PXTABLE PxMenu::MenuTable("menutabl");
PXTABLE PxMenu::MenuItemTable("menuitem");

// Constructor
//
// PxMenu  char *menu       name of parent menu item
//         void(*userFunc)  address of a function which should be notified
//                          when a menu item is selected
            
PxMenu::PxMenu(char *menu, void(*userFunc)(void *item, UI_EVENT &event))
: UIW_PULL_DOWN_MENU(0, WOF_NO_FLAGS, WOAF_NO_FLAGS)
{
USHORT val;
char avalue[BUFSIZ];

    PXFIELD MenuName(MenuTable, "MenuName");

    PXRECORD SearchRec(MenuTable);
    SearchRec.Put(MenuName.FldHandle(), menu);
    if (SearchRec.SrchKey(1) == PXSUCCESS)
    {
        PXFIELD MenuId(MenuTable, "MenuId");
        SearchRec.RecGet();
        SearchRec.Get(MenuId.FldHandle(), (short)val);
    }
    else
        return;

    PXRECORD SearchItems(MenuItemTable);
    PXFIELD ParMenuId(MenuItemTable, "ParentMenuId");
    SearchItems.Put(ParMenuId, (short)val);

    PXFIELD MenuItemText(MenuItemTable, "MenuItemText");
    PXFIELD MenuItemId(MenuItemTable, "MenuItemId");
    if (SearchItems.SrchFld(ParMenuId) != PXERR_RECNOTFOUND)
    {
        USHORT id;
        for (USHORT parent = val; ; )
        {
            SearchItems.RecGet();
            SearchItems.Get(ParMenuId, (short)parent);
            if (val != parent)
                break;

            SearchItems.Get(MenuItemText.FldHandle(), BUFSIZ, avalue);
            SearchItems.Get(MenuItemId.FldHandle(), (short)id);
            *this + SubMenu(avalue, id, userFunc);
            SearchItems.Next();
        }
    } 
    return;
}

UIW_PULL_DOWN_ITEM *PxMenu::SubMenu(char *name, USHORT id,
                    void (*userFunc)(void *item, UI_EVENT &event))
{
char avalue[BUFSIZ];

    UIW_PULL_DOWN_ITEM *pItem = new UIW_PULL_DOWN_ITEM(name,
            MNF_NO_FLAGS, 0);

    CurRec = MenuItemTable.RecNum();

    PXRECORD SearchItems(MenuItemTable);
    PXFIELD ParMenuId(MenuItemTable, "ParentMenuId");
    SearchItems.Put(ParMenuId, (short)id);

    PXFIELD MenuItemText(MenuItemTable, "MenuItemText");
    PXFIELD MenuId(MenuItemTable, "MenuItemId");
    if (SearchItems.SrchFld(ParMenuId) != PXERR_RECNOTFOUND)
    {
        USHORT MenuValue;
        for (USHORT parent = id; SearchItems.Result() != PXERR_ENDOFTABLE; )
        {
            SearchItems.RecGet();
            SearchItems.Get(ParMenuId, (short)parent);
            if (id != parent)
                break;

            SearchItems.Get(MenuItemText.FldHandle(), BUFSIZ, avalue);
            SearchItems.Get(MenuId.FldHandle(), (short)MenuValue);
            *pItem + new PxSubMenuItem(avalue, MNIF_NO_FLAGS, 
                    BTF_NO_TOGGLE, WOF_NO_FLAGS, userFunc, MenuValue);
            SearchItems.Next();
        }
    }
    MenuItemTable.RecGoto(CurRec); 
    return pItem;
}


PxSubMenuItem::PxSubMenuItem(char *name, USHORT mniFlags, USHORT btFlags,
            USHORT woFlags, void (*userFunc)(void *item, UI_EVENT &event),
            USHORT id) : UIW_POP_UP_ITEM(name, mniFlags, btFlags, woFlags,
            userFunc)
{
    MenuId = id;
}