//
// $Header$
// $Log$
//
// Copyright 1991
//
// Objective Systems, Inc.
//  Richard A. Doust        3/13/91
//  Phone:                  (201) 335-0691
//

#include <string.h>
#include <ui_win.hpp>
#include <pxengine.h>
#include <pdxpp.h>
#include "magdlg.hpp"

/**********************************************************************/
// Constructor
//
// This dialog box allows data entry/edit of the Magazine Names in the
// code table.
//
/**********************************************************************/
MagazineDialog::MagazineDialog(void) 
: UIW_WINDOW(2, 5, 54, 12, WOF_NO_FLAGS, NO_HELP_CONTEXT), 
CodeTable("codedata"),
CodeRec(CodeTable),
FldNameFld(CodeTable, "FieldName"),
DispVerFld(CodeTable, "DisplayVersion"),
ValFld(CodeTable, "CodeValue")
{
    *this
        + new UIW_BORDER
        + new UIW_MAXIMIZE_BUTTON
        + new UIW_MINIMIZE_BUTTON
        + new UIW_SYSTEM_BUTTON
        + new UIW_TITLE(" Code Table : Magazines", WOF_NO_FLAGS)
        + (DispVerList = new UIW_WINDOW(27, 6, 26, 10, WOF_NO_FLAGS,
                NO_HELP_CONTEXT))
    ;

    if (CodeTable.Result() != PXSUCCESS)
        error = TRUE;
    else
        error = FALSE;
}

/**********************************************************************/
//
// This is the method that processes events for the dialog.  The events
// handled are:
//
/**********************************************************************/
int  MagazineDialog::Event(const UI_EVENT &event)
{
UI_EVENT tevent;

    switch (event.type)
    {

        default:
            UIW_WINDOW::Event(event);
            break;

    }

    if (error)
    {
        _errorSystem->ReportError(windowManager, -1, "Code Table error.");
        error = FALSE;
        UI_EVENT tevent;
        tevent.type = S_DELETE_LEVEL;
        eventManager->Put(tevent, Q_BEGIN);
    }

    return 0;
}

