/************ declarations from sgint.c ***********/

extern void init_SG_interrupt( void(* sega_switcher)(), /* NULL if no sega/video   */
			void(* glove_handler)(), /* NULL if no glove driver */
			int glove_tc);           /* 1.19*uS (test interval) */

/*
 sega_switcher is called just before the vertical retrace
 use NULL if no video synchronization desired

 glove_handler is called once or more per screen time
 use NULL if not required

 glove_tc is period in timer clocks (1.19 * microseconds) desired between
 glove_handler calls.  If sega_switcher is also used, this will be an
 integer number per screen time.  Use 6500 for best results, as this
 gives the least glitches (2xscreen for 72 Hz, 3xscreen for 60 Hz VGA cards

/***** GLOVE DATA SPECIFICATIONS **************

x =   X position, 3mm per number
y =   Y position, 3mm per number
z =   distance,  14mm per number
rot = wrist twist. 0 is up 1 is slightly CW, 5 is down,
      11 is slightly CCW.
      About 30 to 40 degrees per count.

 Note: exact scaling of all above change with distance! Closer is higher res.

fingers = packed 2-bit values, 0 is open, 3 is (tight) fist:
    Bit format: TtIiMmRr  for Thumb, Index, Middle, and Ring fingers.

keys: $FF or $80 is no key. Responds with 0 to 9 for keys "0" thru "9"
      $82 = START, $83 = SEL, $0A = "A", $0B = "B", 0 is "Center"
      Up,down,left,right are $0D,$0E,$0C,$0F respectively.

gstat1, gstat2 are dummies
rxflags is valid ONLY after glove_ready returns 2.
		Also available in glove_rx_flags

nmissed is number of reads since last glove_read call

**********************************************/

typedef struct glove_data {
	signed char x,y,z,rot,fingers,keys,gstat1,gstat2,rxflags;
	unsigned int nmissed;  /* number of samples missed */
	} glove_data;

/* prototypes */

extern void getglove (glove_data *);	/* get data packet from glove */
extern int  glove_ready(void);		/* returns 0 if not ready     */
				/*         1 if data ready    */
				/*         2 if rxflags also valid */
#define DEGLITCH   1
#define NODEGLITCH 0
extern void glove_init(int gdeg); 	/* sets up glove, enters hires mode    */
				/* gdeg switches deglitching on or off */

extern int glove_read(glove_data *g);  /* reads glove data, with de-glitching */

extern void glove_int_handler();       /* int handler: pass as argument to SGinit */

extern int glove_rx_flags;  /* updated 10 mS after data: 0x3F if good */
extern int glove_rx_try;    /* # of slow reads: rx_flags valid if try>0 */


/**************** SEGA SUPPORT ****************/

extern int left_page;   /* video page with current left image */
extern int right_page;  /* video page with current right image */
extern int rs232_port_adr;    /* set for com1: 0x3fc, com2: 0x2fc */


extern void switch_sega();     /* video, glasses switcher: pass to SGinit */

extern void sega_off();        /* turn off glasses at exit (longer life) */

