/* Written by Bernie Roehl, January 1992 */
/* Redone by Dave Stampe for integer, fast polys, colors etc */
/* Modified by Bernie Roehl to support surface types */

/* Copyright 1992 by Dave Stampe and Bernie Roehl.
   May be freely used to write software for release into the public domain;
   all commercial endeavours MUST contact Bernie Roehl and Dave Stampe
   for permission to incorporate any part of this software into their
   products!
 */

/* Contact: broehl@sunee.waterloo.edu or dstampe@sunee.waterloo.edu */

#include <stdio.h>
#include <graphics.h>
#include <dos.h>
#include "rend386.h"

extern int set_colors();        /* defined in color file */
extern int reset_colors();
extern int screen_clear_color;
extern int wireframe_color;
extern int highlight_color;
extern int highest_color;


enter_graphics()               /* enter and setup graphics screen */
{
	int i;

	set_gmode();
	set_vidpage(0,0);
	set_drawpage(0);
	clr_page(0,0);
	set_colors();

	return(0);
}


exit_graphics()			/* exit and restore text screen */
{
	exit_gmode();
	reset_colors();
	return 0;
}

void clear_display(int pge)
{
	clr_page(pge,screen_clear_color);
}



void ptpoly(int count, int *pcoords, int color)
{
	void fastpoly(int count, int *pcoords);
	int surface_type = (color>>12)&3;

	color &= 0xFFF;

	switch (surface_type) {
		case 0:
		case 1:
			load_color (color);
			fastpoly(count, pcoords);
			break;
		case 2:
			m_fastpoly(count, pcoords, color, 0xFF, 0x00);
			break;
		case 3:
			m_fastpoly(count, pcoords, color, 0xAA, 0xFF);
			break;
		}
}

/********************************************************/
/* USER ROUTINES CALLED BY THE RENDERING LIBRARY        */
/* KEEP THIS AS FAST AS POSSIBLE: SOME MAY BE           */
/* CALLED UP TO 1000 TIMES PER SCREEN!                  */
/********************************************************/

extern int wireframe;

/* USER ROUTINE TO SETUP FOR POLY DRAWING - CALLED ONCE PER FRAME */
void user_setup_blitter()
{
	setup_hdwe(0);
}

/* USER ROUTINE TO RECOVER AFTER POLY DRAWING: ONCE PER FRAME */
void user_reset_blitter()
{
	reset_hdwe();
}


/* USER ROUTINE TO DRAW TEXT BOXES */
void user_box(int x1, int y1, int x2, int y2, int color)
{
	setup_hdwe(0);
	load_color(color);

	if (x1 < 0) x1 = 0; if (x2 < 0) x2 = 0;
	if (y1 < 0) y1 = 0; if (y2 < 0) y2 = 0;
	if (x1 > 319) x1 = 319; if (x2 > 319) x2 = 319;
	if (y1 > 199) y1 = 199; if (y2 > 199) y2 = 199;

	fastri(x1,y1,x1,y2,x2,y1);
	fastri(x2,y2,x2,y1,x1,y2);
	reset_hdwe();
}

/* USER ROUTINE TO DRAW TEXT */
void user_text(int x, int y, int color, char *string)
{
	printxyc(x, y, color, string);
}


static int x1, y1;
static void vlineto(int x, int y, int color)
{
	vgaline(x,y,x1,y1,color);
	x1 = x; y1 = y;
}

/* CALLED FROM HIREND TO DRAW POLYS */

void user_render_poly(int number, int *pcoords,
		      int color, long maxz)
{
	int i;

	if (number == 2)
		{
		vgaline(pcoords[0],pcoords[1],pcoords[2],pcoords[3],color);
		return;
		}
	if (!wireframe)
		{
		ptpoly(number, pcoords, color);

		if (color & 0x8000)			 /* highlighted? */
			{
			x1 = pcoords[0];
			y1 = pcoords[1];
			for (i = 1; i < number; ++i) vlineto(pcoords[i+i], pcoords[i+i+1], highlight_color);
			vlineto(pcoords[0], pcoords[1], highlight_color);
		}
	}
	else
		{
		x1 = pcoords[0];
		y1 = pcoords[1];
		for (i = 1; i < number; ++i) vlineto(pcoords[i+i], pcoords[i+i+1], wireframe_color);
			vlineto(pcoords[0], pcoords[1], wireframe_color);
		}
}

void vgabox(int left, int top, int right, int bottom, int color)
{
	setup_hdwe(0);
	vgaline(left, top, right, top, color);
	vgaline(right, top, right, bottom, color);
	vgaline(right, bottom, left, bottom, color);
	vgaline(left, bottom, left, top, color);
	reset_hdwe();
}
