/* Definition for a generic 3-D pointing device */

/* Written by Bernie Roehl, February 1992 */

/* Copyright 1992 by Dave Stampe and Bernie Roehl.
   May be freely used to write software for release into the public domain;
   all commercial endeavours MUST contact Bernie Roehl and Dave Stampe
   for permission to incorporate any part of this software into their
   products!
 */

typedef struct {
	long x, y, z;          /* location in world coordinates */
	long pan, tilt, roll;  /* orientation around x, y, z */
	unsigned buttons;      /* 16 bits */
	unsigned gesture;      /* for future expansion */
	int port;              /* in case we need this */
	long sx, sy, sz;       /* scaling factors */
	int flex[16];          /* up to 16 words of flexion information */
	} POINTER;

extern pointer_init(int port, POINTER *pointer);
extern pointer_read(POINTER *pointer);
extern void pointer_scale(POINTER *pointer, long sx, long sy, long sz);
extern void pointer_quit(POINTER *pointer);
extern void pointer_move(POINTER *pointer, long x, long y, long z);

/* End of pointer.h */
