/* PLG file i/o */

/* Written by Bernie Roehl, March 1992 */

#include <stdio.h>
#include <string.h>
#include <alloc.h>
#include "rend386.h"

/* Copyright 1992 by Dave Stampe and Bernie Roehl.
   May be freely used to write software for release into the public domain;
   all commercial endeavours MUST contact Bernie Roehl and Dave Stampe
   for permission to incorporate any part of this software into their
   products!
 */

int load_err = 0;  /* set if an error was encountered during loading */

static long xshift = 0, yshift = 0, zshift = 0;
static float xrescale = 1, yrescale = 1, zrescale = 1;
static int depthsort = 0;

static unsigned *cmap;
static int mapsize = 0;

static unsigned mapcolor(unsigned orig)
	{
	if ((orig & 0x8000) == 0) return orig;  /* only map if top bit set */
	if (cmap == NULL) return orig;
	orig &= 0x7FFF;  /* turn the top bit off */
	if (orig > mapsize) return orig;
	return cmap[orig];
	}

void set_loadplg_colormap(unsigned *map, int msize)
	{
	cmap = map;
	mapsize = msize;
	}

void set_loadplg_offset(long x, long y, long z)
	{
	xshift = x;  yshift = y;  zshift = z;
	}
	
void set_loadplg_scale(float x, float y, float z)
	{
	xrescale = x;  yrescale = y;  zrescale = z;
	}
	
void set_loadplg_depthsort(int type)
	{
	depthsort = type;
	}

void strip_comment(char *buff)  /* also trim newline character(s) */
	{
	char *p;
	if ((p = strchr(buff, '\n')) != NULL) *p = '\0';  /* trim newline */
	if ((p = strchr(buff, '#')) != NULL) *p = '\0';   /* trim comment */
	if ((p = strchr(buff, '*')) != NULL) *p = '\0';   /* future expansion */
	}

OBJECT *load_plg(FILE *in)
	{
	OBJECT *obj;
	char tbuff[1000];
	char objname[100], buf1[100], buf2[100];
	int nv, np, i;
				 /* skip blank lines */
	do {
		if (fgets(tbuff, sizeof(tbuff), in) == NULL) return NULL;
		strip_comment(tbuff);
		}
	while (tbuff[0] == '\0');

	if (sscanf(tbuff, "%s %s %s", objname, buf1, buf2) != 3)
		{  load_err = -1; return NULL;  }
	if ((obj = new_obj(0, nv = atoi(buf1), np = atoi(buf2), objname)) == NULL)
		{  load_err = -2; return NULL;  }

	for (i = 0; i < nv; ++i) 	  /* load in vertices */
		{
		float x, y, z;
		/* skip blank lines */
		do  {
			if (fgets(tbuff, sizeof(tbuff), in) == NULL)
				{ load_err = -4; return NULL; }
			strip_comment(tbuff);
			}
		while (tbuff[0] == '\0');

		if (sscanf(tbuff, "%f %f %f", &x, &y, &z) != 3)
			{ load_err = -5;  return NULL;  }
		add_vertex(obj, ((long) (x*xrescale))+xshift, ((long) (y*yrescale))+yshift,
			((long) (z*zrescale))+zshift);
		}

	for (i = 0; i < np; ++i)   /* load polygons */
		{
		int j, npoints;
		unsigned color;
		POLY *poly;
		char *p;
			/* skip blank lines */
		do {
			if (fgets(tbuff, sizeof(tbuff), in) == NULL)
				{ load_err = -6; return NULL; }
			strip_comment(tbuff);
			} while (tbuff[0] == '\0');

		color = (unsigned) strtoul(tbuff,&p,0) ; /* req so hex colors usable */
		color = mapcolor(color);
		if ((p = strtok(p, " \t")) == NULL)
			{ load_err = -8; return NULL; }
		npoints = atoi(p);
		if ((poly = add_poly(obj, color, npoints)) == NULL)
			{ load_err = -9;  return NULL;  }
		for (j = 0; j < npoints; ++j)
			{
			if ((p = strtok(NULL, " \t")) == NULL)
				{ load_err = -9; return NULL; }
			add_point(obj, poly, atoi(p));
			}
		}
	compute_obj(obj);
	set_object_sorting(obj, depthsort);
	load_err = 0;
	return obj;
	}


save_plg(OBJECT *obj, FILE *out)
	{
	int nv, np, i;
	char buff[100];

	get_obj_info(obj, &nv, &np, buff, sizeof(buff)-1);
	fprintf(out, "%s %d %d\n", buff, nv, np);
	for (i = 0; i < nv; ++i)
		{
		long x, y, z;
		get_vertex_world_info(obj, i, &x, &y, &z);
		fprintf(out, "%ld %ld %ld\n", x, y, z);
		}
	for (i = 0; i < np; ++i)
		{
		int j, n, verts[1000];
		unsigned c;
		get_poly_info(obj, i, &c, &n, verts, sizeof(verts)/sizeof(int));
		fprintf(out, "0x04.4X %d", c & 0x7FFF, n);
		for (j = 0; j < n; ++j) fprintf(out, " %d", verts[j]);
		fprintf(out, "\n");
		}
	return 0;
	}
