/* Routines to initialize math tables for greater speed later on.
   Part of the REND386 package by Dave Stampe and Bernie Roehl.
 */

/* Copyright 1992 by Dave Stampe and Bernie Roehl.
   May be freely used to write software for release into the public domain;
   all commercial endeavours MUST contact Bernie Roehl and Dave Stampe
   for permission to incorporate any part of this software into their
   products!
 */

#include <stdlib.h>
#include <math.h>

/* this stuff moved out of integer core so that there are
   no uncompilable TC references in integer core library */

#define XFSC 536870912   /* 2**29 for shifting xform coeffs to long */
static float xfsc = XFSC;

long sintable[258];

fill_sine()
	{
	int i;

	for (i = 0; i < 256; i++)
		sintable[i] = (XFSC * sin(3.14159/2/256 * i));
	sintable[256] = XFSC;
	sintable[257] = XFSC;
	return 0;
	}

		/* tables for sphere object clipping:   */
long sclip_C[800];	/* 1/sqrt(zoom^2 + 1) table   		*/
long sclip_M[800];	/* zoom * C table  (table: i = 32*zoom) */
		/* range: FOV = 2*atan(1/zoom)          */
		/* or about 150 to 7 degrees 		*/
fill_sclip()
	{
	int i;
	float n;

	for (i = 0; i < 800; i++)
		{
		n = 1.0/sqrt((i/16.0)*(i/16.0) + 1);
		sclip_C[i] = XFSC * n;
		sclip_M[i] = XFSC * ((i/16.0) * n) ;
		}
		return 0;
	}

int sqrtable[1024];

fill_sqrt()
	{
	int i;

	for (i = 0; i < 1024; i++)
		sqrtable[i] = 1024*sqrt(i);
	return 0;
	}

