/* Routine to setup and compute colors */
/* for 256-color mode 		       */

/* Written by Dave Stampe Mar 21 1992 */

/* Modified by Bernie Roehl, April 2, 1992 */

/* Copyright 1992 by Dave Stampe and Bernie Roehl.
   May be freely used to write software for release into the public domain;
   all commercial endeavours MUST contact Bernie Roehl and Dave Stampe
   for permission to incorporate any part of this software into their
   products!
 */

#include <stdio.h>
#include <dos.h>
#include "rend386.h"

			/* 320x200x256 Y-mode screen definition */

struct Screeninfo screeninfo = { 0, 0, 319, 199, 160, 100, 256, 4};


			/* colors to use on screen */

int screen_clear_color = 3;
int wireframe_color    = 13;
int highlight_color    = 15;
int highest_color      = 255;

			/* use linear palette instaed of EGA palette map */

			/* illumination scale for colors (empirical fit ) */
static
float m[16] = { 0.08, 0.13, 0.16, 0.20, 0.24, 0.28, 0.33, 0.37,
		0.42, 0.48, 0.54, 0.61, 0.69, 0.79, 0.89, 1.00 };

			/* hue 0: map brite->color 	*/
			/* (abs. 0 = black)		*/
			/* DAC 0 to 15 are std colors   */

			/* poly color word:		  */
			/*       SoTTHHHHBBBBBBBB	  */
			/* S = 1 if poly "hilighted"      */
			/* H = hue (0=map, 1-15=hue)      */
			/* B = brite (DAC slot if mapped) */
			/* T = surface type (plain,cosine-lit,metal,glass) */
			/*     else B/255 is reflectance  */

static int basis[15][3] = {
	63, 0,  0,        /* sat. red 			*/
	63, 31,  0,       /* orange/brown 		*/
	63, 31, 31,       /* pale pink 			*/
	63, 47, 31,       /* tan 				*/
	63, 63, 31,       /* pale yellow 		*/
	63, 63,  0,       /* yellow 			*/
	0, 63, 31,        /* pale green 		*/
	0, 63,  0,        /* sat. green 		*/
	0, 63, 47,        /* blue-green 		*/
	0, 47, 63,        /* sky blue 			*/
	0,  0, 63,        /* sat. blue 			*/
	63,  0, 63,       /* purple-blue 		*/
	63,  0, 47,       /* pink/purple 		*/
	32, 32, 32,       /* grey 				*/
	63, 63, 63        /* black				*/
	};

int set_colors()   /* setup colors for 256 color mode */
{                  /* with basic colors, brightness   */
	int i,j;
	int r,g,b;
	union REGS reg;

	for (i = 0; i < 16; i++) m[i] = (m[i]+0.25)/1.27;  /* downgrade contrast a bit */

	for (i = 0; i < 15; i++)
		{
		r = basis[i][0];
		g = basis[i][1];
		b = basis[i][2];
		for (j = 0;j < 16; j++)
			{
			reg.x.ax = 0x1010;
			reg.x.bx = i*16+16+j;
			reg.h.dh = r*m[j];
			reg.h.ch = g*m[j];
			reg.h.cl = b*m[j];
			int86(0x10,&reg,&reg);
			}
		}
	return 0;
}


reset_colors()
{
	return 0;
}



extern int poly_cosine(void *p);  /* RETURNS 128*COS(LIGHT ANGLE) */

/* USER POLYGON LIGHTING ROUTINE: DETERMINES POLY COLOR # */

/* The 16-bit color the user specifies for a polygon is broken down as
   follows:
                 H R SS CCCC BBBBBBBB        
   
   H is the highlight flag (the polygon should be highlighted in
   some way, usually by outlining it in the highlight_color given above).

   R is a reserved bit, which should be set to zero

   SS is a two-bit field specifying one of four surface types:

      00 is a constant-color surface; the 4-bit field CCCC is ignored, and the
         8-bit field BBBBBBBB is used as an absolute color number

      01 is a cosine-lit surface; the 4-bit field CCCC specifies one of 16
         basic colors, and the 8-bit brightness field BBBBBBBB is multiplied
         by the cosine of the angle between the light source and the polygon's
         surface normal to provide a 4-bit shading value.

      10 is a pseudo-metallic surface; the CCCC field gives the starting hue,
         and the BBBBBBBB value is ignored.  The color will cycle through
         the different shades to give a 'metallic' effect.

      11 is a pseudo-transparent surface made up of alternating rows of
         spaced dots; other than that, it behaves like a pseudo-metallic
         surface.

   This routine maps the above into an 8-bit color number in the low byte
   of its return value, and passes through the top four bits.

 */

int user_poly_color(POLY *p, int pcolor)
{
	int hilite = pcolor & 0xF000;	   /* highlight flag  (MSB) */
	int bright = pcolor & 0xFF;        /* mask out albedo (7 bits) */
	int hue = (pcolor & 0x0F00) >> 4;  /* 16 * basis color */
	unsigned int color;

	if ((pcolor & 0x3000) == 0)  /* fixed (unlit) color */
		return hue ? (hilite | hue | ((bright >> 4) & 0x0F)) : (bright | hilite);

	color = poly_cosine(p);

	if (pcolor & 0x2000)    /* develop offset for metal/glass cycle */
	 {
		color = (-(color >> 1)) + bright >> 3;
		color = (color & 16) ? (color & 15) | 0x100 : color & 15;
		return (hilite|hue|color);
	 }                                   /* compute brightness index */

	color = ((color+200) * (bright>>1) ) / 0x0A20;

	if (color < 1)      			/* absolute zero: black */
		return (hilite & 0x2000) ? (hilite | hue) : hilite;
	if (color > 15)
		return (15 | hue | hilite);
	return (color | hue | hilite);
}



