/* Stereo viewing support */

/* Written by Dave Stampe; part of the REND386 package */

/* Copyright 1992 by Dave Stampe and Bernie Roehl.
   May be freely used to write software for release into the public domain;
   all commercial endeavours MUST contact Bernie Roehl and Dave Stampe
   for permission to incorporate any part of this software into their
   products!
 */

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>   /* toupper() */
#include <dos.h>

#include "rend386.h"
#include "userint.h"

/* default screen data setup: example only */

/* STEREO default_stereo = { 1000, 250, 320, 63, 1000, 10*65536L }; */

/* static VIEW default_view = {
/*			0,0,-1000,         /* ex,ey,ez */
/*			0,0,0,             /* pan,tilt,roll */
/*			9*65536L,          /* zoom */
/*			1000,15000,-5000,  /* lx,ly,lz */
/*			0,319,0,200,       /* left,right,top,bottom */
/*			1,100000,          /* hither, yon */
/*			1/1.25*65536L,     /* aspect ratio */
/*			0,                 /* flags */
/*			0,0		           /* no offset */
/*			};                 /* don't init. matrix */



void make_stereo_view(VIEW *root, VIEW *nview, STEREO *stereo, int eye)
	{
	long x_fixup;
	long world_iod;
	MATRIX icam;

	*nview = *root;  /* copy root view */
	nview->zoom = (65536L * 2L * stereo->phys_screen_dist) /
			stereo->phys_screen_width;

	/* screen offset */
	x_fixup = (stereo->phys_eye_spacing *
		stereo->phys_screen_dist * stereo->pixel_width )
		/ (stereo->phys_convergence * 2 * stereo->phys_screen_width);

	/* eye point */
	world_iod = (stereo->phys_eye_spacing * stereo->world_scaling) >> 17;

	/* make left/right */
	if (eye == LEFT_EYE)
		{
		nview->x_offset -= x_fixup ;
		nview->eye_xform[3][0] -= m_mult(world_iod,nview->eye_xform[0][0]);
		nview->eye_xform[3][1] -= m_mult(world_iod,nview->eye_xform[0][1]);
		nview->eye_xform[3][2] -= m_mult(world_iod,nview->eye_xform[0][2]);
		}
	else if (eye == RIGHT_EYE)
		{
		nview->x_offset += x_fixup ;
		nview->eye_xform[3][0] += m_mult(world_iod,nview->eye_xform[0][0]);
		nview->eye_xform[3][1] += m_mult(world_iod,nview->eye_xform[0][1]);
		nview->eye_xform[3][2] += m_mult(world_iod,nview->eye_xform[0][2]);
		}
	initialize_screen_factors(nview);
	}



		/* sufficient if only view point has changed */
void update_stereo_view(VIEW *v, STEREO *s, int eye)
	{
	long world_iod = (s->phys_eye_spacing * s->world_scaling)>>17;

	if (eye == LEFT_EYE)
		{
		v->eye_xform[3][0] -= m_mult(world_iod,v->eye_xform[0][0]);
		v->eye_xform[3][1] -= m_mult(world_iod,v->eye_xform[1][0]);
		v->eye_xform[3][2] -= m_mult(world_iod,v->eye_xform[2][0]);
		}
	else if (eye == RIGHT_EYE)
		{
		v->eye_xform[3][0] += m_mult(world_iod,v->eye_xform[0][0]);
		v->eye_xform[3][1] += m_mult(world_iod,v->eye_xform[1][0]);
		v->eye_xform[3][2] += m_mult(world_iod,v->eye_xform[2][0]);
		}
	}


void mirr_stereo_view(VIEW *root, VIEW *nview, STEREO *stereo, int eye)
	{
	long x_fixup;
	long world_iod;
	MATRIX icam;
	int i;

	*nview = *root;        				/* copy root view */
	nview->zoom = (65536L * 2L * stereo->phys_screen_dist) /
		stereo->phys_screen_width;

	/* screen offset */
	x_fixup = (stereo->phys_eye_spacing * stereo->phys_screen_dist
		* stereo->pixel_width ) /
	(stereo->phys_convergence * 2 *	stereo->phys_screen_width);

	/* eye point */
	world_iod = (stereo->phys_eye_spacing * stereo->world_scaling) >> 17;

	/* make left/right */
	if (eye == LEFT_EYE)
		{
		nview->x_offset -= x_fixup;
		nview->eye_xform[3][0] -= m_mult(world_iod,nview->eye_xform[0][0]);
		nview->eye_xform[3][1] -= m_mult(world_iod,nview->eye_xform[0][1]);
		nview->eye_xform[3][2] -= m_mult(world_iod,nview->eye_xform[0][2]);
		}
	 else if (eye == RIGHT_EYE)
		{
		nview->x_offset -= x_fixup ;
		nview->eye_xform[3][0] += m_mult(world_iod,nview->eye_xform[0][0]);
		nview->eye_xform[3][1] += m_mult(world_iod,nview->eye_xform[0][1]);
		nview->eye_xform[3][2] += m_mult(world_iod,nview->eye_xform[0][2]);
		nview->orientation = XFLIP;
		nview->left = nview->right;
		nview->right += nview->right;
		}
	initialize_screen_factors(nview);
	}

