#include <ctype.h>
#include "window.h"
#include "symbol.h"
#include "de.h"

typedef struct tagCheckboxToStyle
{
  int   idCheckbox;
  DWORD dwStyle;
} CHECKBOX_TO_STYLE;


CHECKBOX_TO_STYLE GENERICCheckboxToStyleMap[] =
{
  ID_WSBORDER,     WS_BORDER,
  ID_WSTABSTOP,    WS_TABSTOP,
  ID_WSGROUP,      WS_GROUP,
  -1,              0L
};


CHECKBOX_TO_STYLE EDITCheckboxToStyleMap[] =
{
  ID_ESMULTILINE,  ES_MULTILINE,
  ID_ESAUTOVSCROLL,ES_AUTOVSCROLL,
  ID_ESAUTOHSCROLL,ES_AUTOHSCROLL,
  ID_ESPASSWORD,   ES_PASSWORD,
  ID_ESMARGIN,     ES_MARGIN,
  -1,              0L
};

CHECKBOX_TO_STYLE PBCheckboxToStyleMap[] =
{
  ID_BSDEFAULT,    BS_DEFAULT,
  ID_BSHELP,       BS_HELP,
  -1,              0L
};

CHECKBOX_TO_STYLE LBCheckboxToStyleMap[] =
{
  ID_LBSMULTISEL,  LBS_MULTIPLESEL,
  ID_LBSNOREDRAW,  LBS_NOREDRAW,
  ID_LBSNOTIFY,    LBS_NOTIFY,
  ID_LBSSORT,      LBS_SORT,
  ID_LBSSTANDARD,  LBS_STANDARD,
  ID_LBSMULTICOL,  LBS_MULTICOLUMN,
  -1,              0L
};

CHECKBOX_TO_STYLE COMBOCheckboxToStyleMap[] =
{
  ID_LBSMULTISEL,  LBS_MULTIPLESEL,
  ID_LBSNOREDRAW,  LBS_NOREDRAW,
  ID_LBSNOTIFY,    LBS_NOTIFY,
  ID_LBSSORT,      LBS_SORT,
  ID_LBSSTANDARD,  LBS_STANDARD,
  ID_LBSMULTICOL,  LBS_MULTICOLUMN,
  ID_CBSSIMPLE,    CBS_SIMPLE,
  ID_CBSDROPDOWN,  CBS_DROPDOWN,
  ID_CBSDROPLIST,  CBS_DROPDOWNLIST,
  -1,              0L
};

extern int pascal StyleDialogProc(HDLG hDlg, WORD msg, WORD wParam, DWORD lParam);


CtrlEditStyle()
{
  WORD hModule;
  HDLG hDlg;
  WORD idDlg;

  if (!hCurrCtrl)
  {
    MessageBox(NULLHWND, "No control selected", "Error", MB_OK);
    return FALSE;
  }

  if ((hModule = OpenResourceFile("DE")) == FALSE)
  {
    MessageBox(NULLHWND, "Can't open DE.RES", "Error", MB_OK);
    return FALSE;
  }

  switch (WinGetClass(hCurrCtrl))
  {
    case EDIT_CLASS :
      idDlg = ID_EDITSTYLE;
      break;
    case PUSHBUTTON_CLASS :
      idDlg = ID_PBSTYLE;
      break;
    case LISTBOX_CLASS :
      idDlg = ID_LBOXSTYLE;
      break;
    case COMBO_CLASS :
      idDlg = ID_COMBOSTYLE;
      break;
    default :
      idDlg = ID_CBOXSTYLE;
      break;
  }


  if ((hDlg = LoadDialog(hModule, MAKEINTRESOURCE(idDlg), hMain, StyleDialogProc)) == NULLHWND)
  {
    MessageBox(NULLHWND, "Can't load the dialog box", "Error", MB_OK);
    return FALSE;
  }
  CloseResourceFile(hModule);

  return DialogBox(hDlg);
}


int pascal StyleDialogProc(hDlg, msg, wParam, lParam)
  HWND hDlg;
  WORD msg;
  WORD wParam;
  DWORD lParam;
{
  HWND   hCtrl = hCurrCtrl;
  char   szBuf[80];
  INT    id;
  SYMBOL *pSym;
  DWORD  dwStyle;
  CHECKBOX_TO_STYLE *pCB2Style;

  switch (msg)
  {
    case WM_INITDIALOG :
      /*
        Set the control's title and ID fields
      */
      SendMessage(hCtrl, WM_GETTEXT, 60, (DWORD) (LPSTR) szBuf);
      SetDlgItemText(hDlg, ID_CTRL_TITLE, szBuf);
      id = SendMessage(hDEDlg, WM_GETID, 0, 0L);
      if ((pSym = SymbolFind(NULL, id)) != NULL)
        SetDlgItemText(hDlg, ID_CTRL_ID, pSym->szSymbol);
      else
        SetDlgItemInt(hDlg, ID_CTRL_ID, id);


      pCB2Style = GENERICCheckboxToStyleMap;
      for (  ;  (id = pCB2Style->idCheckbox) >= 0;  pCB2Style++)
      {
        CheckDialogItem(hDlg, id, 
                   (WinGetFlags(hCtrl) & pCB2Style->dwStyle) ? TRUE : FALSE);
      }

      switch (WinGetClass(hCtrl))
      {
        case EDIT_CLASS :
          pCB2Style = EDITCheckboxToStyleMap;
          break;
        case PUSHBUTTON_CLASS :
          pCB2Style = PBCheckboxToStyleMap;
          break;
        case LISTBOX_CLASS :
          pCB2Style = LBCheckboxToStyleMap;
          break;
        case COMBO_CLASS :
          pCB2Style = COMBOCheckboxToStyleMap;
          break;
        default :
          pCB2Style = NULL;
          break;
      }

      if (pCB2Style)
      {
        for (  ;  (id = pCB2Style->idCheckbox) >= 0;  pCB2Style++)
        {
          CheckDialogItem(hDlg, id, 
                    (WinGetFlags(hCtrl) & pCB2Style->dwStyle) ? TRUE : FALSE);
        }
      }

      return TRUE;

    case WM_COMMAND :
      /* The user pressed the <CANCEL> button */
      if (wParam == IDCANCEL)
        EndDialog(hDlg, IDCANCEL);
      /* The user pressed the <OK> button */
      else if (wParam == IDOK)
      {

        GetDialogText(hDlg, ID_CTRLID, (char far *) szBuf, sizeof(szBuf));
        if (isdigit(szBuf[0]))
          id = atoi(szBuf);
        else if ((pSym = SymbolFind(szBuf, 0)) != NULL)
          id = pSym->idSymbol;
        else
          id = 0;
        GetDialogText(hDlg, ID_TITLE, (char far *) szBuf, sizeof(szBuf));
        SetWindowText(hCtrl, szBuf);

        dwStyle = WS_CLIP | WS_MOVEBOX | WS_SIZEBOX;

        pCB2Style = GENERICCheckboxToStyleMap;
        for (  ;  (id = pCB2Style->idCheckbox) >= 0;  pCB2Style++)
        {
          if (IsDlgButtonChecked(hDlg, id))
            dwStyle |= pCB2Style->dwStyle;
        }

        switch (WinGetClass(hCtrl))
        {
          case EDIT_CLASS :
            pCB2Style = EDITCheckboxToStyleMap;
            break;
          case PUSHBUTTON_CLASS :
            pCB2Style = PBCheckboxToStyleMap;
            break;
          case LISTBOX_CLASS :
            pCB2Style = LBCheckboxToStyleMap;
            break;
          case COMBO_CLASS :
            pCB2Style = COMBOCheckboxToStyleMap;
            break;
          default :
            pCB2Style = NULL;
            break;
        }

        if (pCB2Style)
        {
          for (  ;  (id = pCB2Style->idCheckbox) >= 0;  pCB2Style++)
          {
            if (IsDlgButtonChecked(hDlg, id))
              dwStyle |= pCB2Style->dwStyle;
          }
        }

        bDlgIsDirty++;
        EndDialog(hDlg, IDOK);
      }
      return TRUE;

    default :
      return FALSE;
  }
}



