/*===========================================================================*/
/*                                                                           */
/* File    : DEGEN.C                                                         */
/*                                                                           */
/* Purpose : Simple dialog editor for the Magma Window System                */
/*                                                                           */
/* History :                                                                 */
/*                                                                           */
/* (C) Copyright 1989 Marc Adler/Magma Systems     All Rights Reserved       */
/*===========================================================================*/

#include <stdio.h>
#include "window.h"
#include "de.h"
#include "symbol.h"

/***************************************************************************/
/*                                                                         */
/*                       CODE GENERATION ROUTINES                          */
/*                                                                         */
/***************************************************************************/

extern BOOL pascal _DlgGenChildCode(HWND hCtrl, DWORD lParam);
static FILE *DlgFp;

int pascal DlgGenCode(hDlg, fname)
  HDLG hDlg;
  char *fname;
{
  RECT r;
  char szDlgName[80];
  int  id;
  SYMBOL *sym;

  if ((DlgFp = fopen(fname, "w")) == NULL)
  {
    MessageBox(NULLHWND, "Cannot open the file for writing.", "Error!", MB_OK);
    return FALSE;
  }

  SymbolWrite(DlgFp);
  fprintf(DlgFp, "\n\n");

  r = WinGetRect(hDlg);
  SendMessage(hDlg, WM_GETTEXT, sizeof(szDlgName),
                                             (DWORD) (char far *) szDlgName);
  id = SendMessage(hDlg, WM_GETID, 0, 0L);
  sym = SymbolFind(NULL, id);

  fprintf(DlgFp, "HWND Create%s()\n{\n", szDlgName);
  fprintf(DlgFp, "  HDLG hDlg;\n\n");
  fprintf(DlgFp, "  hDlg = DialogCreate(NULLWND,%d,%d,%d,%d,\"%s\",%d,0x0000,dlgfunc,",
            r.top, r.left, r.bottom, r.right, szDlgName, WinGetAttr(hDlg));
  if (sym)
    fprintf(DlgFp, "%s);\n", sym->szSymbol);
  else
    fprintf(DlgFp, "%d);\n", id);

  EnumChildWindows(hDlg, _DlgGenChildCode, 0L);

  fprintf(DlgFp, "}\n");

  fclose(DlgFp);
  return TRUE;
}


BOOL pascal _DlgGenChildCode(hCtrl, lParam)
  HWND  hCtrl;
  DWORD lParam;
{
  RECT  r;
  char  szCtrlName[133], *s;
  WORD  id;
  DWORD flags;
  int   iWidth;
  int   class;
  SYMBOL *sym;
  WINDOW *w;

  if ((w = WID_TO_WIN(hCtrl)) == NULL)
    return FALSE;

  r = WinGetRect(hCtrl);
  SendMessage(hCtrl,WM_GETTEXT,sizeof(szCtrlName),(DWORD)(char far *)szCtrlName);
  id = SendMessage(hCtrl, WM_GETID, 0, 0L);
  class = WinGetClass(hCtrl);
  flags = WinGetFlags(hCtrl);

  /*
    Don't output the scrollbar which belongs to a listbox.
  */
  if (w->class == SCROLLBAR_CLASS && w->parent->class == LISTBOX_CLASS)
    return TRUE;

  /*
    Don't output the child controls of a combo box
  */
  if (w->parent && w->parent->class == COMBO_CLASS)
    return TRUE;

  /*
    Adjust the width to the length of the text of a text class control,
    or in the case of a checkbox or radiobutton, the length of the
    text plus 4 for the left char, space, right char, and space.
  */
  if (w->class == TEXT_CLASS)
    iWidth = strlen(w->title);
  else if (w->class == CHECKBOX_CLASS || w->class == RADIOBUTTON_CLASS)
    iWidth = strlen(w->title) + 4;
  else
    iWidth = RECT_WIDTH(r);

  sym = SymbolFind(NULL, id);

  fprintf(DlgFp, "\tCreateWindow(\"%s\",\n", WinGetClassName(hCtrl));
  fprintf(DlgFp, "\t\t\"%s\",\n", szCtrlName);
  fprintf(DlgFp, "\t\t0x%x,\n", WinGetFlags(hCtrl));
  fprintf(DlgFp, "\t\t%d,%d,%d,%d,\n", r.left, r.top, iWidth, RECT_HEIGHT(r));
  fprintf(DlgFp, "\t\t0x%x, \n", WinGetAttr(hCtrl));
  if (sym)
    fprintf(DlgFp, "\t\t%s,\n", sym->szSymbol);
  else
    fprintf(DlgFp, "\t\t%d,\n", id);
  fprintf(DlgFp, "\t\tNULLHWND, (HMENU) NULLHWND, 0, (DWORD) NULL);\n");

  return TRUE;
}

