#define STRING_ID

#include "window.h"
#include "de.h"
#include "winrc.h"

extern BOOL pascal _DlgAddStyleToChild(HWND hCtrl, DWORD lParam);

#ifdef STRING_ID
extern STRINGTBLHEADER _StringTblHeader;
extern BYTE *pszIDStrings;
extern INT PASCAL _MapStringIDToNumber(LPSTR);
#endif


DTEMPLATE DialogListTemplate[] =
{
  { "Listbox",     "",       LBS_NOTIFY,  32, 7,14,  8,  ID_DLGLIST_LISTBOX },
  { "PushButton",  "OK",     0x0000,      31,16, 4,  1,  IDOK          },
  { "PushButton",  "CANCEL", 0x0000,      39,16, 8,  1,  IDCANCEL      },
};


HWND DlgList(char *szFileName)
{
  HDLG hDlg;
  extern int pascal DlgListDialogProc();

  hDlg = DialogCreateIndirect(hMain,
                            6,30,17,47,
                            "Dialog Boxes",
                            0x31, 0x0000L,
                            DlgListDialogProc,
                            DialogListTemplate,
                            sizeof(DialogListTemplate) / sizeof(DTEMPLATE));


  if ((hModule = OpenResourceFile(szFileName)) == FALSE)
    return NULLHWND;
  ReadIDStrings(hModule);
  hDlg = (HWND) DialogBox(hDlg);
  CloseResourceFile(hModule);
  if (MessageBox(NULLHWND,"Read the #include file?","DE",MB_YESNO) == IDYES)
    SymbolRead(szFileName);
  return hDlg;
}

int pascal DlgListDialogProc(hDlg, msg, wParam, lParam)
  HWND hDlg;
  WORD msg;
  WORD wParam;
  DWORD lParam;
{
  RESOURCE res;
  HDLG     hNewDlg;
  int      iSel;
  char     buf[33];

  switch (msg)
  {
    case WM_INITDIALOG :
      lseek(hModule, 0L, 0);
#ifdef STRING_ID
      read(hModule, (char *) &_StringTblHeader, sizeof(_StringTblHeader));
#endif

      for (;;)
      {
#ifdef STRING_ID
        if (_StringTblHeader.ulSeekPos > 0 &&
            tell(hModule) >= _StringTblHeader.ulSeekPos)
          break;
#endif
        if (read(hModule, &res, sizeof(res)) <= 0)
          break;

        if (res.iResType == RT_DIALOG)
        {
          sprintf(buf, "%u", res.iResID);
          SendDlgItemMessage(hDlg, ID_DLGLIST_LISTBOX, LB_ADDSTRING, 0, 
                                                       (DWORD) (char far *) buf);
        }

        if (lseek(hModule, (long) res.nResBytes, 1) == -1)
          break;
      }
      return TRUE;

    case WM_COMMAND :
      switch (wParam)
      {
        case ID_DLGLIST_LISTBOX :
          if (HIWORD(lParam) != LBN_DBLCLK)
            break;
          /* fall through if double clicked ... */

        case IDOK     :
          iSel = SendDlgItemMessage(hDlg, ID_DLGLIST_LISTBOX, LB_GETCURSEL, 0, 0L);
          if (iSel == LB_ERR)
            return TRUE;

          SendDlgItemMessage(hDlg, ID_DLGLIST_LISTBOX, LB_GETTEXT, iSel,
                             (DWORD) (char far *) buf);
          iSel = atoi(buf);

          if ((hNewDlg = LoadDialog(hModule, MAKEINTRESOURCE(iSel), hMain, (PFI) DE_DialogProc)))
          {
            WinSetFlags(hNewDlg, WS_SYSMENU | WS_CAPTION | WS_MOVEBOX | WS_SIZEBOX);
            EnumChildWindows(hNewDlg, _DlgAddStyleToChild, 
                                      WS_CLIP | WS_MOVEBOX | WS_SIZEBOX);
            WinCreateSysMenu(hNewDlg);
            EndDialog(hDlg, hNewDlg);
          }
          else
            MessageBox(NULLHWND, "This dialog could not be loaded", "ERROR", MB_OK);
          return TRUE;
        case IDCANCEL :
          EndDialog(hDlg, FALSE);
          return TRUE;
      }

  } /* switch */

  return FALSE;
}


BOOL pascal _DlgAddStyleToChild(hCtrl, lParam)
  HWND  hCtrl;
  DWORD lParam;
{
  WinSetFlags(hCtrl, lParam);
  return TRUE;
}


#ifdef STRING_ID

ReadIDStrings(fd)
  int fd;
{
  if (pszIDStrings)
  {
    MyFree(pszIDStrings);
    pszIDStrings = NULL;
  }

  /*
    Read the ID string-table header.
  */
  lseek(fd, 0L, 0);
  read(fd, (char *) &_StringTblHeader, sizeof(_StringTblHeader));

  /*
    If we have string-id's defined in this resource file, allocate
    memory for the strings and read the ID table into memory.
  */
  if (_StringTblHeader.ulBytes > 0)
  {
    if ((pszIDStrings = emalloc((WORD) _StringTblHeader.ulBytes)) == NULL)
    {
      close(fd);
      return FALSE;
    }
    lseek(fd, _StringTblHeader.ulSeekPos, 0);
    read(fd, pszIDStrings, (WORD) _StringTblHeader.ulBytes);
  }
  return TRUE;
}

#endif

