/*===========================================================================*/
/*                                                                           */
/* File    : DEPROMPT.C                                                      */
/*                                                                           */
/* Purpose : Simple dialog editor for the Magma Window System                */
/*                                                                           */
/* History : Separated out of the main DE.C file. This module provides       */
/*           the support for the various modal dialog boxes which are        */
/*           used by DE.                                                     */
/*                                                                           */
/* (C) Copyright 1989 Marc Adler/Magma Systems     All Rights Reserved       */
/*===========================================================================*/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#ifdef TC
#include <alloc.h>
#include <mem.h>
#else
#include <malloc.h>
#include <memory.h>
#endif
#include "window.h"
#include "de.h"
#include "symbol.h"
#include "winrc.h"


DTEMPLATE CtrlDialogTemplate[] =
{
  { "Frame",       "Class", SS_FRAME | WS_GROUP,     23, 7, 20, 12, 100 },
  { "RadioButton", "Text",  WS_TABSTOP | WS_GROUP,   24, 8, 0,  0,  ID_CTRL_TEXT },
  { "RadioButton", "Edit",  0x0000,       24, 9, 0,  0,  ID_CTRL_EDIT },
  { "RadioButton", "Listbox",0x0000,      24,10, 0,  0,  ID_CTRL_LISTBOX },
  { "RadioButton", "Push Button",0x0000,  24,11, 0,  0,  ID_CTRL_PUSHBUTTON },
  { "RadioButton", "Checkbox",0x0000,     24,12, 0,  0,  ID_CTRL_CHECKBOX },
  { "RadioButton", "Radio Button",0x0000, 24,13, 0,  0,  ID_CTRL_RADIOBUTTON },
  { "RadioButton", "Frame",  0x0000,      24,14, 0,  0,  ID_CTRL_FRAME },
  { "RadioButton", "Box",    0x0000,      24,15, 0,  0,  ID_CTRL_BOX   },
  { "RadioButton", "Combo",  0x0000,      24,16, 0,  0,  ID_CTRL_COMBO },
  { "PushButton",  "OK",     WS_TABSTOP | WS_GROUP,   30,19, 4,  1,  IDOK          },
  { "PushButton",  "CANCEL", WS_TABSTOP,  45,19, 8,  1,  IDCANCEL      },
  { "Edit",        "Control ID",WS_TABSTOP | WS_GROUP | ES_MARGIN | ES_AUTOHSCROLL, 45,7,15,3,ID_CTRL_ID    },
  { "Edit",        "Text",   WS_TABSTOP | WS_GROUP | ES_MARGIN | ES_AUTOHSCROLL,    45,11,15,3,  ID_CTRL_TITLE },
};

DTEMPLATE DialogRenameTemplate[] =
{
  { "Edit",        "Name",   WIN_HAS_BORDER,22,11,37,3,  ID_CTRL_TITLE },
  { "Edit",        "ID",     WIN_HAS_BORDER,22,13,30,3,  ID_CTRL_ID    },
  { "PushButton",  "OK",     0x0000,      30,17, 4,  1,  IDOK          },
  { "PushButton",  "CANCEL", 0x0000,      50,17, 8,  1,  IDCANCEL      },
};

DTEMPLATE DialogSaveTemplate[] =
{
  { "Edit",        "File name:",WIN_HAS_BORDER,22,11,37,3,ID_CTRL_TITLE},
  { "PushButton",  "OK",     0x0000,      30,15, 4,  1,  IDOK          },
  { "PushButton",  "CANCEL", 0x0000,      50,15, 8,  1,  IDCANCEL      },
};

DTEMPLATE DialogReorderTemplate[] =
{
  { "Listbox",     "Controls",LBS_NOTIFY, 21, 7,39, 10,  ID_ORDERLB    },
  { "PushButton",  "MOVE",   0x0000,      30,18, 6,  1,  ID_MOVE       },
  { "PushButton",  "DONE",   0x0000,      45,18, 6,  1,  ID_DONE       },
  { "Static",      "",       SS_TEXT,     15,20,55,  1,  IDHELP        },
};


HWND pascal DialogCreateIndirect(hParent, row1,col1,row2,col2, szTitle,
                                 attr, fFlags, pfnDlgProc, pTemplate, nTemplate)
  HWND hParent;
  int  row1, col1, row2, col2;
  char *szTitle;
  WORD attr;
  DWORD fFlags;
  int  (pascal *pfnDlgProc)();
  DTEMPLATE *pTemplate;
  int  nTemplate;
{
  HDLG hDlg;
  HWND hCtrl;

  hDlg = DialogCreate(hParent,row1,col1,row2,col2,szTitle,attr,fFlags,pfnDlgProc,0);
  if (hDlg == NULLHWND)
    return NULLHWND;

  while (nTemplate-- > 0)
  {
    hCtrl = CreateWindow(pTemplate->szClass, pTemplate->szTitle,
                         pTemplate->dwStyle,
                         pTemplate->x,     pTemplate->y,
                         pTemplate->width, pTemplate->height,
                         0x31, pTemplate->idCtrl,
                         hDlg,              /* hParent */
                         (HMENU) NULLHWND,  /* hMenu   */
                         0,                 /* hInst   */
                         (DWORD) NULL);     /* lpCreateParams */
    if (hCtrl == NULLHWND)
      return NULLHWND;
    pTemplate++;
  }

  return (HWND) hDlg;
}



/*****************************************************************************/
/*                                                                           */
/*  BuildCtrlDialog - create the "Control Info" dialog box                   */
/*                                                                           */
/*****************************************************************************/
BuildCtrlDialog()
{
  hCtrlDlg = DialogCreateIndirect(hDEDlg,
                            5,20,20,60,
                            "Control Info",
                            0x31, 0x0000L,
                            CtrlDialogProc,
                            CtrlDialogTemplate,
                            sizeof(CtrlDialogTemplate) / sizeof(DTEMPLATE));
}

/*****************************************************************************/
/*                                                                           */
/*    THESE ARE THE ROUTINES WHICH CONTROL THE "CONTROL INFO" DLG BOX        */
/*                                                                           */
/*****************************************************************************/

int pascal CtrlDialogProc(hDlg, msg, wParam, lParam)
  HWND hDlg;
  WORD msg;
  WORD wParam;
  DWORD lParam;
{
  switch (msg)
  {
    case WM_INITDIALOG :
      /* This is sent when the dialog box proc starts */
      return TRUE;

    case WM_COMMAND :
      /* The user pressed the <CANCEL> button */
      if (wParam == IDCANCEL)
        EndDialog(hDlg, IDCANCEL);
      /* The user pressed the <OK> button */
      else if (wParam == IDOK)
      {
        AddCtrl(hDlg);          /* Add the current ctrl to the dialog box */
        EndDialog(hDlg, IDOK);
      }
      else if (wParam >= ID_CTRL_BASE && wParam <= ID_CTRL_END)
        CheckRadioButton(hDlg, ID_CTRL_BASE, ID_CTRL_END, wParam);
      return TRUE;

    default :
      return FALSE;
  }
}


/*===========================================================================*/
/*                                                                           */
/*    DE_DialogRename() - procedure for giving a dialog box a new name       */
/*                                                                           */
/*===========================================================================*/
DE_DialogRename()
{
  HWND hDlg;
  extern int  pascal DlgFnRename();

  hDlg = DialogCreateIndirect(hDEDlg,
                      10,20,18,60,
                      "Dialog Name",0x1F,0x0000L,DlgFnRename,
                      DialogRenameTemplate,
                      sizeof(DialogRenameTemplate) / sizeof(DTEMPLATE));
  return (hDlg) ? DialogBox(hDlg) : FALSE;
}

int pascal DlgFnRename(hDlg, msg, wParam, lParam)
  HWND hDlg;
  WORD msg;
  WORD wParam;
  DWORD lParam;
{
  char szFileName[80];
  int  id;
  SYMBOL *sym;

  switch (msg)
  {
    case WM_INITDIALOG :
      /*
        Set the dialog's title and ID fields
      */
      SendMessage(hDEDlg, WM_GETTEXT, 60, (DWORD) (char far *) szFileName);
      SetDialogText(hDlg, ID_CTRL_TITLE, szFileName);
      id = SendMessage(hDEDlg, WM_GETID, 0, 0L);
      if ((sym = SymbolFind(NULL, id)) != NULL)
        SetDialogText(hDlg, ID_CTRL_ID, sym->szSymbol);
      else
        SetDialogInt(hDlg, ID_CTRL_ID, id);
      return TRUE;

    case WM_QUIT :
      EndDialog(hDlg, IDCANCEL);
      break;

    case WM_COMMAND :
      if (wParam == IDCANCEL)
        EndDialog(hDlg, IDCANCEL);
      else if (wParam == IDOK)
      {
        /*
          Set the dialog box's title and ID
        */
        GetDialogText(hDlg, ID_CTRL_TITLE, (char far *) szFileName, 65);
        SendMessage(hDEDlg, WM_SETTEXT, 0, (DWORD) (char far *) szFileName);
        GetDialogText(hDlg, ID_CTRL_ID,    (char far *) szFileName, 65);
        if (isdigit(szFileName[0]))
          id = atoi(szFileName);
        else if ((sym = SymbolFind(szFileName, 0)) != NULL)
          id = sym->idSymbol;
        else
          id = 0;
        SendMessage(hDEDlg, WM_SETID, id, 0L);
        EndDialog(hDlg, IDOK);
      }
      return TRUE;

    default :
      return FALSE;
  }
}


/*===========================================================================*/
/*                                                                           */
/*  Routine to Save a dialog box                                             */
/*                                                                           */
/*===========================================================================*/

SaveFileDlg()
{
  HWND hDlg;
  extern int pascal DlgFnSave();

  hDlg = DialogCreateIndirect(hDEDlg, 10,20,16,60, "Save File",0x1F,
                              0x0000L,DlgFnSave,
                              DialogSaveTemplate,
                              sizeof(DialogSaveTemplate) / sizeof(DTEMPLATE));
  return (hDlg) ? DialogBox(hDlg) : FALSE;
}


int pascal DlgFnSave(hDlg, msg, wParam, lParam)
  HWND hDlg;
  WORD msg;
  WORD wParam;
  DWORD lParam;
{
  char szFileName[80];
  int   (pascal *pfSave)();

  switch (msg)
  {
    case WM_INITDIALOG :
      return TRUE;

    case WM_COMMAND :
      if (wParam == IDCANCEL)
        EndDialog(hDlg, IDCANCEL);
      else if (wParam == IDOK)
      {
        GetDialogText(hDlg, ID_CTRL_TITLE, (char far *) szFileName, 65);
        pfSave = (bGenerating) ? DlgGenCode : DialogSave;
        if ((*pfSave)(hDEDlg, szFileName))
        {
          strcpy(CurrFileName, szFileName);
          EndDialog(hDlg, IDOK);
        }
      }
      return TRUE;

    default :
      return FALSE;
  }
}


/*===========================================================================*/
/*                                                                           */
/*  Routine to re-order the controls in a dialog box                         */
/*                                                                           */
/*===========================================================================*/

HWND hReorderLB;
HDLG hDlgReorder;
char *szReorderHelp[2] =
{
  "Highlight the item to move and press the MOVE button",
  "Move the item to the new location and press MOVE again"
};


CtrlReorder()
{
  extern int pascal ReorderDlgProc();
  HWND hCtrl;
  int  rc;

  hDlgReorder = DialogCreateIndirect(NULLHWND, 5,10,21,70, "Control Order",
                             0x31, 0x0000L,
                             ReorderDlgProc,
                             DialogReorderTemplate,
                             sizeof(DialogReorderTemplate) / sizeof(DTEMPLATE));
  if (!hDlgReorder)
    return FALSE;

  hReorderLB = GetDlgItem(hDlgReorder, ID_ORDERLB);
  SendDlgItemMessage(hDlgReorder, IDHELP, WM_SETTEXT, 0, 
                       (DWORD) (char far *) szReorderHelp[0]);
  if ((rc = DialogBox(hDlgReorder)))
    bDlgIsDirty++;
  return rc;
}


int pascal ReorderDlgProc(hDlg, msg, wParam, lParam)
  HDLG hDlg;
  WORD msg;
  WORD wParam;
  DWORD lParam;
{
  int iPos, iSel;
  char buf[80];
  static CONTROL *ctrlMoved;
  static char szItemText[80];
  static int  nMovedItem;
  static BOOL bSomethingMoved;

  switch (msg)
  {
    case WM_INITDIALOG :
      CtrlListToListbox(hReorderLB);
      nMovedItem = - 1;
      bSomethingMoved = FALSE;
      return TRUE;

    case WM_COMMAND    :
      switch (wParam)
      {
      	case ID_MOVE :
          if (nMovedItem < 0)
          {
            nMovedItem = SendDlgItemMessage(hDlg,ID_ORDERLB,LB_GETCURSEL,0,0L);
            SendDlgItemMessage(hDlg, ID_ORDERLB, LB_GETTEXT,
                               nMovedItem, (DWORD) (char far *) szItemText);
            memcpy(ctrlMoved = (CONTROL *) emalloc(sizeof(CONTROL)),
                   ListGetNth(CtrlList, nMovedItem)->data, sizeof(CONTROL));
            SendDlgItemMessage(hDlg, IDHELP, WM_SETTEXT, 0,
                                       (DWORD) (char far *) szReorderHelp[1]);
            SetFocus(hReorderLB);
          }
          else
          {
            nMovedItem = -1;
            SendDlgItemMessage(hDlg, IDHELP, WM_SETTEXT, 0,
                                       (DWORD) (char far *) szReorderHelp[0]);
            SetFocus(hReorderLB);
          }
          return TRUE;

        case ID_DONE  :
          EndDialog(hDlg, 0);
          return TRUE;

        case ID_ORDERLB :
          switch (HIWORD(lParam))
          {
            case LBN_SELCHANGE :
              if (nMovedItem < 0)
                return FALSE;
              iSel = SendDlgItemMessage(hDlg,ID_ORDERLB,LB_GETCURSEL,0,0L);
              SendDlgItemMessage(hDlg,ID_ORDERLB,LB_DELETESTRING,nMovedItem,0L);
              SendDlgItemMessage(hDlg,ID_ORDERLB,LB_INSERTSTRING,iSel,
                                              (DWORD) (char far *) szItemText);

              ListDelete(&CtrlList, ListGetNth(CtrlList, nMovedItem));
              ListInsert(&CtrlList, ListCreate((char *) ctrlMoved), 
                                                ListGetNth(CtrlList,iSel));

              nMovedItem = iSel;
              bSomethingMoved = TRUE;
              break;
          }
          return FALSE;
      }
      break;
  }
  return FALSE;
}
