#include <stdio.h>
#include "window.h"
#include "de.h"

/***************************************************************************/
/*                                                                         */
/*                       HELP ROUTINES                                     */
/*                                                                         */
/***************************************************************************/

DTEMPLATE DialogHelpTemplate[] =
{
  { "Listbox",     "",       0x0000,      12, 6,57, 13,  ID_HELP_LB    },
  { "PushButton",  "HELP",   0x0000,      20,19, 6,  1,  IDOK          },
  { "PushButton",  "CANCEL", 0x0000,      35,19, 8,  1,  IDCANCEL      },
  { "PushButton",  "TOPICS", 0x0000,      55,19, 8,  1,  ID_TOPICS     },
};



HelpDialog()
{
  HDLG hDlg;
  extern int pascal HelpDialogProc();

  /*
    Create the dialog box and add all of the controls to it
  */
  hDlg = DialogCreateIndirect(NULLHWND, 5,10,20,70, "Help", 0x31, 0x0000L,
                      HelpDialogProc,
                      DialogHelpTemplate,
                      sizeof(DialogHelpTemplate) / sizeof(DTEMPLATE));
  return (hDlg) ? DialogBox(hDlg) : FALSE;
}


int pascal HelpDialogProc(hDlg, msg, wParam, lParam)
  HWND hDlg;
  WORD msg;
  WORD wParam;
  DWORD lParam;
{
  char szBuf[80];
  static FILE *fHelp;
  HWND   hLB;
  HWND   hTopics;
  int    iTopic;
  static int bShowingTopics;

  switch (msg)
  {
    case WM_INITDIALOG :
      if ((fHelp = fopen("de.hlp", "r")) == NULL)
      {
        MessageBox(NULLHWND, "Can't open DE.HLP", "Error", MB_OK);
        EndDialog(hDlg, IDCANCEL);
        return TRUE;
      }
get_topics:
      hLB = GetDlgItem(hDlg, ID_HELP_LB);
      SendMessage(hLB, LB_RESETCONTENT, 0, 0L);
      ListBoxSetRedraw(hLB, FALSE);

      while (fgets(szBuf, sizeof(szBuf), fHelp) != NULL && *szBuf != '\f')
      {
        char *szEnd = szBuf + strlen(szBuf) - 1;
        if (*szEnd == '\n')
          *szEnd = '\0';
        SendMessage(hLB, LB_ADDSTRING, 0, (DWORD) (char far *) szBuf);
      }

      ListBoxSetRedraw(hLB, TRUE);
      SetFocus(hLB);

      hTopics = GetDlgItem(hDlg, ID_TOPICS);
      EnableWindow(hTopics, FALSE);
      WinSetAttr(hTopics, 0x37, TRUE);

      bShowingTopics = TRUE;
      return TRUE;


    case WM_QUIT :
      EndDialog(hDlg, IDCANCEL);
      break;

    case WM_COMMAND :
      switch (wParam)
      {
        case IDCANCEL :
          fclose(fHelp);
          EndDialog(hDlg, IDCANCEL);
          break;
        case IDOK     :
          if (bShowingTopics)
          {
            /* Show a help item */
            hLB = GetDlgItem(hDlg, ID_HELP_LB);
            iTopic = SendMessage(hLB, LB_GETCURSEL, 0, 0L);

            while (iTopic)
            {
              if (fgets(szBuf, sizeof(szBuf), fHelp) == NULL)
                break;
              if (*szBuf == '\f')
                iTopic--;
            }

            hLB = GetDlgItem(hDlg, ID_HELP_LB);
            SendMessage(hLB, LB_RESETCONTENT, 0, 0L);
            ListBoxSetRedraw(hLB, FALSE);

            while (fgets(szBuf, sizeof(szBuf), fHelp) != NULL && *szBuf != '\f')
            {
              char *szEnd = szBuf + strlen(szBuf) - 1;
              if (*szEnd == '\n')
                *szEnd = '\0';
              SendMessage(hLB, LB_ADDSTRING, 0, (DWORD) (char far *) szBuf);
            }

            ListBoxSetRedraw(hLB, TRUE);
            SetFocus(hLB);
            bShowingTopics = FALSE;

            hTopics = GetDlgItem(hDlg, ID_TOPICS);
            EnableWindow(hTopics, TRUE);
            WinSetAttr(hTopics, 0x31, TRUE);
          }
          else
          {
            rewind(fHelp);
            goto get_topics;
          }
          break;
        case ID_TOPICS:
          rewind(fHelp);
          goto get_topics;
      }
      return TRUE;

    case WM_CHAR :
      if (wParam == VK_ESC)
      {
        fclose(fHelp);
        EndDialog(hDlg, IDCANCEL);
      }
      return FALSE;

    default :
      return FALSE;
  }
}


