;------------------------------------------------------------------
;  Function:   printstr(y,x,str_ptr)
;
;  This function prints a string to the screen
;
;
;------------------------------------------------------------------

include DATASEG.H

    x_off     dw    00
    y_off     dw    00
    bperln    db   0160           ; bytes per line

include ENDDSEG.H

include  PROGSEG.H

    public   printstr
    printstr proc NEAR

    push bp                  ; save c's base pointer
    push es                  ; save es, must be same as ds in S model
    push ds

    mov  bp,sp

    mov  ax,8[bp]            ; get y offset
    mov  y_off,ax

    mov  ax,10[bp]            ; get x offset
    mov  x_off,ax

    mov  si,12[bp]           ; get string ptr

;;;;;;;;;;;;;;;;;;;;;;;;
;; Check Adapter Type ;;
;;;;;;;;;;;;;;;;;;;;;;;;
    mov  ah,0fH              ; function number for ROM BIOS video int
    int  010H                ; perform interrupt
    cmp  al,07               ; check if mode 7, monochrom mode
    jz monochrom
    mov  ax,0b800H           ; CGA/EGA vid ram segment
    jmp  endchk
monochrom:
    mov  ax,0b000H           ; Monochrome vid ram segment
endchk:
    mov  es,ax

    mov  ax,y_off            ; calculate offset
    mul  bperln              ; mult. by bytes per line to get vert offset
    shl  x_off,1             ; mult by two, 2 bytes per char
    add  ax,x_off
    mov  di,ax               ; mov to di and use as pointer to vid ram

    mov  ah,BYTE PTR ds:[si] ; get character 
    cmp  ah,00
    jz   restregs            ; string is null

print_it:

    mov  BYTE PTR es:[di],ah ; put it on the screen, only one byte
    inc  si                  ; goto next char
    add  di,02               ; goto next character byte on screen
    mov  ah,BYTE PTR ds:[si] ; get character
    cmp  ah,00               ; check if Null
    jnz  print_it

restregs:
    pop  ds
    pop  es
    pop  bp                  ; restore the base pointer
    ret  

printstr endp
include  ENDPSEG.H
end      printstr

