#include "\lc\header\stdlib.h"
#include "\switch\c\dbase.h"

#ifndef NULL
     #define  NULL 0
#endif

#define  ERROR -1

void     main()

{

    void printstr();

    char strbuf[15],
         asccode,
         scancode;

    DBF  *opendbf(),
         *dbf_ptr;

    int  readrec();


    long rec;

    scrollup(0,0,24,79,0,7);

    dbf_ptr = opendbf("test.dbf");          /* open the DBF and get the ptr */

if(dbf_ptr){

    sprintf(strbuf,"%02d/%02d/%02d",(int)dbf_ptr->header.mm,(int)dbf_ptr->header.dd,(int)dbf_ptr->header.yy);
    printstr(0,0,"Last Update: ");
    printstr(0,13,strbuf);

    sprintf(strbuf,"%ld",dbf_ptr->header.no_recs);
    printstr(0,40,"Number Of Records: ");
    printstr(0,59,strbuf);

    sprintf(strbuf,"%ld",dbf_ptr->curr_rec);
    printstr(1,0,"Current Record: ");
    printstr(1,16,strbuf);

    sprintf(strbuf,"%d",dbf_ptr->header.rec_len);
    printstr(1,40,"Record Length: ");
    printstr(1,55,strbuf);

    sprintf(strbuf,"%d",dbf_ptr->header.head_len);
    printstr(1,60,"Head Len:");
    printstr(1,70,strbuf);

    scrollup(3,0,3,79,0,112);
    scrollup(4,0,24,79,0,15);
    scrollup(23,0,24,79,0,120);
 
    printstr(23,0,"  F1 -Next  F2 -Prev  F3 -Bott  F4 -Top  F5 -Dele  F6 -Undel  F7 -Append");
    printstr(24,0,"  F8 -      F9 -      F10 - Zap ");

    printstr(3,0,"   Name           Type         Length                     Value");

    scancode = 0;
    rec = 1;
    asccode = 0;

    while(scancode != 1){

         readrec(dbf_ptr,rec);

         printstr(1,16,"     ");                      /* clear old rec no */
         sprintf(strbuf,"%ld",dbf_ptr->curr_rec);
         printstr(1,16,strbuf);

         if(dbf_ptr->deleted)
              printstr(2,0,"DELETED");
         else
              printstr(2,0,"       ");

         showflds(dbf_ptr->fields);

         keyboard(&asccode,&scancode);

         switch(scancode){
              case 59:       /* F1 */
                   ++rec;
                   break;
              case 60:       /* F2 */
                   --rec;
                   break;
              case 61:       /* F3 */
                   rec = dbf_ptr->header.no_recs;
                   break;
              case 62:       /* F4 */
                   rec = 1;
                   break;
              case 63:       /* F5 */
                   delete(dbf_ptr,rec);
                   break;
              case 64:       /* F6 */
                   undelete(dbf_ptr,rec);
                   break;
              case 65:       /* F7 */
                   if(append(dbf_ptr) < 1)
                        printstr(0,0,"I/O ERROR APPENDING TO FILE !!");
                   sprintf(strbuf,"%ld",dbf_ptr->header.no_recs);
                   printstr(0,59,strbuf);
                   rec = dbf_ptr->curr_rec;
                   break;
              case 68:       /* F10 */
                   if(zap(dbf_ptr) < 1)
                        printstr(0,0,"ERROR ZAPPING FILE !!!");
                   rec = 0;
                   break;
         }
         if(rec == 0 && dbf_ptr->header.no_recs > 0){
              snd(1500,10);
              rec = 1;
         }
         if(rec > dbf_ptr->header.no_recs){
              snd(400,15);
              rec = dbf_ptr->header.no_recs;
         }
    }

    closedbf(dbf_ptr); 

    scrollup(0,0,24,79,0,7);
}

exit(0);

}

/*-----------------------------------------------------------------------------
    Name:     SHOWFLDS()

    Description:   Displays fields and values on the screen

----------------------------------------------------------------------------*/

int showflds(tmpfield)

    FIELD     *tmpfield;

{
void     printstr();
int cntr;
char     strbuf[15];


    for(cntr=4;cntr<23;++cntr){
         printstr(cntr,0,tmpfield->name);
         switch(tmpfield->type){
              case 'C':
                   printstr(cntr,15,"Character");
                   break;
              case 'N':
                   printstr(cntr,15,"Numeric");
                   break;
              case 'D':
                   printstr(cntr,15,"Date");
                   break;
              case 'L':
                   printstr(cntr,15,"Logical");
                   break;
         }

         sprintf(strbuf,"%d",tmpfield->fld_len);
         printstr(cntr,33,strbuf);

         printstr(cntr,40,tmpfield->fld_val);

         if(tmpfield->next)
              tmpfield=tmpfield->next;
         else
              cntr=99;

    }

    return(1);

}
