// *********************************************** //
// DBSERVER.C: Program to manage the flow of the
// messages to the listbox.
// *********************************************** //

#include <windows.h>
#include "DBSERVER.H"
#include "DBPUTS.H"
#include "string.h"

HANDLE hInst;
HWND	hDbLog = (HWND) NULL;

#pragma argsused
// **************************************************
// WinMain function.
// --------------------------------------------------
// Note that there is no "FAR" used in the call here.
// **************************************************
int PASCAL WinMain(
HANDLE hi,
HANDLE hPrevi,
LPSTR lpCmdLine,
int nCmdShow )
{
	MSG msg;

	if (!hPrevi)
	if (!MkClass(hi))
		return (FALSE);


	if (!MkWindow(hi, nCmdShow))
		 return (FALSE);


	while (GetMessage(&msg,
		NULL,
		NULL,
		NULL))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return (msg.wParam);
}


// **************************************************
// Function MkClass()
// --------------------------------------------------
// Register the class.
// **************************************************
BOOL MkClass(
HANDLE hi)
{
	WNDCLASS  wc;

	wc.style = NULL;
	wc.lpfnWndProc = DbMessageServer;

	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hi;
	wc.hIcon = LoadIcon(hi, (LPSTR) "DBSERVERIcon");
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName =  "DBSERVERMenu";
	wc.lpszClassName = "DBSERVERClass";


	return (RegisterClass(&wc));

}


// **************************************************
// Function MkWindow()
// --------------------------------------------------
// Perform a standard Windows window initalization.
// **************************************************
BOOL MkWindow(
HANDLE	hi,
int		nCmdShow)
{
	HWND	hWnd;

	hInst = hi;


	hWnd = CreateWindow(
		 "DBSERVERClass",
		 "DBSERVER Application",
		 WS_OVERLAPPEDWINDOW,
		 CW_USEDEFAULT,
		 CW_USEDEFAULT,
		 200,					// CX
		 150,					// CY
		 NULL,
		 NULL,
		 hi,
		 NULL
	);


	if (!hWnd)
		 return (FALSE);


	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);
	return (TRUE);

}


// **************************************************
// DbMessageServer()
// --------------------------------------------------
// This is the MainWinProc().  Simply creates a list
// box, and manages the string flow from the DLL.
// **************************************************
long FAR PASCAL DbMessageServer(
HWND hWnd,
WORD message,
WORD wP,
LONG lP)
{
	FARPROC lpAbout;

	switch (message)
	{
	case WM_COMMAND:
		switch(wP)
		{
			case MSG_ABOUT:

				lpAbout = MakeProcInstance(About, hInst);

				DialogBox(hInst,
					"AboutBox",
					hWnd,
					lpAbout);

				FreeProcInstance(lpAbout);

			break;

			// This message will create the list box.
			case MSG_DBSERVER:

				if(hDbLog)	MessageBeep(0);

				else

				hDbLog = CreateWindow(
					"listbox", "DbPuts.DLL",
					WS_VISIBLE    | WS_TABSTOP | 
					WS_THICKFRAME | WS_VSCROLL,
					5, 5, 200, 400, hWnd, NULL,
					hInst, NULL);

				SendMessage(hWnd,			// Message US
					WM_COMMAND,
					MSG_SIG1,
					(LONG) GlobalAddAtom(
						"MSG_DBSERVER processed."));


			break;


			// MSG_SIG1 is sent to remove the message
			// from the system atom table, && put it
			// into the list-box.
			case MSG_SIG1:
			{
				char buf[81];
	
					GlobalGetAtomName((ATOM) lP,
						buf, 80);

					GlobalDeleteAtom((ATOM) lP);

					SendMessage(hDbLog, LB_INSERTSTRING,
						0, (LONG) &buf[0]);

			}
			break;

			// This message is used 2 clear the listbox.
			// Although it's keyed to the MENU resource,
			// it could easily come from the DLL, as 
			// well.
			case MSG_CLEARIT:

					SendMessage(hDbLog, LB_RESETCONTENT,
						0, 0L);

			break;

			default:
				return (DefWindowProc(hWnd, message, wP, lP));
		}
	break;


	case WM_DESTROY:

		PostQuitMessage(0);
	break;


	case WM_CREATE:
		{
		HWND hWndResult;

		hWndResult = SetHandle(hWnd);

		if(hWndResult != hWnd)
			{
			MessageBox(hWnd,
				(LPSTR) "Could not register handle",
				(LPSTR) "DBSERVER Error",
				MB_OK | MB_ICONHAND
			);

				DestroyWindow(hWnd);
			}
		}
	break;


	default:
		return (DefWindowProc(hWnd, message, wP, lP));
	}

	return (NULL);
}


#pragma argsused
// **************************************************
// Function ABOUT
// --------------------------------------------------
// A simple ABOUT procedure.
// **************************************************
BOOL FAR PASCAL About(
HWND hDlg,
unsigned message,
WORD wP,
LONG lP)
{
	switch (message) {
	case WM_INITDIALOG:
		return (TRUE);

	case WM_COMMAND:
		if (wP == IDOK
					|| wP == IDCANCEL) {
		EndDialog(hDlg, TRUE);
		return (TRUE);
		}
		break;
	}
	return (FALSE);
}
