// *********************************************** //
// DBPUTS.c: Library functions to assist WINDOWS //
// developers in debugging their programs.  Creates//
// a listbox and populates it with messages sent to//
// it via DbPuts(...).                                                                  //
//                                                                                                                                      //
// Created 06/23/92, by Randall A. Nagy                         //
//                                                                                                                                      //
//                                                                                                                                      //
// *********************************************** //

#include <windows.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include "dbserver.h"
#include "dbputs.h"

BOOL FAR PASCAL EnumFunc(HWND, LONG);

// static variables, placed on the LocalHeap;
HWND hWnd = (HWND) NULL;        // Who holds the lb
HANDLE  hLi;
WORD            wSS, wHeapsz;
LPSTR   lpParam;

// **************************************************
// WINDOWS Public Function LibMain()
// --------------------------------------------------
// Called by Windows before anything else happens in
// our DLL.  Passes valuable start-up information.
// Serves as a "constructor" for the DLL.
// **************************************************
int FAR PASCAL LibMain(
HANDLE hi,
WORD wSSw,
WORD wHszw,
LPSTR lpCmdLine)
{
WORD wReturn = WinExec("dbserver", SW_SHOW);

      if (wReturn < 32)
      {
      MessageBox(GetFocus(),
              (LPSTR) "DbPuts: could not start server",
               "Error", MB_ICONSTOP);
      }
   else

// Save the IPL stuff for future use (in DS);
        hLi                     = hi;                                   // The instance
        wSS                     = wSSw;                         // The SS of caller
        wHeapsz         = wHszw;                                // Local heapsz
        lpParam         = lpCmdLine;            // The command line

        return(TRUE);           // if false, unload
} // LibMain()

// **************************************************
// WINDOWS Public Function WEP()
// --------------------------------------------------
// Called by Windows before a system shutdown or swap
// out of our DLL.  BorlandC provides a default WEP()
// for you to use, but others do not.  Included here
// for the sake of completeness.  Note that Windows
// doesn't presently utilize the return value, which
// should always be TRUE (1).
// **************************************************
int FAR PASCAL WEP(
int EventCode)
{
        return 1;
} // WEP()

// **************************************************
// USER Public Function SetHandle()
// --------------------------------------------------
// A call to this DLL member will either set it's
// handle up as the listbox server, or will return
// the handle of the application who has the listbox.
// If you get your handle returned to you, then you're
// "it"!
// **************************************************
HWND FAR PASCAL SetHandle(
HWND hWndIn)
{
        if(!hWnd)
                EnumWindows(EnumFunc, (LONG) hWndIn);
        return hWnd;
} // SetHandle()

int FAR  PASCAL DbPuts(
LPSTR message)
{
size_t sLength;

        if(!hWnd)
                return NULL;

        if(!message)
                return NULL;

        sLength = strlen(message);

        if(sLength)
                PostMessage(hWnd, WM_COMMAND, MSG_SIG1,
                        (LONG) GlobalAddAtom((LPSTR) message));

        return (int) sLength;

} // DbPuts()

int FAR PASCAL DbSprintf(LPSTR message,...)
{
   static char chBuffer[1024];
   WORD        sLength;
   va_list     pArguments;

   if(!hWnd)
     return NULL;

   if(!message)
     return NULL;

   va_start(pArguments, message);
   sLength = vsprintf(chBuffer, message, pArguments);
   va_end(pArguments);

        sLength = strlen(chBuffer);

        if(sLength)
                PostMessage(hWnd, WM_COMMAND, MSG_SIG1,
                        (LONG) GlobalAddAtom((LPSTR) chBuffer));

        return (int) sLength;
}

BOOL FAR PASCAL EnumFunc(HWND hwnd, LONG lParam)
{
        if (hwnd == (HWND) lParam)
        {
                hWnd = hwnd;            // Store the new handle
                return FALSE;           // We're DONE, stop enum
        }
        return TRUE;                    // Enum continues...
}

void FAR PASCAL CheckDLL()
{
char buf[80];

// Example of a DLL resource being used;
LoadString(hLi, IPL_MESSAGE, buf, 80);

// We, too, can use our own DLL function;
DbPuts(buf);

DbSprintf("DLL instance %ld",hLi);
}
