// *********************************************** //
// DBPRINTF.c: Library functions to assist WINDOWS //
// developers in debugging their programs.  Creates//
// a listbox and populates it with messages sent to//
// it via DbSprintf(...).									//
//																	//
// Created 06/23/92, by Randall A. Nagy				//
//																	//
//																	//
// *********************************************** //

#include <windows.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include "dbserver.h"
#include "dbputs.h"

BOOL FAR PASCAL EnumFunc(HWND, LONG);

// static variables, placed on the LocalHeap;
HWND hWnd = (HWND) NULL;	// Who holds the lb
HANDLE 	hLi;
WORD 		wSS, wHeapsz;
LPSTR 	lpParam;



// **************************************************
// WINDOWS Public Function LibMain()
// --------------------------------------------------
// Called by Windows before anything else happens in
// our DLL.  Passes valuable start-up information.
// Serves as a stpe of "constructor" for the DLL.
// **************************************************
int FAR PASCAL LibMain(
HANDLE hi,
WORD wSSw,
WORD wHszw,
LPSTR lpCmdLine)
{
char buf[80];

	// Example of a DLL resource being used;
	LoadString(hi, IPL_MESSAGE, buf, 80);

	// We, too, can use our own DLL function;
	DbPuts(buf);

	// Save the IPL stuff for future use (in DS);
	hLi			= hi;					// The instance
	wSS			= wSSw;				// The SS of caller
	wHeapsz		= wHszw;				// Local heapsz
	lpParam		= lpCmdLine;		// The command line

	return(TRUE);						// If FALSE, unload

} // LibMain()



// **************************************************
// WINDOWS Public Function WEP()
// --------------------------------------------------
// Called by Windows before a system shutdown or swap
// out of our DLL.  BorlandC provides a default WEP()
// for you to use, but others do not.  Included here
// for the sake of completeness.  Note that Windows 
// does'nt presently utilize the return value, which
// should always be TRUE (1).
// **************************************************
int FAR PASCAL WEP(
int EventCode)
{
	return 1;
} // WEP()



// **************************************************
// USER Public Function SetHandle()
// --------------------------------------------------
// A call to this DLL member will either set it's
// handle up as the listbox server, or will return
// the handle of the application who has the listbox.
// If you get your handle returned to you, the you're 
// "it"!
// **************************************************
HWND FAR PASCAL SetHandle(
HWND hWndIn) 
{
	if(!hWnd) EnumWindows(EnumFunc, (LONG) hWndIn);

	return hWnd;
} // SetHandle()



// **************************************************
// USER Public Function DbPrintf()
// --------------------------------------------------
// Works like puts, only output is sent to a scroll
// -able list box.  Long lines are clipped, and older
// messages CAN be clipped off in the list-box.
// **************************************************
int FAR  PASCAL DbPuts(
LPSTR message)
{
size_t sLength;

	if(!hWnd)
		return NULL;

	if(!message)
		return NULL;

	sLength = strlen(message);

	if(sLength)
		PostMessage(hWnd, WM_COMMAND, MSG_SIG1, 
			(LONG) GlobalAddAtom((LPSTR) message));

	return (int) sLength;

} // DbPuts()



// **************************************************
// USER Public Function EnumFunc()
// --------------------------------------------------
// This function is passed to Windows.  It is called
// by Windows repeatedly with the handle for each
// top-level Window.  If we find the handle we're 
// looking for, we say so by returning FALSE. Else,
// TRUE keeps us bumping through till the bitter
// end...
// **************************************************
BOOL FAR PASCAL EnumFunc(HWND hwnd, LONG lParam)
{
	if (hwnd == (HWND) lParam)
	{
		hWnd = hwnd;		// Store the new handle
		return FALSE;		// We're DONE, stop enum 
	}
	return TRUE;			// Enum continues...
}

