/*
   DataBase ++ 2.00.
   
   The following example creates a database and fills it with 10 records
   then displays all records on the screen.

   Borland compile ( c4fox.lib == your codebase lib for FoxPro files ):

      bcc -ml -DS4FOX example1 dbpp200.lib c4fox.lib emu.lib mathl.lib cl.lib
*/

#include <dbppdata.hpp>             // DataBase++
#include <iostream.h>

#define MAX_NAMES    10
#define FNAME        "people.dbf"

void main()
{
   int i;
   
   // Create the DBDatabase object with the file name.
   DBDatabase db( FNAME );

   // Create a DBStructure object and add fields to it.
   DBStructure dbs;
   dbs.addField( "name", 'C', 20 );
   dbs.addField( "age", 'N', 3 );

   // Create the database and open it.
   if ( ! db.create( dbs ) )
   {
      cout << "Error creating file\n";
      exit( 1 );
   }
   
   // Create some names.
   char *names[ MAX_NAMES ] = {
      "Jeff", "Wendy", "Kyle", "Nicole", "Scott",
      "Andy", "Dave", "Bruce", "Done", "Henry"
   };

   // Add some records.
   for ( i = 0; i < MAX_NAMES; i++ )
   {
      // Append a blank record.
      db.append();

      // Replace a field with a string.
      db.replace( "name", names[ i ] );

      // Replace a field with an int.
      db.replace( "age", i * 10 );
   }

   // Display all records.
   for ( db.goTop(); !db.eof(); db.skip() )
      cout << db.getString( "name" ) << "   " << db.getInt( "age" ) << endl;

   // Close file.
   db.close();
}

