/*
   Library: DataBase++ Ver. 2.00.
   File:    DBPPSTRU.HPP
   Purpose: Declarations for class DBStructure. Code in dbppstru.cpp
   Notice:  Copyright (C), 1992 - 1994, Jeff Stapleton. All rights reserved.
*/

#ifndef __DBPPSTRU_HPP
#define __DBPPSTRU_HPP

#include <dbppobjt.hpp>  
#include <dbpparay.hpp>    // DBArray class.

/* struct to hold a field definition.
*/
struct DBField : public DBObject 
{
   char *name;
   char type;
   int  len;
   int  dec;
};

/* DataBase structure class.
*/
class DBStructure : public DBObject 
{
   public:

      /* Constructor/destructor.
      */
      DBStructure() : fields( 30, 5 ) {}    // Constructor.
      virtual ~DBStructure() {}             // Destructor.

      /* Methods/operators.                                                   
      */
      void        addField( char *fldName, char type, int len, int dec = 0 ); // Add a field definition.   
      int         numFields() { return fields.itemsInArray(); }               // Return number fields in this.
      DBField *   operator [] ( int idx );                                    // Access to an individual DBField struct.
      DBArray &   fieldArray() { return fields; }                             // Return the fields array.
      
   private:

      DBArray fields;
};

#endif   // __DBPPSTRU_HPP


