/*
   Library: DataBase++ Ver. 2.00.
   File:    DBPPINDX.HPP
   Purpose: Declarations for class DBIndexTag. Code in dbppindx.cpp
   Notice:  Copyright (C), 1992 - 1994, Jeff Stapleton. All rights reserved.
*/

#ifndef __DBPPINDX_HPP
#define __DBPPINDX_HPP

#include <dbppobjt.hpp>
#include <dbpparay.hpp>    // DBArray class.

/* DBIndex file struct.
*/
struct DBIndex : public DBObject 
{
   char  *tagName;
   char  *expression;
   int   unique;
   int   descending;
};

/* DBIndexTag class.
*/
class DBIndexTag : public DBObject 
{
   public:

      /* Construct/destruct.
      */
      DBIndexTag() : indexArray( 10, 2 ) {}
      virtual ~DBIndexTag() {}

      /* Instance methods.
      */
      void        addTag( char *tagName, char *expression,                 // Add a new index tag. 
                          int unique = 0, int descending = 0 );  
      int         numTags() { return indexArray.itemsInArray(); }          // Return number fields in this.
      DBIndex *  operator [] ( int idx ) { return (DBIndex *) indexArray[ idx ]; }    // Access to an individual DBIndex struct.
      DBArray &  idxArray() { return indexArray; }
      
   private:
      
      DBArray indexArray;
};

#endif   // __DBPPINDX_HPP
