/*
   Library: DataBase++ Ver. 2.00.
   File:    DBPPARAY.HPP
   
   Purpose: Declarations for class DBArray. DBArray is an array class that
            holds pointers to DBObject types. It is much smaller than
            the Borland equivalent BI_IArrayAsVector types. This array can be
            converted easily to use templates if your compiler supports them.
   
   Notice:  Copyright (C), 1992 - 1994, Jeff Stapleton. All rights reserved.
*/   

#ifndef _DBPPARAY_HPP
#define _DBPPARAY_HPP

#include <dbppobjt.hpp>

class DBArray : public DBObject
{
   public:

      DBArray( int sz = 1, int growBy = 1 );
      virtual ~DBArray();

      void           add( DBObject *anObject );
      int            itemsInArray() { return numItems; }
      void           ownsObjects( unsigned bool ) { shouldDelete = bool; }
      void           remove( int index );
      void           remove( DBObject *anObject );
      DBObject *    operator [] ( int index );
      
   private:

      DBObject **   theArray;
      int            size;
      int            numItems;
      int            delta;
      int            shouldDelete;

      void           grow();
};

#endif // _DBPPARAY_HPP

