// DBDEMO.CPP
//
// Demo using the DBObject for access to a contact file.
//
// This demo shows the basic functionality of the DBObject.  Feel free to
// modify it as you wish
//
// If you make any changes to the or other code in DBObject, please keep
// me updated at 70043,2641 so that I may include your changes in future
// releases of the object.
//
// Compile using BC++ 3.x - don't worry about settings, the defaults (or
// your own) should be fine.  The DBObject should compile just fine under
// other compilers and OS's so long as it's C++.
//
// You will need to create a project file with DBOBJ.CPP as one of the files!
//
// ...May your operating system never crash...
// Shaun Botha (CIS: 70043,2641)

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <dos.h>
#include "dbobj.h"

#define NAMELEN			35
#define POSITIONLEN		15
#define COMPANYLEN		35
#define ADDRLEN			35
#define CITYLEN			35
#define STATELEN			2
#define ZIPLEN				5
#define TELLEN				15
#define EXTLEN				6
#define COMMENTSLEN		40

// Our contact record - note the extra byte for 0 terminator
// We don't need all this but it is the structure of the DBF file so we
// may as well leave it here.
struct ContactRec {
	char First[NAMELEN+1],
		  Last[NAMELEN+1],
		  Position[POSITIONLEN+1],
		  Company[COMPANYLEN+1],
		  Addr[2][ADDRLEN+1],
		  City[CITYLEN+1],
		  State[STATELEN+1],
		  Zip[ZIPLEN+1],
		  TelOffice[TELLEN+1],
		  TelExt[EXTLEN+1],
		  TelFax[TELLEN+1],
		  TelHome[TELLEN+1],
		  Comments[COMMENTSLEN+1];
} cr;


void main(void)
{
	textattr(7);		// Borland specific stuff
	clrscr();         // ....

	DBObject contact("CONTACT.DBF");					// This will open the file, etc
	if( contact.IsError() ) {           			// On error bale out
		exit(1);
	}

	memset(&cr, 0, sizeof(cr));						// Clear our record
	contact.AppendRecord();                		// Create a blank record

	// Not exactly a great input form, but it works
	printf("First   : ");								// Label
	gets(cr.First);                        	  	// Grab some input
	contact.SetFieldValue("First", cr.First);   	// Plug it into the record

	// You've got the idea, now let's tighten this up
	printf("Last    : "); contact.SetFieldValue("Last", gets(cr.Last));
	printf("Position: "); contact.SetFieldValue("Position", gets(cr.Position));
	printf("Company : "); contact.SetFieldValue("Company", gets(cr.Company));
	printf("Comments: "); contact.SetFieldValue("Comments", gets(cr.Comments));

	// No need to read or write records - just moving around will do the trick

	// Go thru the file showing names, positions, companies and comments
	// Note that GetFieldValue will either return a pointer to a static
	// variable or your specified destination if you gave it.
	clrscr();
	contact.GoTop();
	while( !contact.Eof() ) {
		printf("%s,%s\n", contact.GetFieldValue("First", cr.First), contact.GetFieldValue("Last", cr.Last));
		printf("%s, %s\n", contact.GetFieldValue("Position", cr.Position), contact.GetFieldValue("Company", cr.Company));
		printf("%s\n\n", contact.GetFieldValue("Comments", cr.Comments));
		contact.GoNextRecord();
	}

	// Finished - no need to close as the object will take care of it.
}