// DBObj.CPP
//
// Methods for access dBaseIII+ dbf files.
//
// (c) 1992 ShaunB - CompuServe: 70043,2641
//
// Permission is granted to modify this code as you wish
//
// Author takes no responsibility for breaking your files, life, marriage,
// car, dog, etc.
//
// Note: No support is included for the following, but it will follow soon
//			a) Memo fields - just try it and see what happens!
//			b) Index files of any kind - I have no clue what's happening there!
//			c) Shared access - currently only exclusive access
//
// Please make as many modifications as you wish - maybe even do a bit of
// subclassing here and there for other db structures such as Paradox, etc
//
// Keep my updated on your changes so that I may extend this object

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "dbobj.h"

// Instantiate object and open the file if it's there
DBObject::DBObject(const char *cFName)
{
	InitVars();
	cFileName = new char[strlen(cFName)+1];
	strcpy(cFileName, cFName);
	Open();
}


// Fairly obvious what this does
DBObject::~DBObject(void)
{
	Close();

	if(cFileName)
		delete cFileName;

	if(pFields)
		delete pFields;

	if(pRecBuff)
		delete pRecBuff;
}

// Pretty obvious too
void DBObject::InitVars(void)
{
	memset((void *) &Header, 0, sizeof(Header));
	pFields 		= NULL;
	cFileName 	= NULL;
	nCurPos  	= 0L;
	pRecBuff 	= NULL;
	pFilePtr 	= NULL;
	nErrorCode 	= NoError;
	nNumFields 	= 0;
	bUpdated   	= false;
	bAutoAccess = true;
	bDirty     	= false;
}


// Is it out there ?
const bool DBObject::Exists(void)
{
	FILE *fp;

	if( (fp = fopen(cFileName, "rb")) != NULL ) {
		fclose(fp);
		return(true);
	}
	else
		return(false);
}

// Ahh, the good stuff
void DBObject::Open(void)
{
	ClearError();					// We will always clear error code before access
	if( !Exists() ) {
		SetError(ER_NOEXIST);   // Problem - now what ??
		return;
	}

	pFilePtr = fopen(cFileName, "r+b");
	LoadHeader();              			// Grab the header
	pRecBuff = new char[RecLen()+1];    // Get some space for the buffer
	memset(pRecBuff, ' ', RecLen()+1);  // ...and clear it out
	GoTop();
}


// Boring........
void DBObject::Close(void)
{
	if( bDirty && bAutoAccess )
		WriteRecord();
	WriteHeader();
	fclose(pFilePtr);
}


// Write the EOF character (0x1A) at the end of the file
void DBObject::WriteEof(void)
{
	long Pos = GetFileBytePos();
	fseek(pFilePtr, -1L, SEEK_END);

	byte tmp = 0x1A;
	fwrite(&tmp, 1, 1, pFilePtr);
	GoFileBytePos(Pos);
}


// Put the updated? header back on the file
void DBObject::WriteHeader(void)
{
	if( !bUpdated )
		return;

	// Update last access date
	struct date dp;
	getdate(&dp);
	Header.lastYY = (byte) (dp.da_year - 1900);
	Header.lastMM = (byte) dp.da_mon;
	Header.lastDD = (byte) dp.da_day;

	long Pos = GetFileBytePos();

	fseek(pFilePtr, 0L, SEEK_SET);
	fwrite(&Header, 1, sizeof(Header), pFilePtr);
	for(int x = 0; x < nNumFields; x++) {
		fwrite(&pFields[x], 1, sizeof(DBField), pFilePtr);
	}

	byte tmp[2] = { 0x0D, 0x00 };
	fwrite(&tmp, 1, 2, pFilePtr);

	WriteEof();

	GoFileBytePos(Pos);
}


// Read header and field descriptors
void DBObject::LoadHeader(void)
{
	long Pos = GetFileBytePos();

	fseek(pFilePtr, 0L, SEEK_SET);
	fread(&Header, 1, sizeof(Header), pFilePtr);

	DBField tmp;
	int x, bytes;
	long LPos = GetFileBytePos();

	// First lets count how many fields we have - I know, I know you can work
	// this out mathematically, but I want to do it the hard way - OKAY !
	nNumFields = 0;
	for( x = 0;; x++ ) {
		bytes = fread(&tmp, 1, sizeof(DBField), pFilePtr);
		if( (bytes != sizeof(DBField)) || (tmp.fldName[0] == 0x0D) )
			break;
		nNumFields++;
	}

	if( nNumFields > 0 ) {
		pFields = new DBField[nNumFields];
		pFieldOfs = new int[nNumFields];
		GoFileBytePos(LPos);

		int Ofs = 1;
		for(x = 0; x < nNumFields; x++) {
			pFieldOfs[x] = Ofs;
			fread(&pFields[x], 1, sizeof(DBField), pFilePtr);
			Ofs += pFields[x].fldLen;
		}
	}

	GoFileBytePos(Pos);
}


// Move to a record - this could be speeded up to move relative to the current
// record instead of always moving absolute to the beginning of the file
void DBObject::GoRecord(const long nRecNo)
{
	ClearError();

	if( Header.lastRec < 1 ) {
		SetEof();
		SetBof();
	}
	else {
		if( nRecNo > Header.lastRec )
			SetEof();
		else
			ClearEof();

		if( nRecNo < 1L )
			SetBof();
		else
			ClearBof();
	}

	if( Eof() || Bof() )
		return;

	// First check whether we should update the current record
	if( bDirty && bAutoAccess )
		WriteRecord();

	long ofs = ((nRecNo - 1) * Header.recLen) + Header.headerLen;
	long Pos = GetFileBytePos();
	if( fseek(pFilePtr, ofs, SEEK_SET) != 0 ) {
		GoFileBytePos(Pos);
		SetError(ER_UNDEFRECORD);
	}
	else {
		nCurPos = nRecNo;
		if( bAutoAccess )
			ReadRecord();
	}
}

void DBObject::GoTop(void)
{
	GoRecord(1L);
}

void DBObject::GoBottom(void)
{
	GoRecord(Header.lastRec);
}

void DBObject::GoNextRecord(long n)
{
	GoRecord((long) RecNo() + n);
}

void DBObject::GoPrevRecord(long n)
{
	GoRecord((long) RecNo() - n);
}


// Not exactly interesting huh ?
void DBObject::ReadRecord(void)
{
	long Pos = GetFileBytePos();

	ClearError();
	if( RecNo() > 0 ) {
		if( fread(pRecBuff, 1, Header.recLen + 1, pFilePtr) != Header.recLen + 1 ) {
			SetError(ER_BADRECREAD);
		}
	}
	else {
		memset(pRecBuff, ' ', RecLen() + 1);
		SetError(ER_BADRECNUM);
	}

	GoFileBytePos(Pos);
}


// This isn't too interesting either
void DBObject::WriteRecord(void)
{
	long Pos = GetFileBytePos();

	ClearError();
	if( RecNo() >= 1 ) {
		if( fwrite(pRecBuff, 1, Header.recLen + 1, pFilePtr) != Header.recLen + 1 ) {
			SetError(ER_BADRECWRITE);
		}
		else {
			bUpdated = true;
			bDirty = false;
		}
	}
	else {
		SetError(ER_BADRECNUM);
	}

	GoFileBytePos(Pos);
}


// Create a new empty record buffer
void DBObject::ClearBuffer(void)
{
	memset(pRecBuff, ' ', RecLen()+1);	// Clear the buffer
}

// Append.......
void DBObject::AppendRecord(void)
{
	if( bDirty && bAutoAccess)				// Check we haven't changed current
		WriteRecord();

	long Pos = GetFileBytePos();

	fseek(pFilePtr, -1L, SEEK_END);		// Go to last byte in file - why -
													// because there is (should be) an
													// EOF character at the end of the file
													// which must be overwritten
	Header.lastRec++;
	nCurPos = Header.lastRec;           // Finagle lastRec a bit otherwise
													// we will have to change GoBottom !
	ClearBuffer();								// Create a new, blank record
	WriteRecord();                      // And write it to the file
	if( !IsError() )
		WriteEof();                      // Plug the EOF character at EOF
	else
		GoFileBytePos(Pos);
}


// Is this a valid field number - remember that field numbers start at 1
const bool DBObject::ValidField(const int n)
{
	if( n < 1 || n > nNumFields )
		return(false);
	else
		return(true);
}

// Return the offset of the data for this field in the buffer
const int DBObject::FieldOfs(const int n)
{
	if( !ValidField(n) )
		return(-1);
	else
		return(pFieldOfs[n-1]);
}

// Not difficult to understand
const char * DBObject::FieldName(const int n)
{
	if( !ValidField(n) )
		return("");
	else
		return(pFields[n-1].fldName);
}

// Blah, blah, blah
const int DBObject::FieldLen(const int n)
{
	if( !ValidField(n) )
		return(-1);
	else
		return(pFields[n-1].fldLen);
}

// Blah, blah, blah
const int DBObject::FieldDec(const int n)
{
	if( !ValidField(n) )
		return(-1);
	else
		return(pFields[n-1].fldDec);
}

// Blah, blah, blah
const char DBObject::FieldType(const int n)
{
	if( !ValidField(n) )
		return(-1);
	else
		return(pFields[n-1].fldType);
}

// Grab the data from the buffer for this field number.  If the client has
// specified a recepticle for the data, put it there otherwise use the static
// variable.
// Note that this will always return a string no matter what the actual data
// type - what you do with it afterwards is up to you.
const char *DBObject::GetFieldValue(const int n, char *f)
{
	static char tmp[255];
	if( !ValidField(n) )
		return(NULL);

	// Note use of 'memcpy' - reason -> memo fields are binary and could
	// confuse 'strcpy'

	if(!f) {
		memcpy(tmp, ((char *) pRecBuff) + FieldOfs(n), FieldLen(n));
		tmp[FieldLen(n)] = '\0';
		return(tmp);
	}
	else {
		memcpy(f, ((char *) pRecBuff) + FieldOfs(n), FieldLen(n));
		f[FieldLen(n)] = '\0';
		return(f);
	}
}


// Plug the client's data into field number n
void DBObject::SetFieldValue(const int n, const char *s)
{
	if( !ValidField(n) )
		return;

	// Note we use 'memcpy' and NOT 'strcpy'
	memcpy(((char *) pRecBuff) + FieldOfs(n), s, FieldLen(n));
	int l = strlen(s);

	// Pad with blanks if necessary
	if(l < FieldLen(n)) {
		memset(((char *) pRecBuff) + FieldOfs(n) + l, ' ', FieldLen(n) - l);
	}
	SetDirty();
}


// Return field position from given name
const int DBObject::FieldPos(const char *name)
{
	int x;
	for(x = 1; x <= FieldCount(); x++) {
		if(stricmp(name, FieldName(x)) == 0 )
			return(x);
	}
	return(0);
}


// As above but using a field name instead of numeric id
const char* DBObject::GetFieldValue(const char *name, char *f)
{
	return(GetFieldValue(FieldPos(name), f));
}


// As above but using a field name instead of numeric id
void DBObject::SetFieldValue(const char *name, const char *s)
{
	SetFieldValue(FieldPos(name), s);
}

/////// THAT'S IT SO FAR - HAVE FUN !!!!!!!!!!!!!