/* 
**		file:		d_close.c
**		purpose:	routine to close a dbaseiii file after access by the other routines
**					in dbf.lib.	updates header and places eof marker at end of file.
**		usage:	d = (struct DBF *)malloc(sizeof(struct DBF));
**					strcpy(d->filename,"filename.dbf");
**					d_open(d);
**					... access file with other routines ...
**					d_close(d);
**					free(d);
**		notes:	compile with "tcc -c d_close".	include this file in dbf.lib
**					see dbf.h for structure of DBF.	ALWAYS close a file that has
**					been opened, otherwise records may be lost.
**		author:	Mark Sadler
**		revised:	6/18/87
*/ 		
#include <dos.h>
#include <stdio.h>
#include "dbf.h"

int d_close(struct DBF *d)
{
	union REGS inregs,outregs;
	if(d->status == updated)
	{
		/* update date data */
		inregs.h.ah=0x2a;
		intdos(&inregs,&outregs);
		d->update_day=outregs.h.dl;
		d->update_mo=outregs.h.dh;
		d->update_yr=outregs.x.cx-1900;

		/* position at start of file */
		rewind(d->file_ptr);
		/* rewrite header */
		fwrite(&d->dbf_version,1,12,d->file_ptr);

		/* position at end of file	 */
		fseek(d->file_ptr,0L,2);
		/* write eof */
		fwrite("\x1a",1,1,d->file_ptr);
	}
	/* free fields array and record */
	free(d->fields_ptr);
	free(d->record_ptr);
	fclose(d->file_ptr);
}
