/*
A simple dialog box example -- a fill in the blank and a multiple choice
question with two buttons (Confirm and Abort.)
*/

#include "pro.h"
#include "xglobals.h"
#include "dbpro.h"
#include "colors.h"
#include "xcodes.h"
#include "video.h"
#include <string.h>
#include <conio.h>

void main(void);
int blip(void *);

/* target variables -- target variables can be linked to a question and are
updated when the dialog box is exited.  DO NOT free() target variables for
free_form's, the pointer to the current response is simply assigned to
the target variable.  When the dialog box is rerun it will free the last
response and substitute it with the current response.  If you have already
freed the same memory block -- well you know.
*/

char *name;					/* first question target variable */
int job;					/* second question target variable */

/* miscellaneous data for the dialog box */
char *responses[] = {		/* possible responses to the multiple choice */
	"Doctor",				/* question */
	"Lawyer",
	"Butcher",
	"Welder",
	"Accountant",
	"Housewife",
	"Mechanic",
	"Pilot",
	NULL
};

char available[] = {		/* indicates types of responses in multiple */
	1,						/* choice question, 0 - not available, */
	1,						/* 1 - available, 2 - title (not available) */
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1
};

char db_available[] = {		/* the dialog box consists of four questions */
	1,						/* this array indicates which questions can */
	1,						/* be modified, 1-yes, 0-no */
	1,
	1,1,1,1,1,1,1,1
};

char *exit_codes[] = {		/* corresponds to the possible exit values */
	"ABORT",				/* generated by a dialog box */
	"CONFIRM",
	"ASCEND",
	"DESCEND",
	"MOUSE",
	"","","","","","",
	"MENU"};

char *db_help[] = {			/* dialog box help screen text */
	" ",
	" Press ENTER to confirm.",
	" Press ESC to abort.",
	" Press arrow keys to choose a question.",
	" Press alpha to change text questions.",
	" Press spacebar or grey+ to change multiple choice questions. ",
	" ",
	" Press any key to continue ",
	"",
	NULL
};

/* help routine -- this function displays the dialog box help text */
int help(db_ptr)
dialog_box *db_ptr;
{
	unsigned handle;

	db_ptr = db_ptr;
	scroll_bars_on = NONE;
	wn_openw(handle = wn_putslist(db_help,white,black,wherex(),wherey(),
		HEAD_ON,NULL,NULL));
	getch();
	wn_delw(handle);
	return(TRUE);
}

/*
	links the F1 key to the help() function (creating a macro
	called context_help)
*/
makemacro(context_help,XF1,help)

/* a null terminated list of macros used by this dialog box */
unsigned *allmacros[] = {
	context_help,
	NULL
};

/* definition of each the question used in the dialog box */

free_form first_question = {
	FREE_FORM,  			/* question type */
	0,						/* tile handle -- if your dialog box consists
							   of several virtual screens you can indicate
							   which virtual screen the question is
							   displayed in
							*/
	NULL, NULL, NULL,		/* in - this routine will be executed when the
							   question is initially highlighted.
							   out - this routine will be executed when the
							   question is dehighlighted,
							   action - this routine will be executed each
							   time the question is exited (e.g. when you
							   exit the free_form line editor)
							*/
	"~Name",				/* statement */
	2, 2,					/* statement x, y */
	XALTN,					/* shortcut key - the actual keypress value
							   which when recognized will navigate directly
							   to this question
							*/
	NULL, "Unknown",		/* response & default response - the response
							   contains the current response to the question
							   typically you would assign this a NULL value,
							   if you do assign it a value make sure that it
							   is a pointer to a dynamically allocated memory
							   block.

							   default response - if response is NULL db_run
							   uses a dynamically allocated copy of the
							   default response as the actual response.
							*/
	19, 2, 30,				/* response x, y, and length - indicates where
							   to display the response string and how many
							   characters to devote to the display area
							*/
	NULL,					/* insurance -- typically set to NULL, this
							   member of the structure is used to keep
							   a copy of the string when it is edited, if
							   the user wants to restore the original
							   string we use this copy to recreate it
							*/
	&name,					/* target -- this char** is updated to the
							   same value as response on exiting the
							   dialog box.  You can use this to have
							   dialog boxes update global (or local)
							   variables in your existing routines.
							*/
	0,						/* cursor position - indicates the default
							   position of the edit cursor on editing
							   the response string
							*/
	NULL,					/* macros - if you want to have some special
							   macros during the line editor process
							   assign them here.
							*/
	TRUE					/* refresh - always set to TRUE */
};

multi_choice second_question = {

	/*************************** same as above ****************************/
	MULTI_CHOICE,  			/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, action */
	"~Occupation",			/* statement */
	2, 5,					/* statement x, y */
	XALTO,					/* shortcut key */

	/********** these fields differ from the free_form question ********/

	NULL,					/* response mask - you can elect to not display
							   the statement portion and the response portion
							   and to substitute this string constant in the
							   same position as the response.  This makes a
							   multiple choice question behave like a pull
							   down menu.  To not use this feature set this
							   to NULL.
							*/
	responses,				/* response list - a NULL terminated list of
							   strings representing the possible responses
							   to the multiple choice question.
							*/
	available,				/* available - a list of chars which corresponds
							   to the above responses list, where a 0
							   indicates that the string could be a valid
							   response but is not at the moment.  A 1
							   indicates that it is a valid response, and a
							   2 indicates that the item is never a valid
							   response, but is simply a title used to
							   segment the list
							*/
	0,						/* default response - indicates the
							   member of the above responses list which
							   is the current response to the question.
							*/
	19, 5, 30,				/* response x, y, and length - same as a
							   free_form
							*/
	MAX_WINDOWS, 0,			/* aux window & tile - a multiple choice
							   question requires a window to display
							   the pull down list in -- set this to
							   MAX_WINDOWS to have db_run create the
							   window as needed.
							*/
	box1,					/* if window is created (see above) it will
							   use these border characters
							*/
	"Profession",			/* and -- it will have this name at the top */
	NULL,					/* this name at the bottom */
	HEAD_ON,				/* and will use this shading style */
	NULL,					/* list pointer - a multiple choice question
							   requires a list_rec for the pull down list.
							   Set this value to NULL and db_run will create
							   the list_rec as needed.
							*/
	&job,					/* target - the int* will be updated with the
							   current response offset on exiting the
							   dialog box.  Use this field to update
							   global (or local) variables in your
							   application
							*/
	NULL,					/* macros - If you want to have some special
							   macros active in the pull down lists, assign
							   them to this field.
							*/
	4,						/* if you want the pull down list to be displayed
							   in side by side columns indicate the number of
							   columns here.  If you want a horizontal list
							   (like a LOTUS menu use MAXINT.)
							*/
	TRUE					/* refresh - always set to TRUE */
};

button confirm_button = {

	/************************* same as above *********************/
	BUTTON,					/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	"~Confirm",				/* statement */
	16, 7,					/* statement x, y */
	XALTC,					/* shortcut key */

	/*************** these fields are unique to buttons ***********/
	box0,					/* border characters - if you want the
							   button statement surrounded by a box
							   indicate the box type here.  Otherwise
							   set this field to NULL.
							*/
	HEAD_ON,				/* shading - if your button is surrounded
							   by a box you can use a shadowing effect
							   with this field.
							*/
	XENTER,					/* hitting button is = XENTER - when a button
							   is pressed it simply pushes a key value
							   or db opcode onto the queue.  The
							   interpretation of this value can then
							   do things like confirm the dialog box, etc.
							   If you do not want to use this feature of
							   buttons assign this field a value of
							   DO_NOTHING.
							*/
	XENTER,					/* flash key - you can 'press' a button without
							   changing the selected question to the button
							   by pressing this key value.  Note that the
							   mouse routines simply put the shortcut key
							   value in the queue when you press and release
							   on a button and they put this key value into
							   the queue when you quickly click on a button.
							   As such this must be a unique value, otherwise
							   clicking on this button, could actually activate
							   another button.  Note that the value does
							   not have to be a keyboard generatable value it
							   should just be unique to the other shortcut keys.
							*/
	FALSE,					/* continuous - if holding the mouse button down
							   and sitting on a dialog box button should
							   continuously push shortcut key values onto the
							   queue indicate TRUE in this field, otherwise
							   indicate FALSE.  Generally you would indicate
							   TRUE if it made sense for the button to perform
							   some continuous action if you held the mouse
							   cursor on it.  For example, if you had button
							   which 'flipped' through a series of records
							   you might make this field TRUE.
							*/
	CONFIRMED				/* exit value - if the button results in
							   exiting the dialog box you can change the
							   exit value with this field.  You can use
							   this if you want to specifically determine
							   that a user exited by using a certain
							   button.
							*/
};

button abort_button = {

	/************************* same as above ***************************/
	BUTTON,					/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	" ~Abort ",				/* statement */
	27, 7,					/* statement x, y */
	XALTA,					/* shortcut key */
	box1,					/* border characters */
	HEAD_ON,				/* shading */
	XESC,					/* hitting button is = XESC */
	XESC,					/* flash key */
	FALSE,					/* continuous */
	ABORTED					/* exit value */
};

/*
 * radio-check buttons, if assigned to a radio group then only
 * one member of the group can be ON at one time.  Also, effects
 * the way items are navigated to.  For example, when navigating
 * from any item to an item within a radio group dbrun will select
 * the currently selected item within the radio group, rather than
 * the next item in the question list.  Also, navigating onto a
 * radio group item will automatically check it.  to navigate between
 * items within a radio button group use the LEFT and RIGHT commands
*/

rcbutton check1 = {
	RCBUTTON,				/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	"~Scaly patches",		/* statement */
	2, 11,					/* statement x, y */
	XALTS,					/* shortcut key */
	CHECK,					/* checkbox! */
	FALSE,					/* checked? */
	NULL					/* target variable */
};

rcbutton check2 = {
	RCBUTTON,				/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	"~Peeling skin",		/* statement */
	22, 11,					/* statement x, y */
	XALTP,					/* shortcut key */
	CHECK,					/* checkbox! */
	FALSE,					/* checked? */
	NULL					/* target variable */
};

rcbutton radio1 = {
	RCBUTTON,				/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	"Has ~fever",			/* statement */
	2, 13,					/* statement x, y */
	XALTF,					/* shortcut key */
	RADIO(0),				/* radio button! */
	FALSE,					/* checked? */
	NULL					/* target variable */
};

rcbutton radio2 = {
	RCBUTTON,				/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	"No F~ever",			/* statement */
	22, 13,					/* statement x, y */
	XALTE,					/* shortcut key */
	RADIO(0),				/* radio button! */
	TRUE,					/* checked? */
	NULL					/* target variable */
};

/* various bits of data for use in next question... */
char *alistchoices[] = {
	"apples",
	"oranges",
	"bananas",
	"grapes",
	"pears",
	"kumquats",
	"pomegranites",
	"potatoes",
	"carrots",
	"peas",
	"beets",
	"wheat",
	"oats",
	"bran",
	"corn",
	"chicken",
	"turkey",
	"beef",
	"pork",
	"ham",
	"bacon",
	NULL
};
char lotsofones[] = {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1};
char lotsofzeros[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

/* this is a list box question */
list alist = {
	LIST,					/* question type -- must be LIST */
	0,						/* tile to display list box in */
	NULL,NULL,NULL,			/* edit checking routines */
	"Test",					/* statement */
	2,14,					/* statement coordinates */
	XALTT,					/* shortcut key */
	SELECT_ONE,				/* list type -- must be SELECT_ONE or CHECKLIST */
	MAX_WINDOWS,			/* the list box uses a window to display itself in */
	4,40,					/* if the above window handle is not valid we use */
	3,15,					/* this info to create the window */
	1,1,
	4,40,
	HEAD_ON,
	NULL,
	NULL,
	box1,
	NO_BARS,

	0,						/* initially selected element in the list */
	alistchoices,			/* null terminated list of elements in the list */
	lotsofones,				/* a list of chars corresponding to the list of
							   elements where 0 = not available, 1 = available,
							   and 2 = title. */
	lotsofzeros,			/* a list of chars corresponding to the list of
							   elements where a 0 = toggled on and 1 = toggled
							   off */
	" "," ",				/* on and off strings */
	NULL,					/* a list question requires a list_rec structure.
							   set this to NULL to have db_run create the
							   structure as needed.  If you wish to supply
							   the structure set this to point to the
							   structure */
	NULL,					/* target variable */
	NULL,					/* macros */
	TRUE,					/* when TRUE list is redrawn.  Set to TRUE when
							   initializing structure */
	FALSE,                  /* autodescend.  Set this to FALSE so that cursor
							   will remain in border of list when the list box
							   is selected.  Once user enters list this value
							   is set to TRUE.  Using FALSE when you initialize
							   the str structure will make it work like MAC &
							   MS-WINDOWS. */
	255						/* maxcols.  Set this value to the maximum number
							   of columns you want displayed side by side in
							   the list.  db_run will attempt to fill the
							   columns rowwise creating additional columns as
							   needed until this number is reached.  Once this
							   number is reached it adds additional rows to
							   the virtual screen.
							*/
};


void *simple_questions[] = {
	&first_question,
	&second_question,
	&confirm_button,
	&abort_button,
	&check1,
	&check2,
	&radio1,
	&radio2,
	&alist,
	NULL
};

dialog_box simple_db = {

	MAX_WINDOWS,			/* 	window handle -- set this to MAX_WINDOWS
								if you want db_run to create the window
								for you
							*/
	NULL, NULL,				/* 	post-size and post-move routines -- after
								sizing or moving a dialog box these
								routines will be executed
							*/
	TRUE, FALSE,			/* 	move and size OK -- set these to TRUE if
								it is OK to move or size the dialog box
							*/
	simple_questions,		/* 	questions -- set this to the array of
								questions which comprise the dialog box
							*/
	db_available,			/* 	available questions -- this is an array of 1s
								an 0s where 1 indicates that a user can modify
								the response to the question and 0 indicates
								that it is not allowed.
							*/
	0,						/* 	selected question -- indicates the currently */
	default_db_cmds,		/* 	keyboard commands -- an array of ints which
								assigns each db opcode to a keypress, e.g.
								you might assign XENTER to CONFIRM and XESC
								to ABORT.
							*/
	FALSE,					/* 	If FALSE the dialog box will be automatically
								brought to the top of the window stack when
								activated.  Otherwise, you will be able to
								run the dialog box but other windows may
								obscure it.  Normally set to TRUE for menu
								bars, or some sort of dialog box which
								represents a desktop.  For example you
								could represent the Framework II desktop
								as a background dialog box.
							*/
	&msmono,				/* 	db_colors -- an array of unsigned chars
								containing video attributes to use for
								various parts of a dialog box
							*/
	&default_db_delimiters,	/* 	db delimiters -- an array of chars which
								are used to delimit the response areas
								for various question types
							*/
	NULL,					/* 	insurance -- normally set to NULL, this
								pointer is used internally by db_run.
								When a dialog box is activated a copy
								of the current responses is made and
								pointed to by this field.  If the
								user ABORTS the dialog box we restore
								the original responses using this
								copy.
							*/
	allmacros,				/* 	macros -- indicates any special macros for
								this dialog box.
							*/

							/* 	All of these are used to create a
								window to display the dialog box in
								if the above window handle does not
								exist.
							*/
	22, 50,					/* virtual rows and columns */
	1, 1,					/* physical x & y */
	1, 1,					/* virtual x & y */
	22, 50,					/* viewport rows & columns */
	HEAD_ON,				/* shading style */
	"A simple dialog box",	/* primary dialog box name */
	"secondary name",		/* secondary dialog box name */
	box1,					/* window border characters */
	NONE,					/* scroll bars style */
	lightgray, black		/* the virtual screen attributes */
};

void main()
{
	int result;
	unsigned char head = 0, tail = 0;
	unsigned int queue[256];

	/* initialize The WINDOW PRO - required */
	wn_init();

	/* call blip during the keyboard/mouse polling loop */
	idle = blip;

	/* initialize The DB PRO message queue - required */
	db_switchqueue(&head, &tail, queue);

	/* execute the dialog box */
	result = db_run(&simple_db, 0);

	/* get rid of the dialog box - if memory is tight you can deleted
	   the dialog box window each time. Doing this will slow down
	   execution but allow you to cram in more data.  Note that
	   if you delete a dialog box window you should reset the
	   window handle back to MAX_WINDOWS.  When a window handle
	   is deleted it is returned to the free handles pool.  If the
	   handle were to get reused and this dialog box were rerun
	   it would believe that it had a valid window handle and
	   would not create a new window (of the proper size and location.)
	*/
	wn_delw(simple_db.handle); simple_db.handle = MAX_WINDOWS;

	/* restore the cursor position */
	v_gotoxy(oldx,oldy);

	/* restore the cursor shape */
	v_curshape(oldb, olde);

	/*
	   display the results -- demonstrates how running a dialog box
	   updates application variables.
	*/
	printf("The user exited the dialog box by %s.\n",exit_codes[result - 1]);
	printf("Occupation = %s\n",responses[job]);
	printf("Name = %s\n",name);

}

/* this is a sample polling loop function */
int blip(v)
void *v;
{
	static int pos = 1;

	vs_putc(simple_db.handle,0,pos,21,white,black,' ');
	pos++;
	if (pos > 50) pos = 1;
	vs_putc(simple_db.handle,0,pos,21,white,black,'>');
	return(1);
}
