#include "pro.h"
#include "xglobals.h"
#include "dbpro.h"
#include "dbops.h"
#include "colors.h"
#include "makemenu.h"
#include "vs.h"
#include "vidmodes.h"
#ifdef MSC
#include <malloc.h>
#else
#include <alloc.h>
#endif
#include <string.h>

#define SUBMENU				((multi_choice *)((*db_ptr)->questions[count]))
#define SUBMENUID(id)		((multi_choice *)(db->questions[id]))

db_delimiters pulldowns = {
	box1,
	NULL,
	box1,
	"(\07)","( ) ",
	"[X] ","[ ] "
};

/*
   These are the macros that let the user pull down the menu to the
   left or right of the current pull down menu -- by pressing the
   left/right keys.
*/
unsigned smright_macro[] = {RIGHT, 3, DESCEND, NEXT, ASCEND};
unsigned smleft_macro[] = {LEFT, 3, DESCEND, PREVIOUS, ASCEND};
unsigned mmright_macro[] = {RIGHT, 1, NEXT};
unsigned mmleft_macro[] = {LEFT, 1, PREVIOUS};
unsigned *mmmacros[] = {
	mmright_macro,
	mmleft_macro,
	NULL
};
char e[50];

/*
   This function is attached to the resize function pointer of the
   dialog box containing the menu.  It is dependent on the menu strings
   array being called "menu", the available menu items being called
   "available", and the dialog box being pointed to by "db".

	The function will asses the size of the viewport and determine if
	it is wide enough to accomodate the menu bar.  If it is not it will
	'stack' the menu bar items vertically and, if required, increase the
	height of the tile containing the menu bar to accomodate the
	'stacking.'
*/

int ox, oy;
int redomenu(db_ptr)
void *db_ptr;
{
	unsigned char tile_handle = 0;
	unsigned int handle, handle1;
	dialog_box *db;

	db = db_ptr;
	handle1 = handle = db->handle;

	/* if the viewport has changed in size ... */
	if ((ox !=  TILE->port_rows) || (oy != WDW->port_columns)) {

		/* clear the viewport */
		vs_clrvs(db->handle, tile_handle, white, black);

		/* remake the menu bar */
		handle = SUBMENUID(0)->aux_handle;
		makemenu(menu, available, handle1, tile_handle, TRUE, TRUE,
			FALSE, FALSE, TRUE,	WDW->border, WDW->border_chars, &db);

		/* redisplay the menu bar dialog box */
		db_display(db);
	}
	ox = TILE->port_rows;
	oy = WDW->port_columns;
}


/*
   This function initializes the dialog box if 'mode' is TRUE.
   Otherwise, it simply determines how to arrange the menu bar
   items to fit within the prescribed viewport and initializes
   the dialog_box members to the values passed as parameters.
*/

void makemenu(menu_choices, available, handle, tile_handle, move,
	size, background, mode, resize, shading, boxchars, db_ptr)
char *** menu_choices;				/* pointer to an array of arrays to strings
									   indicating the menu choices
									*/
char **available;					/* pointer to an array of chars indicating
									   which items in the menu bar can be
									   selected by the user
									*/
unsigned int handle;				/* handle of the window where the menu
									   is displayed
									*/
unsigned char tile_handle;			/* handle of the tile where the menu
									   is displayed
									*/
unsigned char move, size;			/* set to TRUE if the window containing
									   the menu bar can be sized or moved.
									*/
unsigned char *boxchars;			/* determines which border characters
									   to use when creating the windows
									   for the pull down menus
									*/
char background;					/* If FALSE the menu bar window will
									   be brought to the top of the current
									   stack of windows automatically when
									   activated.  Generally set to TRUE
									   when the menu bar is part of a
									   desktop-like arrangement.
									*/
char mode;							/* only set to TRUE first time you call
									   makemenu for a particular menu.
									   Later calls to makemenu (generally
									   to alter the available items or
									   change the strings relating to
									   menu selections, i.e. to change
									   ON to OFF,) should be made to with
									   this parameter set to FALSE.
									*/
char resize;						/* only set to TRUE if you want makemenu
									   to rearrange the menu bar.  Generally
									   set to TRUE the first time makemenu
									   is called, when the main menu strings
									   are changed, or when the viewport size
									   has changed.
									*/
char shading;						/* Set to HEAD_ON, UPPER_LEFT, NONE, etc.
									   to change the shadowing effect on the
									   pull down menus.
									*/
dialog_box **db_ptr;				/* Returns a dialog_box pointer when mode is
									   set to TRUE -- use this value to run the
									   menu bar dialog box via the function
									   db_run().
									*/
{
	int number_of_menus = 0, count, row, column;
	unsigned **menu_macros, *new_macro;
	char **questions;

	/* get number of items in menu bar */
	while(menu_choices[number_of_menus++] != NULL);
	number_of_menus -= 2;

	/* Do we need to allocate a dialog box structure? */
	if (mode) *db_ptr = malloc(sizeof(dialog_box));

	/*
	 * creates a macro used by all sub-menus.  The macro
	 * makes pressing the Alt+the first character of a menu
	 * bar item (from within a sub-menu) exit the submenu and
	 * pull down the menu associated with the Alt-key.
	*/

	/* Allocate space for the macro set */
	menu_macros = malloc((3 + number_of_menus)*sizeof(int *));

	/*
	 * the first two macros in the set allow the user to navigate
	 * from to the left and right pull down menu -- from within
	 * the submenu.
	*/
	menu_macros[0] = smright_macro;
	menu_macros[1] = smleft_macro;
	menu_macros[number_of_menus + 2] = NULL;

	/* this loop sets up a macro for each Alt-key combination */
	for (count = 0; count < number_of_menus; count++) {

		/* allocate space for the macro */
		new_macro = malloc(4 * sizeof(int));

		/* substitute the Alt-key for ... */
		new_macro[0] = alt(*((menu_choices[0])[count]));

		/* two commands (in reverse order) */
		new_macro[1] = 2;

		/* second the same Alt-key combination */
		new_macro[2] = alt(*((menu_choices[0])[count]));

		/* and first an ASCEND (exits the submenu) */
		new_macro[3] = ASCEND;

		menu_macros[count + 2] = new_macro;
	}

	/* Allocate memory for question array.
	 * Each item on the menu bar represents a multiple choice
	 * question.  These questions are linked into the dialog box
	 * via this null-terminated array.  The multiple-choice
	 * question (or pull-down menu) is identified by its position
	 * in this array, i.e the 0th item, the 1st item, etc.
	*/
	if (mode) questions = malloc((number_of_menus+1) * sizeof(char *));

	/* set db options */
	(*db_ptr)->handle = handle;					/* associate with a window */
	if (mode) (*db_ptr)->questions = questions;	/* provide a list of questions */
	(*db_ptr)->available = available[0];		/* indicate editable questions */
	(*db_ptr)->cmds = default_db_cmds;			/* command interface */
	(*db_ptr)->bg_operation = background;		/* automatically bring to top */
	(*db_ptr)->move_ok = move;					/* can we move the dialog box? */
	(*db_ptr)->size_ok = size;					/* can we size the dialog box? */
	(*db_ptr)->post_size = redomenu;			/* what to do if we resize? */
	(*db_ptr)->post_move = NULL;				/* what to do if we move it? */
	(*db_ptr)->colors = (v_getmode() == mono ? &msmono : &default_db_colors);
	(*db_ptr)->delimiters = &pulldowns;
	(*db_ptr)->macros = mmmacros;
	(*db_ptr)->id_select = 0;					/* the currently selected item */

	/* required */
	(*db_ptr)->insurance = NULL;

	/* setup submenus */
	column = 2; row = 1;				/* position of the first menu bar item */
	for (count = 0; count < number_of_menus; count++) {

		/* if first time around allocate memory for the menu bar item */
		if (mode) questions[count] = malloc(sizeof(multi_choice));

		/* the question type */
		SUBMENU->question_type = MULTI_CHOICE;

		/*
		 * indicates that it is a pull-down menu type multiple choice
		 * rather than a traditional multiple choice question
		*/
		SUBMENU->response_mask = (menu_choices[0])[count];

		/* the key which automatically navigates to this question */
		SUBMENU->key = alt(SUBMENU->response_mask[0]);

		/* position of this question */
		SUBMENU->responsex = column;
		SUBMENU->responsey = row;
		SUBMENU->maxcols = 1;

		/* figure position of next item */
		column += strlen((menu_choices[0])[count]);
		if ((count < (number_of_menus - 1)) &&
			((column + 2 + strlen((menu_choices[0])[count+1])) >
				WDW->port_columns)) {
			row++;
			column = 2;
		}

		/* default selected item in pull down menu */
		SUBMENU->response_offset = 0;

		/* list of items in pull down */
		SUBMENU->response_list = menu_choices[count+1];

		/* indicates which items in pull down can be selected */
		SUBMENU->available = available[count+1];

		/*
		 * maximum length of response string -- response_mask is
		 * used in place of actual response in a pull-down
		*/
		SUBMENU->responselen = strlen((menu_choices[0])[count]);

		/* each submenu must have a window */
		SUBMENU->tile_handle = tile_handle;
		if (mode) SUBMENU->aux_handle = wn_createw(1, 1, 1, 1, 1, 1, 1, 1,
			FALSE, shading, NULL, NULL);
		wn_togborder(SUBMENU->aux_handle,shading);
		wn_chgbord(SUBMENU->aux_handle,boxchars);
		SUBMENU->aux_tile = 0;

		/* turn off scroll bars on submenus */
		wn_togthumb(SUBMENU->aux_handle, 0, NO_BARS);
		wn_togscroll(SUBMENU->aux_handle, 0, NO_BARS);

		SUBMENU->macros = menu_macros;
		SUBMENU->statement = NULL;
		SUBMENU->whenon = NULL;
		SUBMENU->whenoff = NULL;
		SUBMENU->action = NULL;
		SUBMENU->list_ptr =	NULL;
		SUBMENU->target = NULL;
		SUBMENU->refresh = TRUE;
		SUBMENU->major_head = SUBMENU->minor_head = NULL;
	}
	(*db_ptr)->questions[number_of_menus] = NULL;
	if (resize) wn_sizet(handle, tile_handle, 0, row - TILE->port_rows);
}

/*
 * Returns an integer in sub_menu indicating the last sub_menu
 * selected, and an integer in selection indicating the last item
 * in that sub_menu to be highlighted
 *
 * Returns MENUED if the user exited by pressing the CONFIRM key or,
 * double clicked or dragged and released on a sub_menu item with the
 * mouse
*/
int runmenu(db_ptr, message, submenu, selection)
dialog_box *db_ptr;
int message, *submenu, *selection;
{
	int result;

	result = db_run(db_ptr, message);
	*submenu = db_ptr->id_select;
	*selection = ((multi_choice *)(db_ptr->questions[db_ptr->id_select]))->
		response_offset;
	if ((result == CONFIRMED) || (result == ABORTED)) db_pop();
	return(result);
}
