#include "pro.h"
#include "xglobals.h"
#include "dbpro.h"
#include "colors.h"
#include "xcodes.h"
#include "video.h"
#include "vidmodes.h"
#include <string.h>
#include <conio.h>

void main(void);

char db_available[] = {		/* the dialog box consists of several questions */
	1,						/* this array indicates which questions can */
	1,						/* be modified, 1-yes, 0-no */
	1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
};

/* definition of each question used in the dialog box */

title proglist = {
	TITLE,
	0,
	"Program List: <None>",
	2,2,
	FALSE
};

title currfile = {
	TITLE,
	0,
	"Current File: untitled.c",
	2,3,
	FALSE
};

title warnlevels = {
	TITLE,
	0,
	"Warning Levels",
	2,5,
	FALSE
};

title outputoptions = {
	TITLE,
	0,
	"Output Options",
	19,5,
	FALSE
};

title miscellaneous = {
	TITLE,
	0,
	"Miscellaneous",
	44,5,
	FALSE
};

rcbutton level0 = {
	RCBUTTON,				/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	" Level ~0",				/* statement */
	5, 6,					/* statement x, y */
	XALT0,					/* shortcut key */
	RADIO(0),				/* radio button group */
	TRUE,					/* default button checked */
	NULL					/* target variable */
};

rcbutton level1 = {
	RCBUTTON,				/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	" Level ~1",				/* statement */
	5, 7,					/* statement x, y */
	XALT1,					/* shortcut key */
	RADIO(0),				/* radio button group */
	FALSE,					/* button checked? */
	NULL					/* target variable */
};

rcbutton level2 = {
	RCBUTTON,				/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	" Level ~2",				/* statement */
	5, 8,					/* statement x, y */
	XALT2,					/* shortcut key */
	RADIO(0),				/* radio button group */
	FALSE,					/* checked? */
	NULL					/* target variable */
};

rcbutton level3 = {
	RCBUTTON,				/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	" Level ~3",				/* statement */
	5, 9,					/* statement x, y */
	XALT3,					/* shortcut key */
	RADIO(0),				/* radio button group */
	FALSE,					/* checked */
	NULL					/* target variable */
};

rcbutton obj = {
	RCBUTTON,				/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	" ~Obj",					/* statement */
	22, 6,					/* statement x, y */
	XALTO,					/* shortcut key */
	RADIO(1),				/* radio button group */
	TRUE,					/* checked? */
	NULL					/* target variable */
};

rcbutton memory = {
	RCBUTTON,				/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	" ~Memory",				/* statement */
	22, 7,					/* statement x, y */
	XALTM,					/* shortcut key */
	RADIO(1),				/* radio button group */
	FALSE,					/* checked? */
	NULL					/* target variable */
};

rcbutton exe = {
	RCBUTTON,				/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	" E~xe",					/* statement */
	22, 8,					/* statement x, y */
	XALTX,					/* shortcut key */
	RADIO(1),				/* radio button group */
	FALSE,					/* checked? */
	NULL					/* target variable */
};

rcbutton syntax = {
	RCBUTTON,				/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	" S~yntax Check Only",	/* statement */
	22, 9,					/* statement x, y */
	XALTY,					/* shortcut key */
	RADIO(1),				/* radio button group */
	FALSE,					/* checked? */
	NULL					/* target variable */
};

rcbutton debug = {
	RCBUTTON,				/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	" ~Debug",				/* statement */
	47, 6,					/* statement x, y */
	XALTD,					/* shortcut key */
	CHECK,					/* checkbox! */
	FALSE,					/* checked? */
	NULL					/* target variable */
};

rcbutton pointer = {
	RCBUTTON,				/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	" ~Pointer Check",		/* statement */
	47, 7,					/* statement x, y */
	XALTP,					/* shortcut key */
	CHECK,					/* checkbox! */
	FALSE,					/* checked? */
	NULL					/* target variable */
};

rcbutton stack = {
	RCBUTTON,				/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	" ~Stack Check",			/* statement */
	47, 8,					/* statement x, y */
	XALTS,					/* shortcut key */
	CHECK,					/* checkbox! */
	FALSE,					/* checked? */
	NULL					/* target variable */
};

rcbutton language = {
	RCBUTTON,				/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	" ~Language Extensions",	/* statement */
	47, 9,					/* statement x, y */
	XALTL,					/* shortcut key */
	CHECK,					/* checkbox! */
	FALSE,					/* checked? */
	NULL					/* target variable */
};

rcbutton optimize = {
	RCBUTTON,				/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	" Optimi~zations",		/* statement */
	47, 10,					/* statement x, y */
	XALTZ,					/* shortcut key */
	CHECK,					/* checkbox! */
	FALSE,					/* checked? */
	NULL					/* target variable */
};

free_form incs = {
	FREE_FORM,  			/* question type */
	0,						/* tile handle -- if your dialog box consists
							   of several virtual screens you can indicate
							   which virtual screen the question is
							   displayed in
							*/
	NULL, NULL, NULL,		/* in - this routine will be executed when the
							   question is initially highlighted.
							   out - this routine will be executed when the
							   question is dehighlighted,
							   action - this routine will be executed each
							   time the question is exited (e.g. when you
							   exit the free_form line editor)
							*/
	"~Include:",			/* statement */
	2, 13,					/* statement x, y */
	XALTI,					/* shortcut key - the actual keypress value
							   which when recognized will navigate directly
							   to this question
							*/
	NULL, "",				/* response & default response - the response
							   contains the current response to the question
							   typically you would assign this a NULL value,
							   if you do assign it a value make sure that it
							   is a pointer to a dynamically allocated memory
							   block.

							   default response - if response is NULL db_run
							   uses a dynamically allocated copy of the
							   default response as the actual response.
							*/
	12, 13, 58,				/* response x, y, and length - indicates where
							   to display the response string and how many
							   characters to devote to the display area
							*/
	NULL,					/* insurance -- typically set to NULL, this
							   member of the structure is used to keep
							   a copy of the string when it is edited, if
							   the user wants to restore the original
							   string we use this copy to recreate it
							*/
	NULL,					/* target -- this char** is updated to the
							   same value as response on exiting the
							   dialog box.  You can use this to have
							   dialog boxes update global (or local)
							   variables in your existing routines.
							*/
	0,						/* cursor position - indicates the default
							   position of the edit cursor on editing
							   the response string
							*/
	NULL,					/* macros - if you want to have some special
							   macros during the line editor process
							   assign them here.
							*/
	TRUE					/* refresh -- tells it to draw the statement
							   and delimiters.  Always set this to TRUE
							   when initializing a structure */
};

free_form def = {
	FREE_FORM,  			/* question type */
	0,						/* tile handle -- if your dialog box consists
							   of several virtual screens you can indicate
							   which virtual screen the question is
							   displayed in
							*/
	NULL, NULL, NULL,		/* in - this routine will be executed when the
							   question is initially highlighted.
							   out - this routine will be executed when the
							   question is dehighlighted,
							   action - this routine will be executed each
							   time the question is exited (e.g. when you
							   exit the free_form line editor)
							*/
	"De~fine:",				/* statement */
	2, 16,					/* statement x, y */
	XALTF,					/* shortcut key - the actual keypress value
							   which when recognized will navigate directly
							   to this question
							*/
	NULL, "",				/* response & default response - the response
							   contains the current response to the question
							   typically you would assign this a NULL value,
							   if you do assign it a value make sure that it
							   is a pointer to a dynamically allocated memory
							   block.

							   default response - if response is NULL db_run
							   uses a dynamically allocated copy of the
							   default response as the actual response.
							*/
	12, 16, 58,				/* response x, y, and length - indicates where
							   to display the response string and how many
							   characters to devote to the display area
							*/
	NULL,					/* insurance -- typically set to NULL, this
							   member of the structure is used to keep
							   a copy of the string when it is edited, if
							   the user wants to restore the original
							   string we use this copy to recreate it
							*/
	NULL,					/* target -- this char** is updated to the
							   same value as response on exiting the
							   dialog box.  You can use this to have
							   dialog boxes update global (or local)
							   variables in your existing routines.
							*/
	0,						/* cursor position - indicates the default
							   position of the edit cursor on editing
							   the response string
							*/
	NULL,					/* macros - if you want to have some special
							   macros during the line editor process
							   assign them here.
							*/
	TRUE					/* refresh -- tells it to draw the statement
							   and delimiters.  Always set this to TRUE
							   when initializing a structure */
};

button buildprog = {

	/************************* same as above *********************/
	BUTTON,					/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	" ~Build Program ",				/* statement */
	4, 20,					/* statement x, y */
	XALTB,					/* shortcut key */

	/*************** these fields are unique to buttons ***********/
	box0,					/* border characters - if you want the
							   button statement surrounded by a box
							   indicate the box type here.  Otherwise
							   set this field to NULL.
							*/
	HEAD_ON,				/* shading - if your button is surrounded
							   by a box you can use a shadowing effect
							   with this field.
							*/
	XENTER,					/* hitting button is = XENTER - when a button
							   is pressed it simply pushes a key value
							   or db opcode onto the queue.  The
							   interpretation of this value can then
							   do things like confirm the dialog box, etc.
							   If you do not want to use this feature of
							   buttons assign this field a value of
							   DO_NOTHING.
							*/
	XENTER,					/* flash key - you can 'press' a button without
							   changing the selected question to the button
							   by pressing this key value.  Note that the
							   mouse routines simply put the shortcut key
							   value in the queue when you press and release
							   on a button and they put this key value into
							   the queue when you quickly click on a button.
							   As such this must be a unique value, otherwise
							   clicking on this button, could actually activate
							   another button.  Note that the value does
							   not have to be a keyboard generatable value it
							   should just be unique to the other shortcut keys.
							*/
	FALSE,					/* continuous - if holding the mouse button down
							   and sitting on a dialog box button should
							   continuously push shortcut key values onto the
							   queue indicate TRUE in this field, otherwise
							   indicate FALSE.  Generally you would indicate
							   TRUE if it made sense for the button to perform
							   some continuous action if you held the mouse
							   cursor on it.  For example, if you had button
							   which 'flipped' through a series of records
							   you might make this field TRUE.
							*/
	20						/* exit value - if the button results in
							   exiting the dialog box you can change the
							   exit value with this field.  You can use
							   this if you want to specifically determine
							   that a user exited by using a certain
							   button.
							*/
};

button compfile = {

	/************************* same as above ***************************/
	BUTTON,					/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	" ~Compile File ",		/* statement */
	23, 20,					/* statement x, y */
	XALTC,					/* shortcut key */
	box1,					/* border characters */
	HEAD_ON,				/* shading */
	XENTER,					/* hitting button is = XESC */
	-100,					/* flash key */
	FALSE,					/* continuous */
	21						/* exit value */
};

button rebuild = {

	/************************* same as above ***************************/
	BUTTON,					/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	" ~Rebuild All ",		/* statement */
	41, 20,					/* statement x, y */
	XALTR,					/* shortcut key */
	box1,					/* border characters */
	HEAD_ON,				/* shading */
	XENTER,					/* hitting button is = XESC */
	-101,					/* flash key */
	FALSE,					/* continuous */
	22						/* exit value */
};

button cancel = {

	/************************* same as above ***************************/
	BUTTON,					/* question type */
	0,						/* tile handle */
	NULL, NULL, NULL,		/* in, out, and action */
	" Cancel ",				/* statement */
	58, 20,					/* statement x, y */
	-102,					/* shortcut key */
	box1,					/* border characters */
	HEAD_ON,				/* shading */
	XESC,					/* hitting button is = XESC */
	XESC,					/* flash key */
	FALSE,					/* continuous */
	ABORTED					/* exit value */
};

void *simple_questions[] = {
	&proglist,
	&currfile,
	&warnlevels,
	&outputoptions,
	&miscellaneous,
	&level0,
	&level1,
	&level2,
	&level3,
	&obj,
	&memory,
	&exe,
	&syntax,
	&debug,
	&pointer,
	&stack,
	&language,
	&optimize,
	&incs,
	&def,
	&buildprog,
	&compfile,
	&rebuild,
	&cancel,
	NULL
};

dialog_box simple_db = {

	MAX_WINDOWS,			/* 	window handle -- set this to MAX_WINDOWS
								if you want db_run to create the window
								for you
							*/
	NULL, NULL,				/* 	post-size and post-move routines -- after
								sizing or moving a dialog box these
								routines will be executed
							*/
	TRUE, TRUE,				/* 	move and size OK -- set these to TRUE if
								it is OK to move or size the dialog box
							*/
	simple_questions,		/* 	questions -- set this to the array of
								questions which comprise the dialog box
							*/
	db_available,			/* 	available questions -- this is an array of 1s
								an 0s where 1 indicates that a user can modify
								the response to the question and 0 indicates
								that it is not allowed.
							*/
	0,						/* 	selected question -- indicates the currently */
	default_db_cmds,		/* 	keyboard commands -- an array of ints which
								assigns each db opcode to a keypress, e.g.
								you might assign XENTER to CONFIRM and XESC
								to ABORT.
							*/
	FALSE,					/* 	If FALSE the dialog box will be automatically
								brought to the top of the window stack when
								activated.  Otherwise, you will be able to
								run the dialog box but other windows may
								obscure it.  Normally set to TRUE for menu
								bars, or some sort of dialog box which
								represents a desktop.  For example you
								could represent the Framework II desktop
								as a background dialog box.
							*/
	&default_db_colors,		/* 	db_colors -- an array of unsigned chars
								containing video attributes to use for
								various parts of a dialog box
							*/
	&default_db_delimiters,	/* 	db delimiters -- an array of chars which
								are used to delimit the response areas
								for various question types
							*/
	NULL,					/* 	insurance -- normally set to NULL, this
								pointer is used internally by db_run.
								When a dialog box is activated a copy
								of the current responses is made and
								pointed to by this field.  If the
								user ABORTS the dialog box we restore
								the original responses using this
								copy.
							*/
	NULL,					/* 	macros -- indicates any special macros for
								this dialog box.
							*/

							/* 	All of these are used to create a
								window to display the dialog box in
								if the above window handle does not
								exist.
							*/
	23, 71,					/* virtual rows and columns */
	1, 1,					/* physical x & y */
	1, 1,					/* virtual x & y */
	23, 71,					/* viewport rows & columns */
	HEAD_ON,				/* shading style */
	NULL,					/* primary dialog box name */
	NULL,					/* secondary dialog box name */
	box1,					/* window border characters */
	NONE,					/* scroll bars style */
	red, lightgray			/* virtual screen attribute */
};

void main()
{
	unsigned char head = 0, tail = 0;
	unsigned int queue[256];

	/* initialize The WINDOW PRO - required */
	wn_init();

	/* initialize The DB PRO message queue - required */
	db_switchqueue(&head, &tail, queue);

	if (v_getmode() == mono) {
		simple_db.colors = &msmono;
		active_attr = lightgray + (black << 4);
		simple_db.fg = lightgray;
		simple_db.bg = black;
	}
	else active_attr = black + (lightgray << 4);

	/* execute the dialog box */
	db_run(&simple_db, 0);

	/* get rid of the dialog box - if memory is tight you can deleted
	   the dialog box window each time. Doing this will slow down
	   execution but allow you to cram in more data.  Note that
	   if you delete a dialog box window you should reset the
	   window handle back to MAX_WINDOWS.  When a window handle
	   is deleted it is returned to the free handles pool.  If the
	   handle were to get reused and this dialog box were rerun
	   it would believe that it had a valid window handle and
	   would not create a new window (of the proper size and location.)
	*/
	wn_delw(simple_db.handle); simple_db.handle = MAX_WINDOWS;

	/* restore the cursor position */
	v_gotoxy(oldx,oldy);

	/* restore the cursor shape */
	v_curshape(oldb, olde);
}
