/* ******************************************************************
 * Function name  : date_1
 *
 * Description    : This function converts the date from a format of
 *                  MM/DD/YYYY to a format of DD-MMM-YYYY.
 *
 * Variables      : d_in - This variable contains the date that is
 *                         passed to the function for reformatting.
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 *******************************/
date_1(d_in, d_out)

char *d_in, *d_out;

{ int int_month;
  char months[37];
  *(d_out)   = *(d_in+3);
  *(d_out+1) = *(d_in+4);
  *(d_out+2) = '-';
  *(d_out+3) = 'X';
  *(d_out+4) = 'X';
  *(d_out+5) = 'X';
  *(d_out+6) = '-';
  *(d_out+7) = *(d_in+6);
  *(d_out+8) = *(d_in+7);
  *(d_out+9) = *(d_in+8);
  *(d_out+10) = *(d_in+9);
  *(d_out+11) = '\0';
  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  int_month = *(d_in+1) - '0';
  if ((*d_in) == '1' ) int_month +=10;
  if ( int_month >= 1 && int_month <= 12 )
    { *(d_out+3) = *(months+((int_month-1)*3));
      *(d_out+4) = *(months+1+((int_month-1)*3));
      *(d_out+5) = *(months+2+((int_month-1)*3));
    }
}

/* ******************************************************************
 * Function name  : date_2
 *
 * Description    : This function converts the date from a format of
 *                  MM/DD/YYYY to a format of YYYYMMDD.
 *
 * Variables      : d_in - This variable contains the date that is
 *                         passed to the function for reformatting.
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 ***************************/
date_2(d_in, d_out)

char *d_in, *d_out;

{ int int_month;
  char months[37];
  *(d_out)   = *(d_in+6);
  *(d_out+1) = *(d_in+7);
  *(d_out+2) = *(d_in+8);
  *(d_out+3) = *(d_in+9);
  *(d_out+4) = *(d_in);
  *(d_out+5) = *(d_in+1);
  *(d_out+6) = *(d_in+3);
  *(d_out+7) = *(d_in+4);
  *(d_out+8) = '\0';
}

/* ******************************************************************
 * Function name  : date_3
 *
 * Description    : This function converts the date from a format of
 *                  MM/DD/YYYY to a format of DDMMMYYYY.
 *
 * Variables      : d_in - This variable contains the date that is
 *                         passed to the function for reformatting.
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 ****************************/
date_3(d_in, d_out)

char *d_in, *d_out;

{ int int_month;
  char months[37];
  *(d_out)   = *(d_in+3);
  *(d_out+1) = *(d_in+4);
  *(d_out+2) = 'X';
  *(d_out+3) = 'X';
  *(d_out+4) = 'X';
  *(d_out+5) = *(d_in+6);
  *(d_out+6) = *(d_in+7);
  *(d_out+7) = *(d_in+8);
  *(d_out+8) = *(d_in+9);
  *(d_out+9) = '\0';
  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  int_month = *(d_in+1) - '0';
  if ((*d_in) == '1' ) int_month +=10;
  if ( int_month >= 1 && int_month <= 12 )
    { *(d_out+2) = *(months+((int_month-1)*3));
      *(d_out+3) = *(months+1+((int_month-1)*3));
      *(d_out+4) = *(months+2+((int_month-1)*3));
    }
}

/* ******************************************************************
 * Function name  : date_4
 *
 * Description    : This function converts the date from a format of
 *                  MM/DD/YYYY to its julian equivalent.
 *
 * Variables      : d_in - The variables contains the date that is
 *                         passed to the function for conversion to
 *                         its julian date.
 *
 *                  julian - This long integer variable contains the
 *                           numeric julian value that is returned to
 *                           the calling function.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The converted date will be returned via a long
 *                 integer "long int long_day". Therefore, the function
 *                 must be defined as a long integer and the variable
 *                 receiving the returned value must also be a long
 *                 integer data type.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 **********************/
long int date_4(d_in)
 char *d_in;
{ int in_year, in_month, in_day;
  int cent, cent_y, month, year, out_day;
  long int long_day, temp_long;
  *(d_in+2) = '\0';
  *(d_in+5) = '\0';
  in_year   = i_convert(d_in+6);
  in_month  = i_convert(d_in);
  in_day    = i_convert(d_in+3);

  if ( in_month > 2 )
    { month = in_month - 3;
      year  = in_year;
    }
  else
    { month = in_month + 9;
      year = in_year - 1;
    }
  temp_long = 146097;
  cent   = year / 100;
  cent_y = year - ( cent * 100 );
  long_day = temp_long * cent / 4;
  long_day = long_day + 1461.0 * cent_y / 4;
  long_day = long_day  + ( 153 * month + 2 ) / 5;
  long_day = long_day + in_day;

  return(long_day);
}


/* ******************************************************************
 * Function name  : date_5
 *
 * Description    : This function receives a date in the format
 *                  MM/DD/YYYy and returns its daily position within
 *                  within the year. For example, February 5th is
 *                  the 36th day of the year.
 *
 * Variables      : d_in - The variables contains the date that is
 *                         passed to the function for conversion to
 *                         its julian date.
 *
 *                  out_day - This long integer variable contains the
 *                           numeric value that is returned to
 *                           the calling function.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The converted date will be returned via an
 *                 integer "int out_day". Therefore, the function
 *                 must be defined as an integer and the variable
 *                 receiving the returned value must also be an
 *                 integer data type.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 **********************/
date_5(d_in)
 char *d_in;
{ int in_year, in_month, in_day;
  int cent, cent_y, month, year, out_day, leap_year;
  long int long_day;
  *(d_in+2) = '\0';
  *(d_in+5) = '\0';
  in_year   = i_convert(d_in+6);
  in_month  = i_convert(d_in);
  in_day    = i_convert(d_in+3);

  long_day = ( 3055.0 * ( in_months + 2 ) / 100 ) -91;
  out_day = long_day;

  if ( in_month > 2 )
    { leap_year = 0;
      if (( in_year % 4 )   == 0 ) leap_year = 1;
      if (( in_year % 100 ) == 0 ) leap_year = 0;
      if (( in_year % 400 ) == 0 ) leap_year = 1;
      out_day = out_day - 2 + leap_year;
    }
  out_day += in_day;
  return(out_day);
}


/* ******************************************************************
 * Function name  : date_6
 *
 * Description    : This function receives a date in the format
 *                  MM/DD/YYYY and returns a 0 if the year is not a
 *                  leap year and a 1 if the year is a leap year.
 *
 * Variables      : d_in - The variables contains the date that is
 *                         passed to the function for conversion to
 *                         its julian date.
 *
 *                  leap-year - This integer variable contains the
 *                              numeric value that is returned to
 *                              the calling function.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The converted date will be returned via an
 *                 integer "int leap_year". Therefore, the function
 *                 must be defined as an integer and the variable
 *                 receiving the returned value must also be an
 *                 integer data type.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 **********************/
date_6(d_in)
 char *d_in;
{ int in_year, in_month, in_day;
  int leap_year;
  *(d_in+2) = '\0';
  *(d_in+5) = '\0';
  in_year   = i_convert(d_in+6);
  in_month  = i_convert(d_in);
  in_day    = i_convert(d_in+3);

  leap_year = 0;
  if (( in_year % 4 )   == 0 ) leap_year = 1;
  if (( in_year % 100 ) == 0 ) leap_year = 0;
  if (( in_year % 400 ) == 0 ) leap_year = 1;
  return(leap_year);
}


/* ******************************************************************
 * Function name  : date_8
 *
 * Description    : This function converts the date from a format of
 *                  MM/DD/YYYY to a format of "Day. Mon. DD, YYYY".
 *
 * Variables      : d_in - This variable contains the date that is
 *                         passed to the function for reformatting.
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"12/05/1986"};
 *                 char out_date[30];
 *                 date_8(ind_date, out_date);
 *
 **************************************
 *            11111                   *
 *  012345678901234567   0123456789   *
 *  Day, MMM. DD, YYYY = MM/DD/YYYY   *
 **************************************/
date_8(d_in, d_out)

char *d_in, *d_out;

{ int int_month, int_day;
  char months[37];
  char days[22];
  *(d_out)   = 'X';
  *(d_out+1) = 'X';
  *(d_out+2) = 'X';
  *(d_out+3) = '.';
  *(d_out+4) = ' ';
  *(d_out+5) = 'X';
  *(d_out+6) = 'X';
  *(d_out+7) = 'X';
  *(d_out+8) = '.';
  *(d_out+9) = ' ';
  *(d_out+10) = *(d_in+3);
  *(d_out+11) = *(d_in+4);
  *(d_out+12) = ',';
  *(d_out+13) = ' ';
  *(d_out+14) = *(d_in+6);
  *(d_out+15) = *(d_in+7);
  *(d_out+16) = *(d_in+8);
  *(d_out+17) = *(d_in+9);
  *(d_out+18) = '\0';
  strcpy(months,"JanFebMarAprMayJunJulAugSepOctNovDec");
  int_month = *(d_in+1) - '0';
  if ((*d_in) == '1' ) int_month +=10;
  if ( int_month >= 1 && int_month <= 12 )
    { *(d_out+5) = *(months+((int_month-1)*3));
      *(d_out+6) = *(months+1+((int_month-1)*3));
      *(d_out+7) = *(months+2+((int_month-1)*3));
    }

  strcpy(days,"SunMonTueWedThuFriSat");
  int_day = date_7(d_in) + 1;
  if ((*d_in) == '1' ) int_day +=10;
  if ( int_day >= 1 && int_day <= 7 )
    { *(d_out) = *(days+((int_day-1)*3));
      *(d_out+1) = *(days+1+((int_day-1)*3));
      *(d_out+2) = *(days+2+((int_day-1)*3));
    }
}


/* ******************************************************************
 * Function name  : date_10
 *
 * Description    : This function calculates the number of days
 *                  between two dates including the days passed
 *                  in the format MM/DD/YYYY.
 *
 * Variables      : s_date - This variable contains the starting date
 *                           to be calculated from.
 *
 *                  e_date - This variable contains the ending date
 *                           to which the days should be counted.
 *
 *
 *                  no_days - This long integer variable will contain
 *                            the number of days that is returned to the
 *                            calling function.
 *
 * Rules         : This function must be passed the pointers associated
 *                 with a character fields. They may be in the format of
 *                 defined character pointers ( * ) or as the name of
 *                 character arrays with no array brackets "[]".
 *
 *                 The dates must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 *                 The calculated value will be returned via a long
 *                 integer "long int no_days". Therefore, the function
 *                 must be defined as a long integer and the variable
 *                 receiving the returned value must also be a long
 *                 integer data type.
 *
 * Calling ex.   : char start_date[] = {"12/05/1986"};
 *                 char end_date[] = {"12/10/1986"};
 *                 long int days;
 *                 long int date_10();
 *                 days = date_10(start_date, end_date);
 *
 *********************
 * 0123456789        *
 * MM/DD/YYYY  input *
 *********************/
long int date_10(s_date, e_date)
char *s_date, *e_date;
{ long int no_days;
  no_days = date_4(e_date) - date_4(s_date) + 1;
  return(no_days);
}


/* ******************************************************************
 * Function name  : date_11
 *
 * Description    : This function calculates the number of days
 *                  between two dates not including the days passed
 *                  in the format MM/DD/YYYY.
 *
 * Variables      : s_date - This variable contains the starting date
 *                           to be calculated from.
 *
 *                  e_date - This variable contains the ending date
 *                           to which the days should be counted.
 *
 *
 *                  no_days - This long integer variable will contain
 *                            the number of days that is returned to the
 *                            calling function.
 *
 * Rules         : This function must be passed the pointers associated
 *                 with a character fields. They may be in the format of
 *                 defined character pointers ( * ) or as the name of
 *                 character arrays with no array brackets "[]".
 *
 *                 The dates must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 *                 The calculated value will be returned via a long
 *                 integer "long int no_days". Therefore, the function
 *                 must be defined as a long integer and the variable
 *                 receiving the returned value must also be a long
 *                 integer data type.
 *
 * Calling ex.   : char start_date[] = {"12/05/1986"};
 *                 char end_date[] = {"12/10/1986"};
 *                 long int days;
 *                 long int date_11();
 *                 days = date_11(start_date, end_date);
 *
 *********************
 * 0123456789        *
 * MM/DD/YYYY  input *
 *********************/
long int date_11(s_date, e_date)
char *s_date, *e_date;
{ long int no_days;
  no_days = date_4(e_date) - date_4(s_date) - 1;
  return(no_days);
}


/* ******************************************************************
 * Function name  : date_12
 *
 * Description    : This function calculates what the date will be in
 *                  a specified number of days, given the stating date
 *                  in the format MM/DD/YYYY and the number of days
 *                  to count.
 *
 * Variables      : d_in - This variable contains the starting date
 *                         to be calculated from.
 *
 *                  d_out - This variable contains the ending date
 *                           after the appropriate number of days
 *                           have been be counted.
 *
 *                  no_days - This integer variable contains
 *                            the number of days that must be
 *                            counted to calculate the ending date.
 *
 * Rules         : This function must be passed the pointers associated
 *                 with a character fields. They may be in the format of
 *                 defined character pointers ( * ) or as the name of
 *                 character arrays with no array brackets "[]".
 *
 *                 The dates must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char start_date[] = {"12/05/1986"};
 *                 char end_date[];
 *                 int days = 10;
 *                 date_12(in_date, out_date, days);
 *
 *********************
 * 0123456789        *
 * MM/DD/YYYY  input *
 *********************/
date_12(d_in,d_out,no_days)
 char *d_in, *d_out;
 int no_days;
{ long int s_julian, e_julian;
  s_julian = date_4(d_in);
  e_julian = s_julian + no_days;
  date_49(e_julian,d_out);
}

/* ******************************************************************
 * Function name  : date_13
 *
 * Description    : This function converts the date from a format of
 *                  DD-MMM-YYYY to a format of MM/DD/YYYY.
 *
 * Variables      : d_in - This variable contains the date that is
 *                         passed to the function for reformatting.
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"12-DEC-1986"};
 *                 char out_date[12];
 *                 date_13(ind_date, out_date);
 *
 ********************************
 *  0123456789   01234567890     *
 *  MM/DD/YYYY = DD-MMM-YYYY     *
 *********************************/
date_13(d_in, d_out)

char *d_in, *d_out;

{ int int_month;
  char months[37];
  *(d_out)   = 'X';
  *(d_out+1) = 'X';
  *(d_out+2) = '/';
  *(d_out+3) = *(d_in);
  *(d_out+4) = *(d_in+1);
  *(d_out+5) = '/';
  *(d_out+6) = *(d_in+7);
  *(d_out+7) = *(d_in+8);
  *(d_out+8) = *(d_in+9);
  *(d_out+9) = *(d_in+10);
  *(d_out+10) = '\0';
  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  for(int_month=0; int_month < 37; int_month+=3 )
   { if ( *(d_in+3) == *(months+int_month) &&
	*(d_in+4) == *(months+int_month+1) &&
	*(d_in+5) == *(months+int_month+2)
      )
	{ int_month = (int_month+3) / 3;
	  *(d_out) = '0';
	  if ( int_month >= 10 )
	    { *(d_out) = '1';
	      int_month -= 10;
	    }
	  *(d_out+1) = int_month + '0';
	  break;
	}
   }
}

/* ******************************************************************
 * Function name  : date_15
 *
 * Description    : This function converts the date from a format of
 *                  DD-MMM-YYYY to a format of DDMMMYYYY.
 *
 * Variables      : d_in - This variable contains the date that is
 *                         passed to the function for reformatting.
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"12-DEC-1986"};
 *                 char out_date[12];
 *                 date_15(ind_date, out_date);
 *
 ****************************
 *  012345678   01234567890 *
 *  DDMMMYYYY = DD-MMM-YYYY *
 ****************************/
date_15(d_in, d_out)

char *d_in, *d_out;

{ int int_month;
  char months[37];
  *(d_out)   = *(d_in);
  *(d_out+1) = *(d_in+1);
  *(d_out+2) = *(d_in+3);
  *(d_out+3) = *(d_in+4);
  *(d_out+4) = *(d_in+5);
  *(d_out+5) = *(d_in+7);
  *(d_out+6) = *(d_in+8);
  *(d_out+7) = *(d_in+9);
  *(d_out+8) = *(d_in+10);
  *(d_out+9) = '\0';
}


/* ******************************************************************
 * Function name  : date_16
 *
 * Description    : This function converts the date from a format of
 *                  DD-MMM-YYYY to its julian equivalent.
 *
 * Variables      : d_in - The variables contains the date that is
 *                         passed to the function for conversion to
 *                         its julian date.
 *
 *                  julian - This long integer variable contains the
 *                           numeric julian value that is returned to
 *                           the calling function.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The converted date will be returned via a long
 *                 integer "long int long_day". Therefore, the function
 *                 must be defined as a long integer and the variable
 *                 receiving the returned value must also be a long
 *                 integer data type.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"05-DEC-1986"};
 *                 long int out julian;
 *                 long int date_16();
 *                 julian = date_16(in_date);
 *
 **********************
 * 0123456789         *
 * DD-MMM-YYYY input  *
 **********************/
long int date_16(d_in)
 char *d_in;
{ int in_year, in_month, in_day;
  int cent, cent_y, month, year, out_day;
  long int long_day, temp_long;
  char months[37];
  *(d_in+2) = '\0';
  in_year   = i_convert(d_in+7);
  in_day    = i_convert(d_in);
  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  for(in_month=0; in_month < 37; in_month+=3 )
   { if ( *(d_in+3) == *(months+in_month) &&
	  *(d_in+4) == *(months+in_month+1) &&
	  *(d_in+5) == *(months+in_month+2)
	)
       { in_month = (in_month+3) / 3;
	 break;
       }
   }

  if ( in_month > 2 )
    { month = in_month - 3;
      year  = in_year;
    }
  else
    { month = in_month + 9;
      year = in_year - 1;
    }
  temp_long = 146097;
  cent   = year / 100;
  cent_y = year - ( cent * 100 );
  long_day = temp_long * cent / 4;
  long_day = long_day + 1461.0 * cent_y / 4;
  long_day = long_day  + ( 153 * month + 2 ) / 5;
  long_day = long_day + in_day;

  return(long_day);
}


/* ******************************************************************
 * Function name  : date_17
 *
 * Description    : This function receives a date in the format
 *                  DD-MMM-YYYY and returns its daily position within
 *                  within the year. For example, February 5th is
 *                  the 36th day of the year.
 *
 * Variables      : d_in - The variables contains the date that is
 *                         passed to the function for conversion to
 *                         its julian date.
 *
 *                  out_day - This long integer variable contains the
 *                           numeric value that is returned to
 *                           the calling function.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The converted date will be returned via an
 *                 integer "int out_day". Therefore, the function
 *                 must be defined as an integer and the variable
 *                 receiving the returned value must also be an
 *                 integer data type.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"05-DEC-1986"};
 *                 int days;
 *                 int date_17();
 *                 days = date_17(in_date);
 *
 **********************
 * 0123456789         *
 * DD-MMM-YYYY input  *
 **********************
date_17(d_in)
 char *d_in;
{ int in_year, in_month, in_day;
  int cent, cent_y, month, year, out_day, leap_year;
  long int long_day;
  char months[37];
  *(d_in+2) = '\0';
  in_year   = i_convert(d_in+7);
  in_day    = i_convert(d_in);
  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  for(in_month=0; in_month < 37; in_month+=3 )
   { if ( *(d_in+3) == *(months+in_month) &&
	  *(d_in+4) == *(months+in_month+1) &&
	  *(d_in+5) == *(months+in_month+2)
	)
       { in_month = (in_month+3) / 3;
	 break;
       }
   }

  long_day = ( 3055.0 * ( in_months + 2 ) / 100 ) -91;
  out_day = long_day;

  if ( in_month > 2 )
    { leap_year = 0;
      if (( in_year % 4 )   == 0 ) leap_year = 1;
      if (( in_year % 100 ) == 0 ) leap_year = 0;
      if (( in_year % 400 ) == 0 ) leap_year = 1;
      out_day = out_day - 2 + leap_year;
    }
  out_day += in_day;
  return(out_day);
}


/* ******************************************************************
 * Function name  : date_18
 *
 * Description    : This function receives a date in the format
 *                  DD-MMM-YYYY and returns a 0 if the year is not a
 *                  leap year and a 1 if the year is a leap year.
 *
 * Variables      : d_in - The variables contains the date that is
 *                         passed to the function for conversion to
 *                         its julian date.
 *
 *                  leap-year - This integer variable contains the
 *                              numeric value that is returned to
 *                              the calling function.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The converted date will be returned via an
 *                 integer "int leap_year". Therefore, the function
 *                 must be defined as an integer and the variable
 *                 receiving the returned value must also be an
 *                 integer data type.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"05-DEC-1986"};
 *                 int leap_year;
 *                 int date_18();
 *                 leap_year = date_18(in_date);
 *
 **********************
 * 0123456789         *
 * DD-MMM-YYYY input  *
 **********************
date_18(d_in)
 char *d_in;
{ int in_year, in_month, in_day;
  int leap_year;
  char months[37];
  *(d_in+2) = '\0';
  *(d_in+5) = '\0';
  in_year   = i_convert(d_in+7);
  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  for(in_month=0; in_month < 37; in_month+=3 )
   { if ( *(d_in+3) == *(months+in_month) &&
	  *(d_in+4) == *(months+in_month+1) &&
	  *(d_in+5) == *(months+in_month+2)
	)
       { in_month = (in_month+3) / 3;
	 break;
       }
   }
  in_day    = i_convert(d_in);

  leap_year = 0;
  if (( in_year % 4 )   == 0 ) leap_year = 1;
  if (( in_year % 100 ) == 0 ) leap_year = 0;
  if (( in_year % 400 ) == 0 ) leap_year = 1;
  return(leap_year);
}


/* ******************************************************************
 * Function name  : date_19
 *
 * Description    : This function receives a date in the format
 *                  DD-MMM-YYYY and returns its daily position within
 *                  within the week. For example, Dec. 5, 1986 fell on
 *                  a friday, therefore this function will return a 5.
 *                  ( 0=Sun, 1=Mon, 2=Tue, 3=Wed, 4=Thu, 5=Fri, 6=Sat )
 *
 * Variables      : d_in - The variables contains the date that is
 *                         passed to the function for conversion to
 *                         its julian date.
 *
 *                  out_day - This integer variable contains the numeric
 *                            value standing for the day of the week
 *                            that is returned to the calling function.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The numeric value will be returned via an
 *                 integer "int out_day". Therefore, the function
 *                 must be defined as an integer and the variable
 *                 receiving the returned value must also be an
 *                 integer data type.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"05-DEC-1096"};
 *                 int day;
 *                 int date_19();
 *                 days = date_19(in_date);
 *
 **********************
 * 0123456789         *
 * DD-MMM-YYYY input  *
 **********************/
date_19(d_in)
 char *d_in;
{ int in_year, in_month, in_day;
  int cent, cent_y, month, year, out_day;
  long int long_day;
  char months[37];
  *(d_in+2) = '\0';
  in_year   = i_convert(d_in+7);
  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  for(in_month=0; in_month < 37; in_month+=3 )
   { if ( *(d_in+3) == *(months+in_month) &&
	  *(d_in+4) == *(months+in_month+1) &&
	  *(d_in+5) == *(months+in_month+2)
	 )
       { in_month = (in_month+3) / 3;
	 break;
       }
   }
  in_day    = i_convert(d_in);

  if ( in_month > 2 )
    { month = in_month - 2;
      year  = in_year;
    }
  else
    { month = in_month + 10;
      year = in_year - 1;
    }
  cent   = year / 100;
  cent_y = year - ( cent * 100 );
  long_day = ( 13 * month - 1 ) / 5;
  long_day = long_day + in_day + cent_y + ( cent_y/4 );
  long_day = long_day  + ( cent/4 ) - cent - cent + 77;
  long_day = long_day - 7 * ( long_day / 7 );
  out_day = long_day;

  return(out_day);
}

/* ******************************************************************
 * Function name  : date_20
 *
 * Description    : This function converts the date from a format of
 *                  DD-MMM-YYYY to a format of Day. Mon. DD, YYYY.
 *
 * Variables      : d_in - This variable contains the date that is
 *                         passed to the function for reformatting.
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"12-DEC-1986"};
 *                 char out_date[30];
 *                 date_20(ind_date, out_date);
 *
 **************************************
 *            11111                   *
 *  012345678901234567   0123456789   *
 *  Day, MMM. DD, YYYY = DD-MMM-YYYY  *
 **************************************/
date_20(d_in, d_out)

char *d_in, *d_out;

{ int int_month, int_day;
  char months[37];
  char days[22];
  *(d_out)   = 'X';
  *(d_out+1) = 'X';
  *(d_out+2) = 'X';
  *(d_out+3) = '.';
  *(d_out+4) = ' ';
  *(d_out+5) = *(d_in+3);
  *(d_out+6) = *(d_in+4);
  *(d_out+7) = *(d_in+5);
  *(d_out+8) = '.';
  *(d_out+9) = ' ';
  *(d_out+10) = *(d_in);
  *(d_out+11) = *(d_in+1);
  *(d_out+12) = ',';
  *(d_out+13) = ' ';
  *(d_out+14) = *(d_in+7);
  *(d_out+15) = *(d_in+8);
  *(d_out+16) = *(d_in+9);
  *(d_out+17) = *(d_in+10);
  *(d_out+18) = '\0';

  strcpy(days,"SunMonTueWedThuFriSat");
  int_day = date_19(d_in) + 1;
  if ((*d_in) == '1' ) int_day +=10;
  if ( int_day >= 1 && int_day <= 7 )
    { *(d_out) = *(days+((int_day-1)*3));
      *(d_out+1) = *(days+1+((int_day-1)*3));
      *(d_out+2) = *(days+2+((int_day-1)*3));
    }
}

/* ******************************************************************
 * Function name  : date_21
 *
 * Description    : This function converts the date from a format of
 *                  DD-MMM-YYYY to a format of Dayyyy Monthhhhh. DD, YYYY.
 *
 * Variables      : d_in - This variable contains the date that is
 *                         passed to the function for reformatting.
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"12-DEC-1986"};
 *                 char out_date[30];
 *                 date_21(ind_date, out_date);
 *
 *************************************************
 *            1         2                        *
 *  01234567890123456789012345678   0123456789   *
 *  Dayyyyyyy, Monthhhhh DD, YYYY = DD-MMM-YYYY  *
 *************************************************/
date_21(d_in, d_out)

char *d_in, *d_out;

{ int int_month, int_day;
  char months[109];
  char days[64];
  *(d_out+9)  = ',';
  *(d_out+10) = ' ';
  *(d_out+20) = ' ';
  *(d_out+21) = *(d_in);
  *(d_out+22) = *(d_in+1);
  *(d_out+23) = ',';
  *(d_out+24) = ' ';
  *(d_out+25) = *(d_in+7);
  *(d_out+26) = *(d_in+8);
  *(d_out+27) = *(d_in+9);
  *(d_out+28) = *(d_in+10);
  *(d_out+29) = '\0';
  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  for(int_month=0; int_month < 37; int_month+=3 )
   { if ( *(d_in+3) == *(months+int_month) &&
	  *(d_in+4) == *(months+int_month+1) &&
	  *(d_in+5) == *(months+int_month+2)
	)
       { int_month = (int_month+3) / 3;
	 break;
       }
   }
  strcpy(months,"January  February March    April    May      Jun      ");
  strcat(months,"July     August   SeptemberOctober  November December ");
  if ((*d_in) == '1' ) int_month +=10;
  if ( int_month >= 1 && int_month <= 12 )
    { *(d_out+11) = *(months+((int_month-1)*9));
      *(d_out+12) = *(months+1+((int_month-1)*9));
      *(d_out+13) = *(months+2+((int_month-1)*9));
      *(d_out+14) = *(months+3+((int_month-1)*9));
      *(d_out+15) = *(months+4+((int_month-1)*9));
      *(d_out+16) = *(months+5+((int_month-1)*9));
      *(d_out+17) = *(months+6+((int_month-1)*9));
      *(d_out+18) = *(months+7+((int_month-1)*9));
      *(d_out+19) = *(months+8+((int_month-1)*9));
    }

  strcpy(days,"Sunday   Monday   Tuesday  wednesdayThursday Friday   ");
  strcat(days,"Saterday ");
  int_day = date_19(d_in) + 1;
  if ( int_day >= 1 && int_day <= 7 )
    { *(d_out) = *(days+((int_day-1)*9));
      *(d_out+1) = *(days+1+((int_day-1)*9));
      *(d_out+2) = *(days+2+((int_day-1)*9));
      *(d_out+3) = *(days+3+((int_day-1)*9));
      *(d_out+4) = *(days+4+((int_day-1)*9));
      *(d_out+5) = *(days+5+((int_day-1)*9));
      *(d_out+6) = *(days+6+((int_day-1)*9));
      *(d_out+7) = *(days+7+((int_day-1)*9));
      *(d_out+8) = *(days+8+((int_day-1)*9));
    }
}

/* ******************************************************************
 * Function name  : date_22
 *
 * Description    : This function calculates the number of days
 *                  between two dates including the days passed
 *                  in the format DD-MMM-YYYY.
 *
 * Variables      : s_date - This variable contains the starting date
 *                           to be calculated from.
 *
 *                  e_date - This variable contains the ending date
 *                           to which the days should be counted.
 *
 *
 *                  no_days - This long integer variable will contain
 *                            the number of days that is returned to the
 *                            calling function.
 *
 * Rules         : This function must be passed the pointers associated
 *                 with a character fields. They may be in the format of
 *                 defined character pointers ( * ) or as the name of
 *                 character arrays with no array brackets "[]".
 *
 *                 The dates must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 *                 The calculated value will be returned via a long
 *                 integer "long int no_days". Therefore, the function
 *                 must be defined as a long integer and the variable
 *                 receiving the returned value must also be a long
 *                 integer data type.
 *
 * Calling ex.   : char start_date[] = {"05-DEC-1986"};
 *                 char end_date[] = {"10-DEC-1986"};
 *                 long int days;
 *                 long int date_22();
 *                 days = date_22(start_date, end_date);
 *
 *********************
 * 0123456789a       *
 * DD-MMM-YYYY input *
 *********************/
long int date_22(s_date, e_date)
char *s_date, *e_date;
{ long int no_days;
  no_days = date_16(e_date) - date_16(s_date) + 1;
  return(no_days);
}


/* ******************************************************************
 * Function name  : date_23
 *
 * Description    : This function calculates the number of days
 *                  between two dates not including the days passed
 *                  in the format DD-MMM-YYYY.
 *
 * Variables      : s_date - This variable contains the starting date
 *                           to be calculated from.
 *
 *                  e_date - This variable contains the ending date
 *                           to which the days should be counted.
 *
 *
 *                  no_days - This long integer variable will contain
 *                            the number of days that is returned to the
 *                            calling function.
 *
 * Rules         : This function must be passed the pointers associated
 *                 with a character fields. They may be in the format of
 *                 defined character pointers ( * ) or as the name of
 *                 character arrays with no array brackets "[]".
 *
 *                 The dates must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 *                 The calculated value will be returned via a long
 *                 integer "long int no_days". Therefore, the function
 *                 must be defined as a long integer and the variable
 *                 receiving the returned value must also be a long
 *                 integer data type.
 *
 * Calling ex.   : char start_date[] = {"05-DEC-1986"};
 *                 char end_date[] = {"10-DEC-1986"};
 *                 long int days;
 *                 long int date_23();
 *                 days = date_23(start_date, end_date);
 *
 *********************
 * 0123456789a       *
 * DD-MMM-YYYY input *
 *********************/
long int date_23(s_date, e_date)
char *s_date, *e_date;
{ long int no_days;
  no_days = date_16(e_date) - date_16(s_date) - 1;
  return(no_days);
}


/* ******************************************************************
 * Function name  : date_24
 *
 * Description    : This function calculates what the date will be in
 *                  a specified number of days, given the stating date
 *                  in the format DD-MMM-YYYY and the number of days
 *                  to count.
 *
 * Variables      : d_in - This variable contains the starting date
 *                         to be calculated from.
 *
 *                  d_out - This variable contains the ending date
 *                           after the appropriate number of days
 *                           have been be counted.
 *
 *                  no_days - This integer variable contains
 *                            the number of days that must be
 *                            counted to calculate the ending date.
 *
 * Rules         : This function must be passed the pointers associated
 *                 with a character fields. They may be in the format of
 *                 defined character pointers ( * ) or as the name of
 *                 character arrays with no array brackets "[]".
 *
 *                 The dates must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char start_date[] = {"05-DEC-1986"};
 *                 char end_date[];
 *                 int days = 10;
 *                 date_24(in_date, out_date, days);
 *
 *********************
 * 0123456789        *
 * MM/DD/YYYY  input *
 *********************/
date_24(d_in,d_out,no_days)
 char *d_in, *d_out;
 int no_days;
{ long int s_julian, e_julian;
  s_julian = date_16(d_in);
  e_julian = s_julian + no_days;
  date_50(e_julian,d_out);
}
/* ******************************************************************
 * Function name  : date_25
 *
 * Description    : This function converts the date from a format of
 *                  YYYYMMDD to a format of DD-MMM-YYYY.
 *
 * Variables      : d_in - This variable contains the date that is
 *                         passed to the function for reformatting.
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"19861205"};
 *                 char out_date[12];
 *                 date_25(ind_date, out_date);
 *
 ***************************
 *  0123456789a   01234567 *
 *  DD-MMM-YYYY = YYYYMMDD *
 ***************************/
date_25(d_in, d_out)

char *d_in, *d_out;

{ int int_month;
  char months[37];
  *(d_out)   = *(d_in+6);
  *(d_out+1) = *(d_in+7);
  *(d_out+2) = '-';
  *(d_out+3) = 'X';
  *(d_out+4) = 'X';
  *(d_out+5) = 'X';
  *(d_out+6) = '-';
  *(d_out+7) = *(d_in);
  *(d_out+8) = *(d_in+1);
  *(d_out+9) = *(d_in+2);
  *(d_out+10) = *(d_in+3);
  *(d_out+11) = '\0';
  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  int_month = *(d_in+5) - '0';
  if ((*d_in+4) == '1' ) int_month +=10;
  if ( int_month >= 1 && int_month <= 12 )
    { *(d_out+3) = *(months+((int_month-1)*3));
      *(d_out+4) = *(months+1+((int_month-1)*3));
      *(d_out+5) = *(months+2+((int_month-1)*3));
    }
}

/* ******************************************************************
 * Function name  : date_26
 *
 * Description    : This function converts the date from a format of
 *                  YYYYMMDD to a format of MM/DD/YYYY.
 *
 * Variables      : d_in - This variable contains the date that is
 *                         passed to the function for reformatting.
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"19861205"};
 *                 char out_date[12];
 *                 date_26(ind_date, out_date);
 *
 ***************************
 *  0123456789   01234567  *
 *  MM/DD/YYYY = YYYYMMDD  *
 ***************************/
date_26(d_in, d_out)

char *d_in, *d_out;

{ int int_month;
  char months[37];
  *(d_out)   = *(d_in+4);
  *(d_out+1) = *(d_in+5);
  *(d_out+2) = '/';
  *(d_out+3) = *(d_in+6);
  *(d_out+4) = *(d_in+7);
  *(d_out+5) = '/';
  *(d_out+6) = *(d_in);
  *(d_out+7) = *(d_in+1);
  *(d_out+8) = *(d_in+2);
  *(d_out+9) = *(d_in+3);
  *(d_out+10) = '\0';
}

/* ******************************************************************
 * Function name  : date_27
 *
 * Description    : This function converts the date from a format of
 *                  YYYYMMDD to a format of DDMMMYYYY.
 *
 * Variables      : d_in - This variable contains the date that is
 *                         passed to the function for reformatting.
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"19861205"};
 *                 char out_date[12];
 *                 date_27(ind_date, out_date);
 *
 ***************************
 *  012345678   01234567   *
 *  DDMMMYYYY = YYYYMMDD   *
 ***************************/
date_27(d_in, d_out)

char *d_in, *d_out;

{ int int_month;
  char months[37];
  *(d_out)   = *(d_in+6);
  *(d_out+1) = *(d_in+7);
  *(d_out+2) = 'X';
  *(d_out+3) = 'X';
  *(d_out+4) = 'X';
  *(d_out+5) = *(d_in);
  *(d_out+6) = *(d_in+1);
  *(d_out+7) = *(d_in+2);
  *(d_out+8) = *(d_in+3);
  *(d_out+9) = '\0';
  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  int_month = *(d_in+5) - '0';
  if ((*d_in+4) == '1' ) int_month +=10;
  if ( int_month >= 1 && int_month <= 12 )
    { *(d_out+2) = *(months+((int_month-1)*3));
      *(d_out+3) = *(months+1+((int_month-1)*3));
      *(d_out+4) = *(months+2+((int_month-1)*3));
    }
}


/* ******************************************************************
 * Function name  : date_28
 *
 * Description    : This function converts the date from a format of
 *                  YYYYMMDD to its julian equivalent.
 *
 * Variables      : d_in - The variables contains the date that is
 *                         passed to the function for conversion to
 *                         its julian date.
 *
 *                  julian - This long integer variable contains the
 *                           numeric julian value that is returned to
 *                           the calling function.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The converted date will be returned via a long
 *                 integer "long int long_day". Therefore, the function
 *                 must be defined as a long integer and the variable
 *                 receiving the returned value must also be a long
 *                 integer data type.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"19861205"};
 *                 long int out julian;
 *                 long int date_128();
 *                 julian = date_28(in_date);
 *
 ********************
 * 01234569         *
 * YYYYMMDD input   *
 ********************/
long int date_28(d_in)
 char *d_in;
{ int in_year, in_month, in_day;
  int cent, cent_y, month, year, out_day;
  long int long_day, temp_long;
  char temp[10];
  strncpy(temp,d_in,4);
   in_year   = i_convert(temp);
  strncpy(temp,d_in+4,2);
   in_month  = i_convert(temp);
  in_day    = i_convert(d_in+6);

  if ( in_month > 2 )
    { month = in_month - 3;
      year  = in_year;
    }
  else
    { month = in_month + 9;
      year = in_year - 1;
    }
  temp_long = 146097;
  cent   = year / 100;
  cent_y = year - ( cent * 100 );
  long_day = temp_long * cent / 4;
  long_day = long_day + 1461.0 * cent_y / 4;
  long_day = long_day  + ( 153 * month + 2 ) / 5;
  long_day = long_day + in_day;

  return(long_day);
}


/* ******************************************************************
 * Function name  : date_29
 *
 * Description    : This function receives a date in the format
 *                  YYYYMMDD and returns its daily position within
 *                  within the year. For example, February 5th is
 *                  the 36th day of the year.
 *
 * Variables      : d_in - The variables contains the date that is
 *                         passed to the function for conversion to
 *                         its julian date.
 *
 *                  out_day - This long integer variable contains the
 *                           numeric value that is returned to
 *                           the calling function.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The converted date will be returned via an
 *                 integer "int out_day". Therefore, the function
 *                 must be defined as an integer and the variable
 *                 receiving the returned value must also be an
 *                 integer data type.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"19861205"};
 *                 int days;
 *                 int date_29();
 *                 days = date_29(in_date);
 *
 ********************
 * 01234567         *
 * YYYYMMDD input   *
 ********************
date_29(d_in)
 char *d_in;
{ int in_year, in_month, in_day;
  int cent, cent_y, month, year, out_day, leap_year;
  long int long_day;
  char temp[10];
  strncpy(temp,d_in,4);
   in_year   = i_convert(temp);
  strncpy(temp,d_in+4,2);
   in_month  = i_convert(temp);
  in_day    = i_convert(d_in+6);
  long_day = ( 3055.0 * ( in_months + 2 ) / 100 ) -91;
  out_day = long_day;

  if ( in_month > 2 )
    { leap_year = 0;
      if (( in_year % 4 )   == 0 ) leap_year = 1;
      if (( in_year % 100 ) == 0 ) leap_year = 0;
      if (( in_year % 400 ) == 0 ) leap_year = 1;
      out_day = out_day - 2 + leap_year;
    }
  out_day += in_day;
  return(out_day);
}


/* ******************************************************************
 * Function name  : date_30
 *
 * Description    : This function receives a date in the format
 *                  YYYYMMDD and returns a 0 if the year is not a
 *                  leap year and a 1 if the year is a leap year.
 *
 * Variables      : d_in - The variables contains the date that is
 *                         passed to the function for conversion to
 *                         its julian date.
 *
 *                  leap-year - This integer variable contains the
 *                              numeric value that is returned to
 *                              the calling function.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The converted date will be returned via an
 *                 integer "int leap_year". Therefore, the function
 *                 must be defined as an integer and the variable
 *                 receiving the returned value must also be an
 *                 integer data type.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"19861205"};
 *                 int leap_year;
 *                 int date_30();
 *                 leap_year = date_30(in_date);
 *
 ********************
 * 01234567         *
 * YYYYMMDD input   *
 ********************/
date_30(d_in)
 char *d_in;
{ int in_year, in_month, in_day;
  int leap_year;
  char temp[10];
  strncpy(temp,d_in,4);
   in_year   = i_convert(temp);
  strncpy(temp,d_in+4,2);
   in_month  = i_convert(temp);
  in_day    = i_convert(d_in+6);

  leap_year = 0;
  if (( in_year % 4 )   == 0 ) leap_year = 1;
  if (( in_year % 100 ) == 0 ) leap_year = 0;
  if (( in_year % 400 ) == 0 ) leap_year = 1;
  return(leap_year);
}


/* ******************************************************************
 * Function name  : date_31
 *
 * Description    : This function receives a date in the format
 *                  YYYYMMDD and returns its daily position within
 *                  within the week. For example, Dec. 5, 1986 fell on
 *                  a friday, therefore this function will return a 5.
 *                  ( 0=Sun, 1=Mon, 2=Tue, 3=Wed, 4=Thu, 5=Fri, 6=Sat )
 *
 * Variables      : d_in - The variables contains the date that is
 *                         passed to the function for conversion to
 *                         its julian date.
 *
 *                  out_day - This integer variable contains the numeric
 *                            value standing for the day of the week
 *                            that is returned to the calling function.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The numeric value will be returned via an
 *                 integer "int out_day". Therefore, the function
 *                 must be defined as an integer and the variable
 *                 receiving the returned value must also be an
 *                 integer data type.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"19861205"};
 *                 int day;
 *                 int date_31();
 *                 days = date_31(in_date);
 *
 **********************
 * 0123456789         *
 * YYYYMMDD input     *
 **********************/
date_31(d_in)
 char *d_in;
{ int in_year, in_month, in_day;
  int cent, cent_y, month, year, out_day;
  long int long_day;
  char temp[10];
  strncpy(temp,d_in,4);
   in_year   = i_convert(temp);
  strncpy(temp,d_in+4,2);
   in_month  = i_convert(temp);
  in_day    = i_convert(d_in+6);
  if ( in_month > 2 )
    { month = in_month - 2;
      year  = in_year;
    }
  else
    { month = in_month + 10;
      year = in_year - 1;
    }
  cent   = year / 100;
  cent_y = year - ( cent * 100 );
  long_day = ( 13 * month - 1 ) / 5;
  long_day = long_day + in_day + cent_y + ( cent_y/4 );
  long_day = long_day  + ( cent/4 ) - cent - cent + 77;
  long_day = long_day - 7 * ( long_day / 7 );
  out_day = long_day;

  return(out_day);
}

/* ******************************************************************
 * Function name  : date_32
 *
 * Description    : This function converts the date from a format of
 *                  YYYYMMDD to a format of Day. Mon. DD, YYYY.
 *
 * Variables      : d_in - This variable contains the date that is
 *                         passed to the function for reformatting.
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"19861205"};
 *                 char out_date[30];
 *                 date_32(ind_date, out_date);
 *

/***********************************
*            1                     *
*  012345678901234567   01234567   *
*  Day, MMM. DD, YYYY = YYYYMMDD   *
************************************/
date_32(d_in, d_out)

char *d_in, *d_out;

{ int int_month, int_day;
  char months[37];
  char days[22];
  *(d_out)   = 'X';
  *(d_out+1) = 'X';
  *(d_out+2) = 'X';
  *(d_out+3) = '.';
  *(d_out+4) = ' ';
  *(d_out+5) = 'X';
  *(d_out+6) = 'X';
  *(d_out+7) = 'X';
  *(d_out+8) = '.';
  *(d_out+9) = ' ';
  *(d_out+10) = *(d_in+6);
  *(d_out+11) = *(d_in+7);
  *(d_out+12) = ',';
  *(d_out+13) = ' ';
  *(d_out+14) = *(d_in);
  *(d_out+15) = *(d_in+1);
  *(d_out+16) = *(d_in+2);
  *(d_out+17) = *(d_in+3);
  *(d_out+18) = '\0';
  strcpy(months,"JanFebMarAprMayJunJulAugSepOctNovDec");
  int_month = *(d_in+5) - '0';
  if ((*d_in+4) == '1' ) int_month +=10;
  if ( int_month >= 1 && int_month <= 12 )
    { *(d_out+5) = *(months+((int_month-1)*3));
      *(d_out+6) = *(months+1+((int_month-1)*3));
      *(d_out+7) = *(months+2+((int_month-1)*3));
    }

  strcpy(days,"SunMonTueWedThuFriSat");
  int_day = date_31(d_in) + 1;
  if ( int_day >= 1 && int_day <= 7 )
    { *(d_out) = *(days+((int_day-1)*3));
      *(d_out+1) = *(days+1+((int_day-1)*3));
      *(d_out+2) = *(days+2+((int_day-1)*3));
    }
}

/* ******************************************************************
 * Function name  : date_33
 *
 * Description    : This function converts the date from a format of
 *                  YYYYMMDD to a format of Dayyyyy Monthhhh. DD, YYYY.
 *
 * Variables      : d_in - This variable contains the date that is
 *                         passed to the function for reformatting.
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"19861205"};
 *                 char out_date[30];
 *                 date_33(ind_date, out_date);
 *
 *************************************************
 *            1         2                        *
 *  01234567890123456789012345678   0123456789   *
 *  Dayyyyyyy, Monthhhhh DD, YYYY = YYYYMMDD     *
 *************************************************/
date_33(d_in, d_out)

char *d_in, *d_out;

{ int int_month, int_day;
  char months[109];
  char days[64];
  *(d_out+9)  = ',';
  *(d_out+10) = ' ';
  *(d_out+20) = ' ';
  *(d_out+21) = *(d_in+6);
  *(d_out+22) = *(d_in+7);
  *(d_out+23) = ',';
  *(d_out+24) = ' ';
  *(d_out+25) = *(d_in);
  *(d_out+26) = *(d_in+1);
  *(d_out+27) = *(d_in+2);
  *(d_out+28) = *(d_in+3);
  *(d_out+29) = '\0';
  strcpy(months,"January  February March    April    May      Jun      ");
  strcat(months,"July     August   SeptemberOctober  November December ");
  int_month = *(d_in+5) - '0';
  if ((*d_in+4) == '1' ) int_month +=10;
  if ( int_month >= 1 && int_month <= 12 )
    { *(d_out+11) = *(months+((int_month-1)*9));
      *(d_out+12) = *(months+1+((int_month-1)*9));
      *(d_out+13) = *(months+2+((int_month-1)*9));
      *(d_out+14) = *(months+3+((int_month-1)*9));
      *(d_out+15) = *(months+4+((int_month-1)*9));
      *(d_out+16) = *(months+5+((int_month-1)*9));
      *(d_out+17) = *(months+6+((int_month-1)*9));
      *(d_out+18) = *(months+7+((int_month-1)*9));
      *(d_out+19) = *(months+8+((int_month-1)*9));
    }

  strcpy(days,"Sunday   Monday   Tuesday  wednesdayThursday Friday   ");
  strcat(days,"Sunday   ");
  int_day = date_31(d_in) + 1;
  if ( int_day >= 1 && int_day <= 7 )
    { *(d_out) = *(days+((int_day-1)*9));
      *(d_out+1) = *(days+1+((int_day-1)*9));
      *(d_out+2) = *(days+2+((int_day-1)*9));
      *(d_out+3) = *(days+3+((int_day-1)*9));
      *(d_out+4) = *(days+4+((int_day-1)*9));
      *(d_out+5) = *(days+5+((int_day-1)*9));
      *(d_out+6) = *(days+6+((int_day-1)*9));
      *(d_out+7) = *(days+7+((int_day-1)*9));
      *(d_out+8) = *(days+8+((int_day-1)*9));
    }
}

/* ******************************************************************
 * Function name  : date_34
 *
 * Description    : This function calculates the number of days
 *                  between two dates including the days passed
 *                  in the format YYYYMMDD.
 *
 * Variables      : s_date - This variable contains the starting date
 *                           to be calculated from.
 *
 *                  e_date - This variable contains the ending date
 *                           to which the days should be counted.
 *
 *
 *                  no_days - This long integer variable will contain
 *                            the number of days that is returned to the
 *                            calling function.
 *
 * Rules         : This function must be passed the pointers associated
 *                 with a character fields. They may be in the format of
 *                 defined character pointers ( * ) or as the name of
 *                 character arrays with no array brackets "[]".
 *
 *                 The dates must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 *                 The calculated value will be returned via a long
 *                 integer "long int no_days". Therefore, the function
 *                 must be defined as a long integer and the variable
 *                 receiving the returned value must also be a long
 *                 integer data type.
 *
 * Calling ex.   : char start_date[] = {"19861205"};
 *                 char end_date[] = {"19861210"};
 *                 long int days;
 *                 long int date_34();
 *                 days = date_34(start_date, end_date);
 *
 *********************
 * 0123456789a       *
 * YYYYMMDD input    *
 *********************/
long int date_34(s_date, e_date)
char *s_date, *e_date;
{ long int no_days;
  no_days = date_28(e_date) - date_28(s_date) + 1;
  return(no_days);
}


/* ******************************************************************
 * Function name  : date_35
 *
 * Description    : This function calculates the number of days
 *                  between two dates not including the days passed
 *                  in the format YYYYMMDD.
 *
 * Variables      : s_date - This variable contains the starting date
 *                           to be calculated from.
 *
 *                  e_date - This variable contains the ending date
 *                           to which the days should be counted.
 *
 *
 *                  no_days - This long integer variable will contain
 *                            the number of days that is returned to the
 *                            calling function.
 *
 * Rules         : This function must be passed the pointers associated
 *                 with a character fields. They may be in the format of
 *                 defined character pointers ( * ) or as the name of
 *                 character arrays with no array brackets "[]".
 *
 *                 The dates must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 *                 The calculated value will be returned via a long
 *                 integer "long int no_days". Therefore, the function
 *                 must be defined as a long integer and the variable
 *                 receiving the returned value must also be a long
 *                 integer data type.
 *
 * Calling ex.   : char start_date[] = {"05-DEC-1986"};
 *                 char end_date[] = {"10-DEC-1986"};
 *                 long int days;
 *                 long int date_35();
 *                 days = date_35(start_date, end_date);
 *
 *********************
 * 0123456789a       *
 * YYYYMMDD input    *
 *********************/
long int date_35(s_date, e_date)
char *s_date, *e_date;
{ long int no_days;
  no_days = date_28(e_date) - date_28(s_date) - 1;
  return(no_days);
}


/* ******************************************************************
 * Function name  : date_36
 *
 * Description    : This function calculates what the date will be in
 *                  a specified number of days, given the stating date
 *                  in the format YYYYMMDD and the number of days
 *                  to count.
 *
 * Variables      : d_in - This variable contains the starting date
 *                         to be calculated from.
 *
 *                  d_out - This variable contains the ending date
 *                           after the appropriate number of days
 *                           have been be counted.
 *
 *                  no_days - This integer variable contains
 *                            the number of days that must be
 *                            counted to calculate the ending date.
 *
 * Rules         : This function must be passed the pointers associated
 *                 with a character fields. They may be in the format of
 *                 defined character pointers ( * ) or as the name of
 *                 character arrays with no array brackets "[]".
 *
 *                 The dates must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char start_date[] = {"19861205"};
 *                 char end_date[];
 *                 int days = 10;
 *                 date_36(in_date, out_date, days);
 *
 *********************
 * 0123456789        *
 * MM/DD/YYYY  input *
 *********************/
date_36(d_in,d_out,no_days)
 char *d_in, *d_out;
 int no_days;
{ long int s_julian, e_julian;
  s_julian = date_28(d_in);
  e_julian = s_julian + no_days;
  date_51(e_julian,d_out);
}

/* ******************************************************************
 * Function name  : date_37
 *
 * Description    : This function converts the date from a format of
 *                  DDMMMYYYY to a format of MM/DD/YYYY.
 *
 * Variables      : d_in - This variable contains the date that is
 *                         passed to the function for reformatting.
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"DDMMMYYYY"};
 *                 char out_date[12];
 *                 date_37(ind_date, out_date);
 *
 *********************************
 *  0123456789   012345678       *
 *  MM/DD/YYYY = DDMMMYYYY       *
 *********************************/
date_37(d_in, d_out)

char *d_in, *d_out;

{ int int_month;
  char months[37];
  *(d_out)   = 'X';
  *(d_out+1) = 'X';
  *(d_out+2) = '/';
  *(d_out+3) = *(d_in);
  *(d_out+4) = *(d_in+1);
  *(d_out+5) = '/';
  *(d_out+6) = *(d_in+5);
  *(d_out+7) = *(d_in+6);
  *(d_out+8) = *(d_in+7);
  *(d_out+9) = *(d_in+8);
  *(d_out+10) = '\0';
  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  for(int_month=0; int_month < 37; int_month+=3 )
   { if ( *(d_in+2) == *(months+int_month) &&
	*(d_in+3) == *(months+int_month+1) &&
	*(d_in+4) == *(months+int_month+2)
      )
	{ int_month = (int_month+3) / 3;
	  *(d_out) = '0';
	  if ( int_month >= 10 )
	    { *(d_out) = '1';
	      int_month -= 10;
	    }
	  *(d_out+1) = int_month + '0';
	  break;
	}
   }
}

/* ******************************************************************
 * Function name  : date_38
 *
 * Description    : This function converts the date from a format of
 *                  DDMMMYYYY to a format of YYYYMMDD.
 *
 * Variables      : d_in - This variable contains the date that is
 *                         passed to the function for reformatting.
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"DDMMMYYYY"};
 *                 char out_date[12];
 *                 date_38(ind_date, out_date);
 *
 *****************************
 *  01234567   012345678     *
 *  YYYYMMDD = DDMMMYYYY     *
 *****************************/
date_38(d_in, d_out)

char *d_in, *d_out;

{ int int_month;
  char months[37];
  *(d_out)   = *(d_in+5);
  *(d_out+1) = *(d_in+6);
  *(d_out+2) = *(d_in+7);
  *(d_out+3) = *(d_in+8);
  *(d_out+4) = 'X';
  *(d_out+5) = 'X';
  *(d_out+6) = *(d_in);
  *(d_out+7) = *(d_in+1);
  *(d_out+8) = '\0';
  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  for(int_month=0; int_month < 37; int_month+=3 )
   { if ( *(d_in+2) == *(months+int_month) &&
	*(d_in+3) == *(months+int_month+1) &&
	*(d_in+4) == *(months+int_month+2)
      )
	{ int_month = (int_month+3) / 3;
	  *(d_out+4) = '0';
	  if ( int_month >= 10 )
	    { *(d_out+4) = '1';
	      int_month -= 10;
	    }
	  *(d_out+5) = int_month + '0';
	  break;
	}
   }
}

/* ******************************************************************
 * Function name  : date_39
 *
 * Description    : This function converts the date from a format of
 *                  DDMMMYYYY to a format of DD-MMM-YY.
 *
 * Variables      : d_in - This variable contains the date that is
 *                         passed to the function for reformatting.
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"DDMMMYYYY"};
 *                 char out_date[12];
 *                 date_39(ind_date, out_date);
 *
 ******************************
 *  0123456789a   012345678   *
 *  DD-MMM-YYYY = DDMMMYYYY   *
 ******************************/
date_39(d_in, d_out)

char *d_in, *d_out;

{ int int_month;
  char months[37];
  *(d_out)   = *(d_in);
  *(d_out+1) = *(d_in+1);
  *(d_out+2) = '-';
  *(d_out+3) = *(d_in+2);
  *(d_out+4) = *(d_in+3);
  *(d_out+5) = *(d_in+4);
  *(d_out+6) = '-';
  *(d_out+7) = *(d_in+5);
  *(d_out+8) = *(d_in+6);
  *(d_out+9) = *(d_in+7);
  *(d_out+10) = *(d_in+8);
  *(d_out+11) = '\0';
}


/* ******************************************************************
 * Function name  : date_40
 *
 * Description    : This function converts the date from a format of
 *                  DDMMMYYYY  to its julian equivilent.
 *
 * Variables      : d_in - The variables contains the date that is
 *                         passed to the function for conversion to
 *                         its julian date.
 *
 *                  julian - This long integer variable contains the
 *                           numeric julian value that is returned to
 *                           the calling function.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The converted date will be returned via a long
 *                 integer "long int long_day". Therefore, the function
 *                 must be defined as a long integer and the variable
 *                 receiving the returned value must also be a long
 *                 integer data type.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"05DEC1986"};
 *                 long int out julian;
 *                 long int date_40();
 *                 julian = date_40(in_date);
 *
 *********************
 * 0123456789        *
 * DDMMMYYYY input   *
 *********************/
long int date_40(d_in)
 char *d_in;
{ int in_year, in_month, in_day;
  int cent, cent_y, month, year, out_day;
  long int long_day, temp_long;
  char months[37];
  char temp[3];
  strncpy(temp,d_in,2);
  in_day    = i_convert(temp);
  in_year   = i_convert(d_in+5);
  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  for(in_month=0; in_month < 37; in_month+=3 )
   { if ( *(d_in+2) == *(months+in_month) &&
	  *(d_in+3) == *(months+in_month+1) &&
	  *(d_in+4) == *(months+in_month+2)
	)
       { in_month = (in_month+3) / 3;
	 break;
       }
   }

  if ( in_month > 2 )
    { month = in_month - 3;
      year  = in_year;
    }
  else
    { month = in_month + 9;
      year = in_year - 1;
    }
  temp_long = 146097;
  cent   = year / 100;
  cent_y = year - ( cent * 100 );
  long_day = temp_long * cent / 4;
  long_day = long_day + 1461.0 * cent_y / 4;
  long_day = long_day  + ( 153 * month + 2 ) / 5;
  long_day = long_day + in_day;

  return(long_day);
}


/* ******************************************************************
 * Function name  : date_41
 *
 * Description    : This function receives a date in the format
 *                  DDMMMYYYY and returns its daily position within
 *                  within the year. For example, February 5th is
 *                  the 36th day of the year.
 *
 * Variables      : d_in - The variables contains the date that is
 *                         passed to the function for conversion to
 *                         its julian date.
 *
 *                  out_day - This long integer variable contains the
 *                           numeric value that is returned to
 *                           the calling function.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The converted date will be returned via an
 *                 integer "int out_day". Therefore, the function
 *                 must be defined as an integer and the variable
 *                 receiving the returned value must also be an
 *                 integer data type.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"05DEC1986"};
 *                 int days;
 *                 int date_41();
 *                 days = date_41(in_date);
 *
 *********************
 * 0123456789        *
 * DDMMMYYYY input   *
 *********************/
date_41(d_in)
 char *d_in;
{ int in_year, in_month, in_day;
  int cent, cent_y, month, year, out_day, leap_year;
  long int long_day;
  char months[37];
  char temp[3];
  strncpy(temp,d_in,2);
  in_day    = i_convert(temp);
  in_year   = i_convert(d_in+5);
  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  for(in_month=0; in_month < 37; in_month+=3 )
   { if ( *(d_in+2) == *(months+in_month) &&
	  *(d_in+3) == *(months+in_month+1) &&
	  *(d_in+4) == *(months+in_month+2)
	)
       { in_month = (in_month+3) / 3;
	 break;
       }
   }

  long_day = ( 3055.0 * ( in_months + 2 ) / 100 ) -91;
  out_day = long_day;

  if ( in_month > 2 )
    { leap_year = 0;
      if (( in_year % 4 )   == 0 ) leap_year = 1;
      if (( in_year % 100 ) == 0 ) leap_year = 0;
      if (( in_year % 400 ) == 0 ) leap_year = 1;
      out_day = out_day - 2 + leap_year;
    }
  out_day += in_day;
  return(out_day);
}


/* ******************************************************************
 * Function name  : date_42
 *
 * Description    : This function receives a date in the format
 *                  DDMMMYYYY and returns a 0 if the year is not a
 *                  leap year and a 1 if the year is a leap year.
 *
 * Variables      : d_in - The variables contains the date that is
 *                         passed to the function for conversion to
 *                         its julian date.
 *
 *                  leap-year - This integer variable contains the
 *                              numeric value that is returned to
 *                              the calling function.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The converted date will be returned via an
 *                 integer "int leap_year". Therefore, the function
 *                 must be defined as an integer and the variable
 *                 receiving the returned value must also be an
 *                 integer data type.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"05DEC1986"};
 *                 int leap_year;
 *                 int date_42();
 *                 leap_year = date_42(in_date);
 *
 *********************
 * 0123456789        *
 * DDMMMYYYY input   *
 *********************
date_42(d_in)
 char *d_in;
{ int in_year, in_month, in_day;
  int leap_year;
  char months[37];
  char temp[3];
  strncpy(temp,d_in,2);
  in_day    = i_convert(temp);
  in_year   = i_convert(d_in+5);
  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  for(in_month=0; in_month < 37; in_month+=3 )
   { if ( *(d_in+2) == *(months+in_month) &&
	  *(d_in+3) == *(months+in_month+1) &&
	  *(d_in+4) == *(months+in_month+2)
	)
       { in_month = (in_month+3) / 3;
	 break;
       }
   }
  in_day    = i_convert(d_in);

  leap_year = 0;
  if (( in_year % 4 )   == 0 ) leap_year = 1;
  if (( in_year % 100 ) == 0 ) leap_year = 0;
  if (( in_year % 400 ) == 0 ) leap_year = 1;
  return(leap_year);
}


/* ******************************************************************
 * Function name  : date_43
 *
 * Description    : This function receives a date in the format
 *                  DDMMMYYYY and returns its daily position within
 *                  within the week. For example, Dec. 5, 1986 fell on
 *                  a friday, therefore this function will return a 5.
 *                  ( 0=Sun, 1=Mon, 2=Tue, 3=Wed, 4=Thu, 5=Fri, 6=Sat )
 *
 * Variables      : d_in - The variables contains the date that is
 *                         passed to the function for conversion to
 *                         its julian date.
 *
 *                  out_day - This integer variable contains the numeric
 *                            value standing for the day of the week
 *                            that is returned to the calling function.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The numeric value will be returned via an
 *                 integer "int out_day". Therefore, the function
 *                 must be defined as an integer and the variable
 *                 receiving the returned value must also be an
 *                 integer data type.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"05DEC1986"};
 *                 int day;
 *                 int date_43();
 *                 days = date_43(in_date);
 *
 **********************
 * 0123456789         *
 * DDMMMYYYY input    *
 **********************/
date_43(d_in)
 char *d_in;
{ int in_year, in_month, in_day;
  int cent, cent_y, month, year, out_day;
  long int long_day;
  char months[37];
  char temp[3];
  strncpy(temp,d_in,2);
  in_day    = i_convert(temp);
  in_year   = i_convert(d_in+5);
  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  for(in_month=0; in_month < 37; in_month+=3 )
   { if ( *(d_in+2) == *(months+in_month) &&
	  *(d_in+3) == *(months+in_month+1) &&
	  *(d_in+4) == *(months+in_month+2)
	 )
       { in_month = (in_month+3) / 3;
	 break;
       }
   }

  if ( in_month > 2 )
    { month = in_month - 2;
      year  = in_year;
    }
  else
    { month = in_month + 10;
      year = in_year - 1;
    }
  cent   = year / 100;
  cent_y = year - ( cent * 100 );
  long_day = ( 13 * month - 1 ) / 5;
  long_day = long_day + in_day + cent_y + ( cent_y/4 );
  long_day = long_day  + ( cent/4 ) - cent - cent + 77;
  long_day = long_day - 7 * ( long_day / 7 );
  out_day = long_day;

  return(out_day);
}


/* ******************************************************************
 * Function name  : date_44
 *
 * Description    : This function converts the date from a format of
 *                  DDMMMYYYY to a format of Day. Mon. DD, YYYY.
 *
 * Variables      : d_in - This variable contains the date that is
 *                         passed to the function for reformatting.
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"DDMMMYYYY"};
 *                 char out_date[30];
 *                 date_44(ind_date, out_date);
 *
 **************************************
 *            1                       *
 *  012345678901234567   012345678    *
 *  Day, MMM. DD, YYYY = DDMMMYYYY    *
 **************************************/
date_44(d_in, d_out)

char *d_in, *d_out;

{ int int_month, int_day;
  char months[37];
  char days[22];
  *(d_out)   = 'X';
  *(d_out+1) = 'X';
  *(d_out+2) = 'X';
  *(d_out+3) = '.';
  *(d_out+4) = ' ';
  *(d_out+5) = *(d_in+2);
  *(d_out+6) = *(d_in+3);
  *(d_out+7) = *(d_in+4);
  *(d_out+8) = '.';
  *(d_out+9) = ' ';
  *(d_out+10) = *(d_in);
  *(d_out+11) = *(d_in+1);
  *(d_out+12) = ',';
  *(d_out+13) = ' ';
  *(d_out+14) = *(d_in+5);
  *(d_out+15) = *(d_in+6);
  *(d_out+16) = *(d_in+7);
  *(d_out+17) = *(d_in+8);
  *(d_out+18) = '\0';

  strcpy(days,"SunMonTueWedThuFriSat");
  int_day = date_43(d_in) + 1;
  if ( int_day >= 1 && int_day <= 7 )
    { *(d_out) = *(days+((int_day-1)*3));
      *(d_out+1) = *(days+1+((int_day-1)*3));
      *(d_out+2) = *(days+2+((int_day-1)*3));
    }
}


/* ******************************************************************
 * Function name  : date_45
 *
 * Description    : This function converts the date from a format of
 *                  DDMMMYYYY to a format of Dayyyyy. Monthhhhh. DD, YYYY.
 *
 * Variables      : d_in - This variable contains the date that is
 *                         passed to the function for reformatting.
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : This function must be passed the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The date must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char in_date[] = {"DDMMMYYYY"};
 *                 char out_date[30];
 *                 date_45(ind_date, out_date);
 *
 *************************************************
 *            1         2                        *
 *  01234567890123456789012345678   012345678    *
 *  Dayyyyyyy, Monthhhhh DD, YYYY = DDMMMYYYY    *
 *************************************************/
date_45(d_in, d_out)

char *d_in, *d_out;

{ int int_month, int_day;
  char months[109];
  char days[64];
  *(d_out+9)  = ',';
  *(d_out+10) = ' ';
  *(d_out+20) = ' ';
  *(d_out+21) = *(d_in);
  *(d_out+22) = *(d_in+1);
  *(d_out+23) = ',';
  *(d_out+24) = ' ';
  *(d_out+25) = *(d_in+5);
  *(d_out+26) = *(d_in+6);
  *(d_out+27) = *(d_in+7);
  *(d_out+28) = *(d_in+8);
  *(d_out+29) = '\0';
  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  for(int_month=0; int_month < 37; int_month+=3 )
   { if ( *(d_in+2) == *(months+int_month) &&
	  *(d_in+3) == *(months+int_month+1) &&
	  *(d_in+4) == *(months+int_month+2)
	)
       { int_month = (int_month+3) / 3;
	 break;
       }
   }
  strcpy(months,"January  February March    April    May      Jun      ");
  strcat(months,"July     August   SeptemberOctober  November December ");
  if ( int_month >= 1 && int_month <= 12 )
    { *(d_out+11) = *(months+((int_month-1)*9));
      *(d_out+12) = *(months+1+((int_month-1)*9));
      *(d_out+13) = *(months+2+((int_month-1)*9));
      *(d_out+14) = *(months+3+((int_month-1)*9));
      *(d_out+15) = *(months+4+((int_month-1)*9));
      *(d_out+16) = *(months+5+((int_month-1)*9));
      *(d_out+17) = *(months+6+((int_month-1)*9));
      *(d_out+18) = *(months+7+((int_month-1)*9));
      *(d_out+19) = *(months+8+((int_month-1)*9));
    }

  strcpy(days,"Sunday   Monday   Tuesday  wednesdayThursday Friday   ");
  strcat(days,"Saterday ");
  int_day = date_43(d_in) + 1;
  if ( int_day >= 1 && int_day <= 7 )
    { *(d_out) = *(days+((int_day-1)*9));
      *(d_out+1) = *(days+1+((int_day-1)*9));
      *(d_out+2) = *(days+2+((int_day-1)*9));
      *(d_out+3) = *(days+3+((int_day-1)*9));
      *(d_out+4) = *(days+4+((int_day-1)*9));
      *(d_out+5) = *(days+5+((int_day-1)*9));
      *(d_out+6) = *(days+6+((int_day-1)*9));
      *(d_out+7) = *(days+7+((int_day-1)*9));
      *(d_out+8) = *(days+8+((int_day-1)*9));
    }
}

/* ******************************************************************
 * Function name  : date_46
 *
 * Description    : This function calculates the number of days
 *                  between two dates including the days passed
 *                  in the format DDMMMYYYY.
 *
 * Variables      : s_date - This variable contains the starting date
 *                           to be calculated from.
 *
 *                  e_date - This variable contains the ending date
 *                           to which the days should be counted.
 *
 *
 *                  no_days - This long integer variable will contain
 *                            the number of days that is returned to the
 *                            calling function.
 *
 * Rules         : This function must be passed the pointers associated
 *                 with a character fields. They may be in the format of
 *                 defined character pointers ( * ) or as the name of
 *                 character arrays with no array brackets "[]".
 *
 *                 The dates must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 *                 The calculated value will be returned via a long
 *                 integer "long int no_days". Therefore, the function
 *                 must be defined as a long integer and the variable
 *                 receiving the returned value must also be a long
 *                 integer data type.
 *
 * Calling ex.   : char start_date[] = {"05DEC1986"};
 *                 char end_date[] = {"10DEC1986"};
 *                 long int days;
 *                 long int date_46();
 *                 days = date_46(start_date, end_date);
 *
 *********************
 * 0123456789a       *
 * DDMMMYYYY input   *
 *********************/
long int date_46(s_date, e_date)
char *s_date, *e_date;
{ long int no_days;
  no_days = date_40(e_date) - date_40(s_date) + 1;
  return(no_days);
}


/* ******************************************************************
 * Function name  : date_47
 *
 * Description    : This function calculates the number of days
 *                  between two dates not including the days passed
 *                  in the format DDMMMYYYY.
 *
 * Variables      : s_date - This variable contains the starting date
 *                           to be calculated from.
 *
 *                  e_date - This variable contains the ending date
 *                           to which the days should be counted.
 *
 *
 *                  no_days - This long integer variable will contain
 *                            the number of days that is returned to the
 *                            calling function.
 *
 * Rules         : This function must be passed the pointers associated
 *                 with a character fields. They may be in the format of
 *                 defined character pointers ( * ) or as the name of
 *                 character arrays with no array brackets "[]".
 *
 *                 The dates must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 *                 The calculated value will be returned via a long
 *                 integer "long int no_days". Therefore, the function
 *                 must be defined as a long integer and the variable
 *                 receiving the returned value must also be a long
 *                 integer data type.
 *
 * Calling ex.   : char start_date[] = {"05DEC1986"};
 *                 char end_date[] = {"10DEC1986"};
 *                 long int days;
 *                 long int date_47();
 *                 days = date_47(start_date, end_date);
 *
 *********************
 * 0123456789a       *
 * DDMMMYYYY input   *
 *********************/
long int date_47(s_date, e_date)
char *s_date, *e_date;
{ long int no_days;
  no_days = date_40(e_date) - date_40(s_date) - 1;
  return(no_days);
}

/* ******************************************************************
 * Function name  : date_48
 *
 * Description    : This function calculates what the date will be in
 *                  a specified number of days, given the stating date
 *                  in the format YYYYMMDD and the number of days
 *                  to count.
 *
 * Variables      : d_in - This variable contains the starting date
 *                         to be calculated from.
 *
 *                  d_out - This variable contains the ending date
 *                           after the appropriate number of days
 *                           have been be counted.
 *
 *                  no_days - This integer variable contains
 *                            the number of days that must be
 *                            counted to calculate the ending date.
 *
 * Rules         : This function must be passed the pointers associated
 *                 with a character fields. They may be in the format of
 *                 defined character pointers ( * ) or as the name of
 *                 character arrays with no array brackets "[]".
 *
 *                 The dates must be passed in the correct format or
 *                 unexpected results may be returned.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : char start_date[] = {"05DEC1986"};
 *                 char end_date[];
 *                 int days = 10;
 *                 date_48(in_date, out_date, days);
 *
 *********************
 * 0123456789        *
 * MM/DD/YYYY  input *
 *********************/
date_48(d_in,d_out,no_days)
 char *d_in, *d_out;
 int no_days;
{ long int s_julian, e_julian;
  s_julian = date_40(d_in);
  e_julian = s_julian + no_days;
  date_52(e_julian,d_out);
}

/* ******************************************************************
 * Function name  : date_49
 *
 * Description    : This function converts the date from a Julian
 *                  to a format of MM/DD/YYYY.
 *
 * Variables      : julian - This long integer contains the julian
 *                           value that is to be transformed to a
 *                           the value placed in "d_out".
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : The second parameter must be the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The first parameter must be a long integer containing
 *                 the julian date value to be analyzed.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : long int in_julian
 *                 char out_date[12];
 *                 date_49(in_julian, out_date);
 *
 **********************
 * 0123456789         *
 * MM/DD/YYYY output  *
 **********************/
date_49(julian,d_out)
 long int julian;
 char *d_out;
{ long int out_year, out_month, out_day;
  long int long_day, temp_long, temp_julian;
  int year, month, day;
  char temp_char[5];
  *(d_out+2) = '/';
  *(d_out+5) = '/';
  *(d_out+10) = '\0';

  temp_long = 146097;
  temp_julian = julian;
  out_year = (4 * julian - 1 ) / temp_long;
  temp_julian = 4 * temp_julian - 1 - temp_long * out_year;
  out_day = temp_julian / 4;
  temp_julian = ( 4 * out_day + 3 ) / 1461;
  out_day = 4 * out_day + 3 - 1461 * temp_julian;
  out_day = ( out_day + 4) / 4;
  out_month = ( 5 * out_day - 3 ) / 153;
  out_day = 5 * out_day - 3 - 153 * out_month;
  out_day = ( out_day + 5 ) / 5;
  out_year = 100 * out_year + temp_julian;


  if ( out_month < 10 )
    { out_month = out_month + 3;
    }
  else
    { out_month = out_month - 9;
      out_year = out_year + 1;
    }

  year =  out_year;
  month = out_month;
  day = out_day;

  i_to_a(year,temp_char);
      *(d_out + 6) = *(temp_char);
      *(d_out + 7) = *(temp_char+1);
      *(d_out + 8) = *(temp_char+2);
      *(d_out + 9) = *(temp_char+3);

  i_to_a(month,temp_char);
  if ( out_month < 10 )
    { *(d_out)     = '0';
      *(d_out + 1) = *(temp_char);
    }
  else
    { *(d_out)     = *(temp_char);
      *(d_out + 1) = *(temp_char+1);
    }

  i_to_a(day,temp_char);
  if ( out_day < 10 )
    { *(d_out + 3) = '0';
      *(d_out + 4) = *(temp_char);
    }
  else
    { *(d_out + 3) = *(temp_char);
      *(d_out + 4) = *(temp_char+1);
    }
}

/* ******************************************************************
 * Function name  : date_50
 *
 * Description    : This function converts the date from a Julian
 *                  to a format of DD-MMM-YYYY.
 *
 * Variables      : julian - This long integer contains the julian
 *                           value that is to be transformed to a
 *                           the value placed in "d_out".
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : The second parameter must be the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The first parameter must be a long integer containing
 *                 the julian date value to be analyzed.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : long int in_julian
 *                 char out_date[12];
 *                 date_50(in_julian, out_date);
 *
 ************************
 * 0123456789a          *
 * DD-MMM-YYYY  output  *
 ************************/
date_50(julian,d_out)
 long int julian;
 char *d_out;
{ long int out_year, out_month, out_day;
  long int long_day, temp_long, temp_julian;
  int year, month, day;
  char temp_char[5];
  char months[37];
  *(d_out+2) = '-';
  *(d_out+6) = '-';
  *(d_out+11) = '\0';

  temp_long = 146097;
  temp_julian = julian;
  out_year = (4 * julian - 1 ) / temp_long;
  temp_julian = 4 * temp_julian - 1 - temp_long * out_year;
  out_day = temp_julian / 4;
  temp_julian = ( 4 * out_day + 3 ) / 1461;
  out_day = 4 * out_day + 3 - 1461 * temp_julian;
  out_day = ( out_day + 4) / 4;
  out_month = ( 5 * out_day - 3 ) / 153;
  out_day = 5 * out_day - 3 - 153 * out_month;
  out_day = ( out_day + 5 ) / 5;
  out_year = 100 * out_year + temp_julian;


  if ( out_month < 10 )
    { out_month = out_month + 3;
    }
  else
    { out_month = out_month - 9;
      out_year = out_year + 1;
    }

  year =  out_year;
  month = out_month;
  day = out_day;

  i_to_a(year,temp_char);
      *(d_out + 7) = *(temp_char);
      *(d_out + 8) = *(temp_char+1);
      *(d_out + 9) = *(temp_char+2);
      *(d_out + 10) = *(temp_char+3);

  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  if ( month >= 1 && month <= 12 )
    { *(d_out+3) = *(months+((month-1)*3));
      *(d_out+4) = *(months+1+((month-1)*3));
      *(d_out+5) = *(months+2+((month-1)*3));
    }

  i_to_a(day,temp_char);
  if ( out_day < 10 )
    { *(d_out) = '0';
      *(d_out + 1) = *(temp_char);
    }
  else
    { *(d_out) = *(temp_char);
      *(d_out + 1) = *(temp_char+1);
    }

}

/* ******************************************************************
 * Function name  : date_51
 *
 * Description    : This function converts the date from a Julian
 *                  to a format of YYYYMMDD.
 *
 * Variables      : julian - This long integer contains the julian
 *                           value that is to be transformed to a
 *                           the value placed in "d_out".
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : The second parameter must be the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The first parameter must be a long integer containing
 *                 the julian date value to be analyzed.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : long int in_julian
 *                 char out_date[12];
 *                 date_51(in_julian, out_date);
 *
 **********************
 * 01234567           *
 * YYYYMMDD output    *
 **********************/
date_51(julian,d_out)
 long int julian;
 char *d_out;
{ long int out_year, out_month, out_day;
  long int long_day, temp_long, temp_julian;
  int year, month, day;
  char temp_char[5];
  *(d_out+8) = '\0';

  temp_long = 146097;
  temp_julian = julian;
  out_year = (4 * julian - 1 ) / temp_long;
  temp_julian = 4 * temp_julian - 1 - temp_long * out_year;
  out_day = temp_julian / 4;
  temp_julian = ( 4 * out_day + 3 ) / 1461;
  out_day = 4 * out_day + 3 - 1461 * temp_julian;
  out_day = ( out_day + 4) / 4;
  out_month = ( 5 * out_day - 3 ) / 153;
  out_day = 5 * out_day - 3 - 153 * out_month;
  out_day = ( out_day + 5 ) / 5;
  out_year = 100 * out_year + temp_julian;


  if ( out_month < 10 )
    { out_month = out_month + 3;
    }
  else
    { out_month = out_month - 9;
      out_year = out_year + 1;
    }

  year =  out_year;
  month = out_month;
  day = out_day;

  i_to_a(year,temp_char);
      *(d_out) = *(temp_char);
      *(d_out + 1) = *(temp_char+1);
      *(d_out + 2) = *(temp_char+2);
      *(d_out + 3) = *(temp_char+3);

  i_to_a(month,temp_char);
  if ( out_month < 10 )
    { *(d_out + 4) = '0';
      *(d_out + 5) = *(temp_char);
    }
  else
    { *(d_out + 4) = *(temp_char);
      *(d_out + 5) = *(temp_char+1);
    }

  i_to_a(day,temp_char);
  if ( out_day < 10 )
    { *(d_out + 6) = '0';
      *(d_out + 7) = *(temp_char);
    }
  else
    { *(d_out + 6) = *(temp_char);
      *(d_out + 7) = *(temp_char+1);
    }
}

/* ******************************************************************
 * Function name  : date_52
 *
 * Description    : This function converts the date from a Julian
 *                  to a format of DDMMMYYYY.
 *
 * Variables      : julian - This long integer contains the julian
 *                           value that is to be transformed to a
 *                           the value placed in "d_out".
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : The second parameter must be the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The first parameter must be a long integer containing
 *                 the julian date value to be analyzed.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : long int in_julian
 *                 char out_date[12];
 *                 date_52(in_julian, out_date);
 *
 ***********************
 * 012345678           *
 * DDMMMYYYY output    *
 ***********************/
date_52(julian,d_out)
 long int julian;
 char *d_out;
{ long int out_year, out_month, out_day;
  long int long_day, temp_long, temp_julian;
  int year, month, day;
  char temp_char[5];
  char months[37];
  *(d_out+9) = '\0';

  temp_long = 146097;
  temp_julian = julian;
  out_year = (4 * julian - 1 ) / temp_long;
  temp_julian = 4 * temp_julian - 1 - temp_long * out_year;
  out_day = temp_julian / 4;
  temp_julian = ( 4 * out_day + 3 ) / 1461;
  out_day = 4 * out_day + 3 - 1461 * temp_julian;
  out_day = ( out_day + 4) / 4;
  out_month = ( 5 * out_day - 3 ) / 153;
  out_day = 5 * out_day - 3 - 153 * out_month;
  out_day = ( out_day + 5 ) / 5;
  out_year = 100 * out_year + temp_julian;


  if ( out_month < 10 )
    { out_month = out_month + 3;
    }
  else
    { out_month = out_month - 9;
      out_year = out_year + 1;
    }

  year =  out_year;
  month = out_month;
  day = out_day;

  i_to_a(year,temp_char);
      *(d_out + 5) = *(temp_char);
      *(d_out + 6) = *(temp_char+1);
      *(d_out + 7) = *(temp_char+2);
      *(d_out + 8) = *(temp_char+3);

  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  if ( month >= 1 && month <= 12 )
    { *(d_out+2) = *(months+((month-1)*3));
      *(d_out+3) = *(months+1+((month-1)*3));
      *(d_out+4) = *(months+2+((month-1)*3));
    }

  i_to_a(day,temp_char);
  if ( out_day < 10 )
    { *(d_out)     = '0';
      *(d_out + 1) = *(temp_char);
    }
  else
    { *(d_out)     = *(temp_char);
      *(d_out + 1) = *(temp_char+1);
    }
}

/* ******************************************************************
 * Function name  : date_53
 *
 * Description    : This function receives a date in a julian format
 *                  and returns its daily position within
 *                  within the year. For example, February 5th is
 *                  the 36th day of the year.
 *
 * Variables      : julian - This long integer contains the julian
 *                           value that is to be transformed to a
 *                           the value placed in "d_out".
 *
 *                  out_day - This long integer variable contains the
 *                           numeric value that is returned to
 *                           the calling function.
 *
 * Rules         : The julian value which is passed to the function
 *                 must be defined as a long integer "long int".
 *
 *                 The converted date will be returned via an
 *                 integer "int out_day". Therefore, the function
 *                 must be defined as an integer and the variable
 *                 receiving the returned value must also be an
 *                 integer data type.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   :  long int julian = 725651;
 *                 int days;
 *                 int date_41();
 *                 days = date_53(julian);
 *
 ***********************
 * julian input        *
 ***********************
date_53(julian)
 long int julian;
{ long int out_year, out_month, out_day;
  long int long_day, temp_long, temp_julian;
  int year, month, day, leap_year, no_days;
  char temp_char[5];
  char months[37];

  temp_long = 146097;
  temp_julian = julian;
  out_year = (4 * julian - 1 ) / temp_long;
  temp_julian = 4 * temp_julian - 1 - temp_long * out_year;
  out_day = temp_julian / 4;
  temp_julian = ( 4 * out_day + 3 ) / 1461;
  out_day = 4 * out_day + 3 - 1461 * temp_julian;
  out_day = ( out_day + 4) / 4;
  out_month = ( 5 * out_day - 3 ) / 153;
  out_day = 5 * out_day - 3 - 153 * out_month;
  out_day = ( out_day + 5 ) / 5;
  out_year = 100 * out_year + temp_julian;


  if ( out_month < 10 )
    { out_month = out_month + 3;
    }
  else
    { out_month = out_month - 9;
      out_year = out_year + 1;
    }

  year =  out_year;
  month = out_month;
  day = out_day;

  long_day = ( 3055.0 * ( month + 2 ) / 100 ) -91;
  no_days = long_day;

  if ( month > 2 )
    { leap_year = 0;
      if (( year % 4 )   == 0 ) leap_year = 1;
      if (( year % 100 ) == 0 ) leap_year = 0;
      if (( year % 400 ) == 0 ) leap_year = 1;
      no_days = no_days - 2 + leap_year;
    }
  no_days += day;
  return(no_days);
}

/* ******************************************************************
 * Function name  : date_54
 *
 * Description    : This function receives a date in julian format
 *                  and returns a 0 if the year is not a
 *                  leap year and a 1 if the year is a leap year.
 *
 * Variables      : julian - This long integer contains the julian
 *                           value that is to be transformed to a
 *                           the value placed in "d_out".
 *
 *                  leap-year - This integer variable contains the
 *                              numeric value that is returned to
 *                              the calling function.
 *
 * Rules         : The julian value which is passed to the function
 *                 must be defined as a long integer "long int".
 *
 *                 The leap year indicator vill be returned via an
 *                 integer "int out_day". Therefore, the function
 *                 must be defined as an integer and the variable
 *                 receiving the returned value must also be an
 *                 integer data type.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   :  long int julian = 725651;
 *                 int leapyear;
 *                 int date_54();
 *                 leapyear = date_54(julian);
 *
 ***********************
 * 012345678           *
 * julian input        *
 ***********************/
date_54(julian)
 long int julian;
{ long int out_year, out_month, out_day;
  long int long_day, temp_long, temp_julian;
  int year, month, day, leap_year;
  char temp_char[5];
  char months[37];

  temp_long = 146097;
  temp_julian = julian;
  out_year = (4 * julian - 1 ) / temp_long;
  temp_julian = 4 * temp_julian - 1 - temp_long * out_year;
  out_day = temp_julian / 4;
  temp_julian = ( 4 * out_day + 3 ) / 1461;
  out_day = 4 * out_day + 3 - 1461 * temp_julian;
  out_day = ( out_day + 4) / 4;
  out_month = ( 5 * out_day - 3 ) / 153;
  out_day = 5 * out_day - 3 - 153 * out_month;
  out_day = ( out_day + 5 ) / 5;
  out_year = 100 * out_year + temp_julian;


  if ( out_month < 10 )
    { out_month = out_month + 3;
    }
  else
    { out_month = out_month - 9;
      out_year = out_year + 1;
    }

  year =  out_year;

  leap_year = 0;
  if (( year % 4 )   == 0 ) leap_year = 1;
  if (( year % 100 ) == 0 ) leap_year = 0;
  if (( year % 400 ) == 0 ) leap_year = 1;
  return(leap_year);
}

/* ******************************************************************
 * Function name  : date_55
 *
 * Description    : This function receives a date in julian format
 *                  and returns its daily position within
 *                  within the week. For example, Dec. 5, 1986 fell on
 *                  a friday, therefore this function will return a 5.
 *                  ( 0=Sun, 1=Mon, 2=Tue, 3=Wed, 4=Thu, 5=Fri, 6=Sat )
 *
 * Variables      : julian - This long integer containn the julian
 *                           value that is to be transformed to a
 *                           the value placed in "d_out".
 *
 *                  out_day - This integer variable contains the numeric
 *                            value standing for the day of the week
 *                            that is returned to the calling function.
 *
 * Rules         : The julian value which is passed to the function
 *                 must be defined as a long integer "long int".
 *
 *                 The leap year indicator vill be returned via an
 *                 integer "int out_day". Therefore, the function
 *                 must be defined as an integer and the variable
 *                 receiving the returned value must also be an
 *                 integer data type.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   :  long int julian = 725651;
 *                 int day;
 *                 int date_55();
 *                 day = date_55(julian);
 *
 ***********************
 * 012345678           *
 * julian input        *
 ***********************/
date_55(julian)
 long int julian;
{ long int out_year, out_month, out_day;
  long int long_day, temp_long, temp_julian;
  int year, month, day, the_day, cent, cent_y;
  char temp_char[5];
  char months[37];

  temp_long = 146097;
  temp_julian = julian;
  out_year = (4 * julian - 1 ) / temp_long;
  temp_julian = 4 * temp_julian - 1 - temp_long * out_year;
  out_day = temp_julian / 4;
  temp_julian = ( 4 * out_day + 3 ) / 1461;
  out_day = 4 * out_day + 3 - 1461 * temp_julian;
  out_day = ( out_day + 4) / 4;
  out_month = ( 5 * out_day - 3 ) / 153;
  out_day = 5 * out_day - 3 - 153 * out_month;
  out_day = ( out_day + 5 ) / 5;
  out_year = 100 * out_year + temp_julian;

  year =  out_year;
  month = out_month;
  day = out_day;

  if ( month < 10 )
    { month = month + 3;
    }
  else
    { month = month - 9;
      year = year + 1;
    }


  if ( month > 2 )
    { month = month - 2;
      year  = year;
    }
  else
    { month = month + 10;
      year = year - 1;
    }
  cent   = year / 100;
  cent_y = year - ( cent * 100 );
  long_day = ( 13 * month - 1 ) / 5;
  long_day = long_day + day + cent_y + ( cent_y/4 );
  long_day = long_day  + ( cent/4 ) - cent - cent + 77;
  long_day = long_day - 7 * ( long_day / 7 );
  the_day = long_day;


  return(the_day);
}

/* ******************************************************************
 * Function name  : date_56
 *
 * Description    : This function converts the date from a Julian
 *                  to a format of Day. Mon. DD, YYYY.
 *
 * Variables      : julian - This long integer contains the julian
 *                           value that is to be transformed to a
 *                           the value placed in "d_out".
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : The second parameter must be the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The first parameter must be a long integer containing
 *                 the julian date value to be analyzed.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *
 * Calling ex.   : long int in_julian
 *                 char out_date[30];
 *                 date_56(in_julian, out_date);
 *
 *********************************
 *            1                  *
 *  012345678901234567           *
 *  Day, MMM. DD, YYYY output    *
 *********************************/
date_56(julian,d_out)
 long int julian;
 char *d_out;
{ long int out_year, out_month, out_day;
  long int long_day, temp_long, temp_julian;
  int year, month, day, temp_day;
  char temp_char[5];
  char months[37];
  char days[21];

  temp_long = 146097;
  temp_julian = julian;
  out_year = (4 * julian - 1 ) / temp_long;
  temp_julian = 4 * temp_julian - 1 - temp_long * out_year;
  out_day = temp_julian / 4;
  temp_julian = ( 4 * out_day + 3 ) / 1461;
  out_day = 4 * out_day + 3 - 1461 * temp_julian;
  out_day = ( out_day + 4) / 4;
  out_month = ( 5 * out_day - 3 ) / 153;
  out_day = 5 * out_day - 3 - 153 * out_month;
  out_day = ( out_day + 5 ) / 5;
  out_year = 100 * out_year + temp_julian;


  if ( out_month < 10 )
    { out_month = out_month + 3;
    }
  else
    { out_month = out_month - 9;
      out_year = out_year + 1;
    }

  year =  out_year;
  month = out_month;
  day = out_day;

  *(d_out+3) = ',';
  *(d_out+4) = ' ';
  *(d_out+8) = '.';
  *(d_out+9) = ' ';
  *(d_out+12) = ',';
  *(d_out+13) = ' ';
  *(d_out+18) = '\0';

  i_to_a(year,temp_char);
      *(d_out + 14) = *(temp_char);
      *(d_out + 15) = *(temp_char+1);
      *(d_out + 16) = *(temp_char+2);
      *(d_out + 17) = *(temp_char+3);

  strcpy(months,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
  if ( month >= 1 && month <= 12 )
    { *(d_out+5) = *(months+((month-1)*3));
      *(d_out+6) = *(months+1+((month-1)*3));
      *(d_out+7) = *(months+2+((month-1)*3));
    }

  i_to_a(day,temp_char);
  if ( out_day < 10 )
    { *(d_out + 10) = '0';
      *(d_out + 11) = *(temp_char);
    }
  else
    { *(d_out + 10) = *(temp_char);
      *(d_out + 11) = *(temp_char+1);
    }
  strcpy(days,"SunMonTueWedThuFriSat");
  temp_day = date_55(julian) + 1;
  if ( temp_day >= 1 && temp_day <= 7 )
    { *(d_out) = *(days+((temp_day-1)*3));
      *(d_out+1) = *(days+1+((temp_day-1)*3));
      *(d_out+2) = *(days+2+((temp_day-1)*3));
    }
}

/* ******************************************************************
 * Function name  : date_57
 *
 * Description    : This function converts the date from a Julian
 *                  to a format of Dayyyyyy Monthhhhh. DD, YYYY.
 *
 * Variables      : julian - This long integer contains the julian
 *                           value that is to be transformed to a
 *                           the value placed in "d_out".
 *
 *                  d_out - This variable contains the reformatted
 *                          date field that is passed back to the
 *                          calling module.
 *
 * Rules         : The second parameter must be the pointer associated
 *                 with a character field. This may be in the format of
 *                 defined character pointer ( * ) or as the name of a
 *                 character array with no array brackets "[]".
 *
 *                 The first parameter must be a long integer containing
 *                 the julian date value to be analyzed.
 *
 *                 The reformatted date will be returned be way of the
 *                 second parameter, therefore, no actual return code
 *                 is used.
 *
 *                 The field into which the reformatted date if returned,
 *                 must be large enough to hold the output character
 *                 string.
 *
 *                 On this and all other date functions, all four
 *                 digits of the year field are required. For example,
 *                 1986 is valid and 86 in not valid.
 *******************************************/
date_57(julian,d_out)
 long int julian;
 char *d_out;
{ long int out_year, out_month, out_day;
  long int long_day, temp_long, temp_julian;
  int year, month, day, temp_day;
  char temp_char[5];
  char months[109];
  char days[64];

  temp_long = 146097;
  temp_julian = julian;
  out_year = (4 * julian - 1 ) / temp_long;
  temp_julian = 4 * temp_julian - 1 - temp_long * out_year;
  out_day = temp_julian / 4;
  temp_julian = ( 4 * out_day + 3 ) / 1461;
  out_day = 4 * out_day + 3 - 1461 * temp_julian;
  out_day = ( out_day + 4) / 4;
  out_month = ( 5 * out_day - 3 ) / 153;
  out_day = 5 * out_day - 3 - 153 * out_month;
  out_day = ( out_day + 5 ) / 5;
  out_year = 100 * out_year + temp_julian;


  if ( out_month < 10 )
    { out_month = out_month + 3;
    }
  else
    { out_month = out_month - 9;
      out_year = out_year + 1;
    }

  year =  out_year;
  month = out_month;
  day = out_day;

  *(d_out+9) = ',';
  *(d_out+10) = ' ';
  *(d_out+20) = ' ';
  *(d_out+23) = ',';
  *(d_out+24) = ' ';
  *(d_out+29) = '\0';

  i_to_a(year,temp_char);
      *(d_out + 25) = *(temp_char);
      *(d_out + 26) = *(temp_char+1);
      *(d_out + 27) = *(temp_char+2);
      *(d_out + 28) = *(temp_char+3);

  i_to_a(day,temp_char);
  if ( out_day < 10 )
    { *(d_out + 21) = '0';
      *(d_out + 22) = *(temp_char);
    }
  else
    { *(d_out + 21) = *(temp_char);
      *(d_out + 22) = *(temp_char+1);
    }
  strcpy(months,"January  February March    April    May      Jun      ");
  strcat(months,"July     August   SeptemberOctober  November December ");
  if ( month >= 1 && month <= 12 )
    { *(d_out+11) = *(months+((month-1)*9));
      *(d_out+12) = *(months+1+((month-1)*9));
      *(d_out+13) = *(months+2+((month-1)*9));
      *(d_out+14) = *(months+3+((month-1)*9));
      *(d_out+15) = *(months+4+((month-1)*9));
      *(d_out+16) = *(months+5+((month-1)*9));
      *(d_out+17) = *(months+6+((month-1)*9));
      *(d_out+18) = *(months+7+((month-1)*9));
      *(d_out+19) = *(months+8+((month-1)*9));
    }

  strcpy(days,"Sunday   Monday   Tuesday  WednesdayThursday Friday   ");
  strcat(days,"Saterday ");
  temp_day = date_55(julian) + 1;
  if ( temp_day >= 1 && temp_day <= 7 )
    { *(d_out) = *(days+((temp_day-1)*9));
      *(d_out+1) = *(days+1+((temp_day-1)*9));
      *(d_out+2) = *(days+2+((temp_day-1)*9));
      *(d_out+3) = *(days+3+((temp_day-1)*9));
      *(d_out+4) = *(days+4+((temp_day-1)*9));
      *(d_out+5) = *(days+5+((temp_day-1)*9));
      *(d_out+6) = *(days+6+((temp_day-1)*9));
      *(d_out+7) = *(days+7+((temp_day-1)*9));
      *(d_out+8) = *(days+8+((temp_day-1)*9));
    }

}


/* ******************************************************************
 * Function name  : date_58
 *
 * Description    : This function calculates the number of days
 *                  between two dates including the days passed
 *                  in a julian format.
 *
 * Variables      : s_julian - This long integer variable contains the
 *                             starting julian date to be calculated from.
 *
 *                  e_julian  - This long integer variable contains the
 *                              ending date to which the days should
 *                              be counted.
 *
 *                  no_days - This long integer variable will contain
 *                            the number of days that is returned to the
 *                            calling function.
 *
 * Rules         : The julian values which are passed to the function
 *                 must be defined as a long integers "long int".
 *
 *                 The calculated value will be returned via an
 *                 integer "long int no_days". Therefore, the function
 *                 must be defined as an integer and the variable
 *                 receiving the returned value must also be an
 *                 integer data type.
 *********************/
long int date_58(s_julian, e_julian)
long int s_julian, e_julian;
{ long int no_days;
  no_days = e_julian - s_julian + 1;

  return(no_days);
}


/* ******************************************************************
 * Function name  : date_59
 *
 * Description    : This function calculates the number of days
 *                  between two dates not including the days passed
 *                  in a julian format.
 *
 * Variables      : s_julian - This long integer variable contains the
 *                             starting julian date to be calculated from.
 *
 *                  e_julian  - This long integer variable contains the
 *                              ending date to which the days should
 *                              be counted.
 *
 *                  no_days - This long integer variable will contain
 *                            the number of days that is returned to the
 *                            calling function.
 *
 * Rules         : The julian values which are passed to the function
 *                 must be defined as a long integers "long int".
 *
 *                 The calculated value will be returned via an
 *                 integer "long int no_days". Therefore, the function
 *                 must be defined as an integer and the variable
 *                 receiving the returned value must also be an
 *                 integer data type.
 *
 *********************/
long int date_59(s_julian, e_julian)
long int s_julian, e_julian;
{ long int no_days;
  no_days = e_julian - s_julian - 1;

  return(no_days);
}


/* ******************************************************************
 * Function name  : date_60
 *
 * Description    : This function calculates what the date will be in
 *                  a specified number of days, given the stating date
 *                  in the format YYYYMMDD and the number of days
 *                  to count.
 *
 * Variables      : s_julian - This long integer contains the starting
 *                             julian date to be calculated from.
 *
 *                  e_julian - This long integer contains the ending
 *                             julian date that will be returned after
 *                             the appropriate number of days have
 *                             been be counted.
 *
 *                  no_days - This integer variable contains
 *                            the number of days that must be
 *                            counted to calculate the ending date.
 *
 * Rules         : The julian value that is passed to the function
 *                 must be defined as a long integer "long int".
 *
 *                 The calculated julian date will be returned via an
 *                 integer "long int e_julian". Therefore, the function
 *                 must be defined as an integer and the variable
 *                 receiving the returned value must also be an
 *                 integer data type.
 *
 *********************/
long int date_60(s_julian, no_days)
long int s_julian;
int no_days;
{ long int e_julian;
  e_julian = s_julian + no_days;

  return(e_julian);
}
