#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <database.hpp>
#include <math.h>

main(int argc, char *argv[])
{
 char index[128];	// Holds index name if supplied
 long i;

 if (argc<3)
 {
  printf("\nUsage : packdb infile outfile [index]\n");
  printf("\n\nDuplicates infile database to outfile database");
  printf("\nremoving deleted records.\n\n");
  printf("\nindex if supplied will operate on infile to define\n");
  printf("\nthe order records are written to outfile\n\n");
  exit(1);
 }
 if (argc==4) strcpy(index,argv[3]); else *index=0;

 database *dbin=new database(argv[1],index);	// Open input database
 database *dbout=new database();		// Create new output database

 if (dbin->isvalid())		// Check input database is valid
 {
  delete dbin; delete dbout;
  printf("\nUnable to open input database, error %d\n\n",dbin->isvalid());
  exit(1);
 }

 for(i=1; i<=dbin->getnfield(); i++)	// Copy all fields
  dbout->addfield(dbin->getfield(i));

 if (dbout->write(argv[2]))
 {
  delete dbin; delete dbout;
  printf("\nUnable to open output database\n\n");
  exit(2);
 }

 record *reci=new record(*dbin);
 record *reco=new record(*dbout);

 long recn=1;
 printf("\n");

 int rv=reci->select(FIRST);	// set to 1st record (default undeleted)
 while(!rv)
 {
  for(i=1; i<=dbin->getnfield(); i++)		// Copy all fields
  {
   if (dbin->getfield(i)->gettype()=='N')	// Numeric fields
   {
    reco->setfield(i,atof(reci->getfield(i)));
   }
   else reco->setfield(i,reci->getfield(i));	// All other fields
  }
  reco->write(NEW);				// Write new record
  rv=reci->select(NEXT);			// Next input record
  printf("\r%ld",recn++);
 }

 delete reci;
 delete reco;
 delete dbin;
 delete dbout;
 printf("\n\nOperation complete\n");
}






