#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include "dll.h"


//=============================================================
HINSTANCE hInstanceDLL    = NULL;
static char szMenuName[]  = "GraphMenu";
static char szClassName[] = "GraphHwnd";
static char szTitle[]     = "Sample Graph Window";


//=============================================================
LRESULT CALLBACK _export GraphWndProc( HWND, UINT, WPARAM, LPARAM );


// ===================================================================== //
//                                                                       //
// ===================================================================== //
HWND CALLBACK _export ShowGraphWindow( HWND hwndParent )
{
    WNDCLASS wc;
    HWND hwndGraph;

    if ( !GetClassInfo( hInstanceDLL, szClassName, &wc ) )
    {
        wc.style            = NULL;
        wc.lpfnWndProc      = GraphWndProc;
        wc.cbClsExtra       = 0;
        wc.cbWndExtra       = 0;
        wc.hInstance        = hInstanceDLL;
        wc.hIcon            = LoadIcon( NULL, IDI_APPLICATION );
        wc.hCursor          = LoadCursor( NULL, IDC_ARROW );
        wc.hbrBackground    = ( HBRUSH )( COLOR_WINDOW + 1 );
        wc.lpszMenuName     = szMenuName;
        wc.lpszClassName    = ( LPSTR )szClassName;
        if ( !RegisterClass( &wc ) )
            return( FALSE );
    }

    hwndGraph = CreateWindow( szClassName,
                            szTitle,
                            WS_POPUPWINDOW|WS_VISIBLE|WS_CAPTION,
                            GetSystemMetrics( SM_CXSCREEN )/3,
                            GetSystemMetrics( SM_CYSCREEN )/3,
                            GetSystemMetrics( SM_CXSCREEN )/3,
                            GetSystemMetrics( SM_CYSCREEN )/3,
                            NULL,
                            NULL,
                            hInstanceDLL,
                            NULL );
    return( hwndGraph );
}


//=============================================================
void GraphHwnd_OnDestroy( HWND hwnd )
{
}



//=============================================================
void GraphHwnd_OnCommand( HWND hwnd, int id, HWND hwndCtl, 
                         UINT codeNotify )
{
    switch( id  )
    {
        case IDM_SETTINGS:
             MessageBox( hwnd, "Settings Dialog here",
                         "DLL GRAPH HWND", MB_OK );
    }
}


//=============================================================
LRESULT CALLBACK _export GraphWndProc( HWND hwnd, UINT msg,
                                       WPARAM wParam, LPARAM lParam )
{
    switch ( msg )
    {
        HANDLE_MSG( hwnd, WM_DESTROY, GraphHwnd_OnDestroy);
        HANDLE_MSG( hwnd, WM_COMMAND, GraphHwnd_OnCommand );

        default:
             return DefWindowProc( hwnd, msg, wParam, lParam );
    }
    return ( 0L );
}



// ===================================================================== //
//                                                                       //
// ===================================================================== //
int FAR PASCAL LibMain( HINSTANCE hInstance, WORD wDataSegment,
                        WORD wHeapSize,   LPSTR lpszCmdLine )
{
    hInstanceDLL = hInstance;

    if ( wHeapSize != 0 )
        UnlockData( 0 );
    return( 1 );
}


// ===================================================================== //
//                                                                       //
// ===================================================================== //
int FAR PASCAL WEP( int bSystemExit )
{
    return 1;
}



