#include  <windows.h>
#include  "combo.rh"
// =================================================================== //
BOOL CALLBACK _export DialogProc( HWND, UINT, WPARAM, LPARAM );
long FAR PASCAL WndProc(HWND, UINT, WPARAM, LPARAM);

// =================================================================== //
HINSTANCE hInst;

// =================================================================== //
#pragma argsused
int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
			LPSTR lpCmdLine,  int nCmdShow )
{
	 static char szAppName[]  = "SimpleComboBox";

	 HWND     hwnd;
	 MSG      msg;
	 WNDCLASS wndclass;

	 hInst = hInstance;

	 if( !hPrevInstance )
	 {
		 wndclass.style = CS_HREDRAW | CS_VREDRAW;
		 wndclass.lpfnWndProc   = WndProc;
		 wndclass.cbClsExtra    = 0;
		 wndclass.cbWndExtra    = 0;
		 wndclass.hInstance     = hInstance;
		 wndclass.hIcon         = LoadIcon( NULL, IDI_APPLICATION );
		 wndclass.hCursor       = LoadCursor( NULL, IDC_ARROW );
		 wndclass.hbrBackground = (HBRUSH)GetStockObject( WHITE_BRUSH );
		 wndclass.lpszMenuName  = "MENU_1";
		 wndclass.lpszClassName = szAppName;

		 RegisterClass( &wndclass );
	 }
	 hwnd = CreateWindow( szAppName, "Simple ComboBox Program",
						  WS_OVERLAPPEDWINDOW,
						  CW_USEDEFAULT, CW_USEDEFAULT,
						  CW_USEDEFAULT, CW_USEDEFAULT,
						  NULL, NULL, hInst, NULL );
	 ShowWindow( hwnd, nCmdShow );
	 UpdateWindow( hwnd );

	 while( GetMessage( &msg, NULL, 0, 0 ) )
	 {
		 TranslateMessage(&msg);
		 DispatchMessage(&msg);
	 }
	 return msg.wParam;
}



// =================================================================== //
BOOL CALLBACK _export DialogProc( HWND hwnd, UINT msg,
											 WPARAM wParam, LPARAM lParam )
{
	 LPSTR Str[3] = {"One", "Two", "Three" };
	 BOOL result = TRUE;
	 switch ( msg )
	 {
		  case WM_INITDIALOG:
		  {
				 LRESULT lresult;
				 HWND hwndCombo = GetDlgItem( hwnd, IDC_COMBOBOX1 );
				 lresult = SendMessage(hwndCombo, CB_ADDSTRING, 0, (LPARAM)Str[0]);
				 lresult = SendMessage(hwndCombo, CB_ADDSTRING, 0, (LPARAM)Str[1]);
				 lresult = SendMessage(hwndCombo, CB_ADDSTRING, 0, (LPARAM)Str[2]);
				 lresult = SendMessage(hwndCombo, CB_SETCURSEL, 0, 0 );

				 result = TRUE;      // Initialize
				 break;
		  }
		  case WM_COMMAND:
		  {
			 switch( wParam )
			 case IDOK:
			 case IDCANCEL:
			 EndDialog( hwnd, wParam );
			 result = 0;
			 break;
		  }
		  case WM_PARENTNOTIFY:
		  {
		  }
		  default:
			 result = FALSE;
	 }
	 return result;
}

long FAR PASCAL WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
  int result;

  switch( msg )
  {
	 case WM_COMMAND:
	 {
		switch( wParam )
		{
		  case CM_FILETEST:
		  {
			 FARPROC fproc= (FARPROC)MakeProcInstance( FARPROC(DialogProc),
																	 hInst );
			 result = DialogBox( hInst, "DIALOG_1", NULL, (DLGPROC)fproc );
			 FreeProcInstance( fproc );
			 break;
		  }
		  case CM_FILEEXIT:
			 PostQuitMessage(0);
			 break;
		}
		break;
	 }
	 case WM_DESTROY:
			 PostQuitMessage(0);
			 return 0;
		  default: break;
  }
  return DefWindowProc( hwnd, msg, wParam, lParam );
}

