/**************************************************************************
 *                               PS_TEST.C                                *
 *                       main() and test functions                        *
 **************************************************************************
 *                     C_PSLIB C / PostScript Library                     *
 *                             copyright 1991                             *
 *                          Barton Creek Software                         *
 *                           all rights reserved                          *
 *                                                                        *
 *                      2222 Western Trails Suite 106                     *
 *                            Austin, TX  78745                           *
 *                             (512) 441-8354                             *
 **************************************************************************/

/* extern unsigned _stklen = 64000u;    / * TURBO C ONLY */

#include "ps.h"

#ifdef ANSI
  void testgraphics(void);
  void testascii(void);
  void testtext(void);
  void test(void);
  void testdash(void);
  void testpixellock(void);
  void testpoly(void);
  void testrepeat(void);
  void testpolycurve(void);
  void fillpatterns(void);
  void testinvert(void);
  void logo(double scalefactor, double xloc, double yloc);
  void square(double x, double y, double size);
#else
  void testgraphics();
  void testascii();
  void testtext();
  void test();
  void testdash();
  void testpixellock();
  void testpoly();
  void testrepeat();
  void logo();
  void square();
  void testpolycurve();
  void fillpatterns();
  void testinvert();
#endif

/****************************************************************************
 main

 2-28-91
 ****************************************************************************/
main()
{
    int select, redirect;

    while(TRUE) {
        printf("\n*****************************************************************************");
        printf("\n*****************************************************************************");
        printf("\n                                C_PSLIB");
        printf("\n                          Barton Creek Software");
        printf("\n                      2222 Western Trails Suite 106");
        printf("\n                           Austin, Texas  78745");
        printf("\n                            TEL 512-441-8354");
        printf("\n                            FAX 512-444-4554");
        printf("\n*****************************************************************************");
        printf("\n");
        printf("\n                          Select a Test Function");
        printf("\n*****************************************************************************");
        printf("\n*****************************************************************************");
        printf("\n");
        printf("\nGraphics        1:"
               "\nText            2:"
               "\nLine Printer    3:"
               "\nLooping         4:"
               "\nPixel Lock      5:"
               "\nDash Patterns   6:"
               "\nLogo            7:"
               "\nFillpatterns    8:"
               "\nInverted Y Axis 9:"
               "\nQuit            Q:"
               "\n> ");
        if(!scanf("%d", &select))
            exit(0);
        printf("\nSend the output to: 1) DEFAULT.PS  2) PRN   > ");
        scanf("%d", &redirect);
        if(redirect==2)
        ps_setfilename("prn");
        if(ps_autoinit()) {
            ps_beginpage(NULL);
            logo(.5, 7.5*PPI, 10.0*PPI);
            switch(select) {
                case  1: testgraphics(); break;
                case  2: testtext(); break;
                case  3: testascii(); break;
                case  4: testrepeat(); break;
                case  5: testpixellock(); break;
                case  6: testdash(); break;
                case  7: logo(4.0, 8.5*PPI/2.0, 11.0*PPI/2.0); break;
                case  8: fillpatterns(); break;
                case  9: testinvert(); break;
                default: printf("\nInvalid selection");
            }
            ps_endjob(EJECT);
        }
        else {
            printf("\ninit did not work");
        }
    }
    return 0;
}

/****************************************************************************
 fillpatterns

 produces a listing of fill patterns

 2-28-91
 ****************************************************************************/
void fillpatterns()
{
    int i, j, count;
    double x=1.0, y=1.5;
    char s[20];

    ps_fontset("Helvetica", 24.0, 24.0);
    ps_txt(8.5*PPI/2, 600.0, TEXTCENTER, "Fill Patterns");
    ps_translate(140.0, 204.0);
    ps_setfill(FILL);
    ps_scale(0.5,0.5);
    for(i=0,count=1; i< 5; i++) {
        x = 2.0;
        for(j=0; j<3; j++) {
            ps_setfillpattern(count);
            ps_bar(x*72.0, y*72.0, x*72.0+72.0,y*72.0+72.0);
            psu_itoa(count,s,10);
            ps_txt(x*72.0+36.0,y*72.0-18.0,TEXTCENTER,s);
            x += 2.0;
            ++count;
        }
        y += 1.5;
    }
}

/****************************************************************************
 testdash

 produces a listing of dash patterns

 2-28-91
 ****************************************************************************/
void testdash()
{
    int i, j, count;
    double x, y=280.0;
    char s[20];

    ps_fontset("Helvetica", 24.0, 24.0);
    ps_txt(8.5*PPI/2, 600.0, TEXTCENTER, "Dash Patterns");
    for(i=0, count=0; i<4; i++) {
        x = 200.0;
        for(j=0;j<2;j++,count++) {
            ps_setdashpattern(count,1.0,0.0);
            ps_line(x,y,x+72.0,y);
            psu_itoa(count,s,10);
            ps_txt(x+36.0,y-24.0,TEXTCENTER,s);
            x += 144.0;
        }
        y += 72.0;
    }
}

/****************************************************************************
 testdash

 Demonstrates the effect of locking on a pixel in device space for
   drawing parallel lines

 2-28-91
 ****************************************************************************/
void testpixellock()
{
    int i;

    ps_fontset("AvantGarde-Demi",14.0,14.0);
    ps_setpixellock(OFF);
    psp_gsave();
    ps_setlinewidth(.001);
    ps_translate(8.5*PPI/2, 11*PPI/2.0);
    ps_txt(0.0,0.0,TEXTLEFT,".001 linewidth WITHOUT pixel lock");
    ps_txt(0.0,-20.0,TEXTLEFT,"Notice the uneven linewidths");
    for(i=0;i<100;i+=2) {
        ps_moveto(-150.0,(double) ((double) i-50.0));
        ps_lineto(-200.0,(double) ((double) i-50));
    }
    psp_grestore();

    ps_setpixellock(ON);
    psp_gsave();
    ps_setlinewidth(.001);
    ps_translate(8.5*PPI/2, (11*PPI/2.0) + 200.0);
    ps_txt(0.0,0.0,TEXTLEFT,".001 linewidth WITH pixel lock");
    ps_txt(0.0,-20.0,TEXTLEFT,"Notice the even linewidths");
    for(i=0;i<100;i+=2) {
        ps_moveto(-150.0,(double) ((double) i-50));
        ps_lineto(-200.0,(double) ((double) i-50));
    }
    psp_grestore();
}

/****************************************************************************
 testrepeat

 displays the use of ps_ repeat functions
 the PS code is 50 50 moveto  100 50 lineto wrapped in 3 nested loops

 2-28-91
 ****************************************************************************/
void testrepeat()
{
    ps_fontset("Times-Roman",14.0,14.0);
    ps_txtr(6.5*PPI, 11*PPI/2.0, TEXTCENTER,  90.0, "Nested Repeat");
    ps_txtr(6.75*PPI, 11*PPI/2.0, TEXTCENTER, 90.0, "of ps_moveto(50,50) and ps_lineto(100,50)");
    ps_setpixellock(ON);
    ps_setlinewidth(.001);
    ps_initrepeat(0.0,0.0,6,0.0,60.0,0.0,0.0,0.0);
      ps_initrepeat(0.0,0.0,3,0.0,0.0,225.0,0.0,0.0);
        ps_initrepeat(0.0,0.0,100,0.0,0.0,2.0,0.0,0.0);
            ps_moveto(50.0,50.0);
            ps_lineto(100.0,50.0);
        ps_endrepeat();
      ps_endrepeat();
    ps_endrepeat();
}

/****************************************************************************
 testtext

 Demostrates some standard text functions

 2-28-91
 ****************************************************************************/
void testtext()
{
    psp_translate(0.0, 100.0, PSNULL);
    ps_line(100.0, 300.0, 100.0, 600.0);
    ps_fontset("Helvetica",14.0,0.0);
    ps_txt(100.0, 410.0, TEXTLEFT,   "LEFT");
    ps_txt(100.0, 430.0, TEXTRIGHT,  "RIGHT");
    ps_txt(100.0, 450.0, TEXTCENTER, "CENTER");
   	ps_rectangle(100.0,200.0,200.0,400.0);
    ps_txtf(100.0, 204.0, TEXTLEFT, 40.0, "Squeeze to");
    ps_txtf(200.0, 204.0, TEXTRIGHT, 50.0, "Fit Horizontally");
    ps_txtrf(150.0, 300.0, TEXTCENTER, 196.0, 90.0, "Rotate and Squeeze Text to Fit on an Angle");
    ps_txtr(105.0, 600.0, TEXTRIGHT, 160.0, "Left, Center, or Right Justify Text at any Angle");
    psp_translate(0.0, -100.0, PSNULL);
    ps_fontset("Times-Roman",20.0,0.0);
    ps_txtrf(408.0, (6.0*72.0)/2.0, TEXTCENTER, (6.0*72.0)-36.0, 270.0, "Say Hello to the world of PostScript");

    ps_line(100.0,175.0,310.0,175.0);
    ps_paragraph("Times-Roman", 10.0, 10.0, 100.0, 175.0, 12.0, 310.0, TEXTJUSTIFY,
                 "The computing world has undergone a revolution since the publication of"
                 " the C Programming Language in 1978.  Big computers are much bigger, and"
                 " personal computers have capabilities that rival the mainframes of a decade ago."
                 "  During this time, C has changed too, although only modestly, and it has spread"
                 " far beyond its origins as the language of the UNIX operating system.");
    ps_fontset("Times-Italic", 12.0, 12.0);
    ps_txt(310.0, 60.0, TEXTRIGHT, "Brian W. Kernighan, Dennis Ritchie");
    ps_fontset("Times-Italic", 8.0, 8.0);
    ps_txt(310.0, 48.0, TEXTRIGHT, "Preface to Second Edition, The C Programming Language");
}

/****************************************************************************
 testgraphics

 Demonstrates some graphics functions

 2-28-91
 ****************************************************************************/
void testgraphics()
{
    double points[3][2] = {72.0, 72.0, -72.0, 72.0, 72.0, 72.0};
    int i;

    ps_setfillpattern(3);
    ps_setfill(FILL);
    ps_setfillpattern(1);
    ps_setfill(STROKE);
    ps_line(504.0, 36.0, 306.0, 756.0);
    ps_lineto(36.0,36.0);
    ps_arc(144.0, 600.0, 0.0, 270.0, 36.0);
    ps_circle(144.0, 720.0, 36.0);
    square(108.0, 684.0, 72.0);
    ps_setfill(FILL);
    ps_circle(468.0, 648.0, 10.0);
    ps_setfill(STROKE);
    ps_ellipse(468.0, 648.0, 0.0, 360.0, 36.0, 72.0, 0.0);
    ps_ellipse(468.0, 648.0, 0.0, 360.0, 36.0, 72.0, 45.0);
    ps_ellipse(468.0, 648.0, 0.0, 360.0, 36.0, 72.0, 135.0);
    ps_setfill(FILL);
    ps_setfillpattern(12);
    for(i=0; i<16; i++) {
        ps_setfillpattern(i);
        ps_bar((i*0.5)*72.0, 36.0, (i*0.5+0.5)*72.0, (i*0.5+0.5)*72.0);
    }
    ps_moveto(306.0, 396.0);
    ps_polyrel(3, points,TRUE);
}

/****************************************************************************
 testascii

 Demonstrates the ascii text functions

 2-28-91
 ****************************************************************************/
void testascii()
{
    int i;

    psa_init(11.0, 8.5, LANDSCAPE);
    ps_fontset("Helvetica",14.0,14.0);
    for(i=0;i<10;i++) {
        psa_text(TEXTLEFT, "Hello, Landscape ASCII Mode");
    }
    ps_invert_y(8.5*PPI);
    psa_setpage(8.5,11.0,PORTRAIT);
    psa_setlinespacing(0.3);
    ps_fontset("Helvetica",20.0, 20.0);
    for(i=0;i<10;i++) {
        psa_text(TEXTLEFT, "Now Portrait ASCII Mode With an Inverted Y Axis");
    }

    psa_setpage(11.0, 8.5, LANDSCAPE);
    for(i=0;i<10;i++)
        psa_text(TEXTLEFT,"");
    for(i=0;i<10;i++) {
        psa_text(TEXTLEFT, "Now Landscape Again in ASCII Mode");
    }
    psa_endjob(FALSE);
}

/****************************************************************************
 testpoly

 polygon test functions

 2-28-91
 ****************************************************************************/
void testpoly()
{
    double p[3][2];

    p[0][0]=200.0;
    p[0][1]=200.0;
    p[1][0]=400.0;
    p[1][1]=200.0;
    p[2][0]=300.0;
    p[2][1]=500.0;

    ps_poly(3,p,TRUE);

    p[0][0]=300.0;
    p[0][1]=0.0;
    p[1][0]=-100.0;
    p[1][1]=200.0;

    ps_polyrel(2,p,TRUE);
}

/****************************************************************************
 logo

 draws the c_pslib logo

 2-28-91
 ****************************************************************************/
void logo(scalefactor, xloc, yloc)
double scalefactor, xloc, yloc;
{
    psp_gsave();
    ps_setgray(0.8);
    ps_translate(xloc, yloc);
    ps_scale(scalefactor, scalefactor);
    ps_fontset("AvantGarde-Demi",14.0,14.0);
    ps_initrepeat(0.0,0.0,24,15.0,0.0,0.0,0.0,0.0);
      ps_txt(0.0,0.0,TEXTLEFT,"c_ps.lib");
    ps_endrepeat();
    ps_fontset("AvantGarde-Demi",20.0,20.0);
    ps_setgray(0.0);
    ps_txt(-6.5,-5.5,TEXTLEFT,"c_ps.lib");
    ps_fontset("Times-Roman",10.0,10.0);
    ps_txt(0.0, -66.0, TEXTCENTER, "Barton Creek Software");
    ps_txt(0.0, -76.0, TEXTCENTER, "512-441-8354");
    psp_grestore();
}

/****************************************************************************
 testpolycurve

 tests polycurve function

 2-28-91
 ****************************************************************************/
void testpolycurve()
{
    double p[310][2];
    int i;

    ps_translate(100.0,100.0);
    ps_curveto(10.0,10.0,35.0,40.0,100.0,50.0,90.0,10.0);
    ps_curveto(100.0,100.0,100.0,150.0,200.0,100.0,200.0,150.0);
    ps_curveto(100.0,200.0,175.0,250.0,75.0,250.0,150.0,210.0);
    ps_translate(0.0,100.0);
    ps_scale(2.0,2.0);

    for(i=0;i<100;i++) {
        p[i*3][0]   = i*10.0;                 /*    x1    */
        p[i*3][1]   = (!(i%2)) ? 10.0:-10.0;  /*    y1    */
        p[i*3+1][0] = (i+1)*10.0  ;           /*    x2    */
        p[i*3+1][1] = (!(i%2)) ? 10.0:-10.0;  /*    y2    */
        p[i*3+2][0] = (i+1)*10.0;             /*    x3    */
        p[i*3+2][1] = 0.0;                    /*    y3    */
    }
    ps_polycurve(0.0,0.0,100,p,FALSE);
}

/****************************************************************************
 square

 called by testgraphics() to draw a square

 2-28-91
 ****************************************************************************/
void square(x, y, size)
double x, y, size;
{
    double p[3][2]={1.0, 0.0, 0.0, 1.0, -1.0, 0.0};
    int i;

    ps_moveto(x, y);
    for(i=0;i<3;i++) {
        p[i][0] = p[i][0] * size;
        p[i][1] = p[i][1] * size;
    }
    ps_polyrel(3,p,1);
}

/****************************************************************************
 testinvert

 Demonstrates the inversion of the coordinate system along the y axis

 2-28-91
 ****************************************************************************/
void testinvert()
{
    ps_invert_y(11.0*PPI);  /* ON  */
    ps_txt(72.0, 72.0, TEXTLEFT,   "A ( 72,  72) INVERTED  Portrait");
    ps_invert_y(11.0*PPI);  /* OFF */
    ps_txt(96.0, 96.0, TEXTLEFT,   "B ( 96,  96) NO INVERT Portrait");
    ps_invert_y(11.0*PPI);  /* ON  */
    ps_txt(120.0, 120.0, TEXTLEFT, "C (120, 120) INVERTED  Portrait");
    ps_orient(11.0*PPI, 8.5*PPI, LANDSCAPE);
    ps_txt(144.0, 144.0, TEXTLEFT, "D (144, 144) INVERTED  Landscape");
    ps_orient(8.5*PPI, 11.0*PPI, PORTRAIT);
    ps_txt(168.0, 168.0, TEXTLEFT, "E (168, 168) INVERTED  Portrait");

    ps_orient(11.0*PPI, 8.5*PPI, LANDSCAPE);
    ps_invert_y(8.5*PPI);  /* OFF */
    ps_txt(192.0, 192.0, TEXTLEFT, "F (192, 192) NO INVERT Landscape");

    ps_orient(8.5*PPI, 11.0*PPI, PORTRAIT);
    ps_invert_y(11.0*PPI);
    ps_txt(216.0, 216.0, TEXTLEFT, "G (216, 216) INVERTED  Portrait");

    ps_invert_y(11.0*PPI);
    ps_txt(240.0, 240.0, TEXTLEFT, "H (240, 240) NO INVERT Portrait");
    ps_orient(11.0*PPI, 8.5*PPI, LANDSCAPE);

    ps_invert_y(8.5*PPI);   /* ON  */
    ps_txt(264.0, 264.0, TEXTLEFT, "I (264, 264) INVERTED Landscape");

    ps_orient(8.5*PPI, 11.0*PPI, PORTRAIT);
    ps_invert_y(11.0*PPI);  /* OFF */
    ps_txt(288.0, 288.0, TEXTLEFT, "J (288, 288) NO INVERT Portrait");
    ps_orient(11.0*PPI, 8.5*PPI, LANDSCAPE);
    ps_txt(312.0, 312.0, TEXTLEFT, "K (312, 312) NO INVERT Landscape");

    ps_orient(8.5*PPI, 11.0*PPI, PORTRAIT);
    ps_txt(336.0, 336.0, TEXTLEFT, "L (336, 336, NO INVERT Portrait");

    ps_orient(11.0*PPI, 8.5*PPI, LANDSCAPE);

    ps_txt(360.0, 360.0, TEXTLEFT, "M (360, 360) NO INVERT Landscape");
    ps_invert_y(8.5*PPI);      /* ON  */
    ps_txt(384.0, 384.0, TEXTLEFT, "N (384, 384, INVERTED  Landscape");
    ps_invert_y(8.5*PPI);      /* OFF */
    ps_txt(408.0, 408.0, TEXTLEFT, "O (408, 408, NO INVERT Landscape");

    ps_orient(8.5*PPI, 11.0*PPI, PORTRAIT);
    ps_fontset("Helvetica", 14.0, 14.0);
    ps_txt(8.5*PPI/2.0, .5*PPI, TEXTCENTER, "Moving in and out of Portrait / Landscape with an Inverted Y axis");
}

