/*
	lsam.h	   Lydian Software Access Method
		   standard header file for LSAM system use.
		   data structures and other preprocessor definitions
		   required for system use.
	Copyright (C) Lydian Software, 1987, 1988
*/
#define  EOS '\0'                      /* END OF STRING CONSTANT */
#define  YES   1		       /* yes/no 'boolean' switch values */
#define  NO    0
#define  ON    YES
#define  OFF   NO
	       /* SYSTEM RETURN CODE VALUES: */
#include "lsrcodes.h"
	       /* SYSTEM KEY LENGTH, PATH STRING LIMITS: */
#include "lslimits.h"
	       /* DATA TYPE DEFINITIONS */
typedef unsigned int  UINT;	       /* shorthand */
typedef unsigned char UCHAR;
typedef unsigned char BOOLEAN;
typedef unsigned long ULONG;
typedef struct {		       /* BASE FILE PARAMETERS STRUCTURE */
    UCHAR fill[1];
} *LSBFPP;			       /* POINTER type */
typedef struct {	       /* LSAM STATUS/TRACE data structure */
    UCHAR *_fn; 		       /* last LSAM function name str. addr. */
    int    _rcode;		       /* last LSAM function return code */
    UCHAR *_bfname;		       /* base file name string address */
    UCHAR *_ifname;		       /* index file name string address */
    UINT   _ifno;		       /* index relative subscript number */
} LSSTATUS, *LSSTATUSP; 	       /* struct and POINTER types */

    /* ls_open() PARM FILE SWITCH OPTIONS - values for	'env_or_name' switch */
#define PARM_ENV_VAR  YES  /* string is an ENV VAR holding parm file pathname */
#define PARM_NAME     NO   /* string IS parm file pathname */

    /* ls_startbr() OPTIONS - values for 'stype' start type switch */
#define GTEQ   0	   /* request positioning at next greater or equal key*/
#define EQUAL  1	   /* request positioning at equal key only (exact) */

    /* ls_trace() OPTIONS - values for 'ttype' start type */
#define ALL    1	   /* request trace ON/OFF for ALL BASE/INDEX groups */
#define BASE   2	   /* request trace ON/OFF for ALL indices of base */
#define INDEX  3	   /* request trace ON/OFF for this base's index only */
	       /* SYSTEM REQUEST FUNCTION DECLARATIONS */

void ls_bldixkey(LSBFPP,UINT,UCHAR *); /* build key string service for non-contiguous keys */
int  ls_is_ix_new(LSBFPP,UINT),      /* returns YES if selected ix created by this run, else NO */
     ls_bldindx(LSBFPP,UINT),	     /* build index file for given base file */
     ls_startbr(LSBFPP,UINT,UCHAR *,UCHAR), /* (re)set current record pointer for seq read */
     ls_read(LSBFPP,UINT,UCHAR *),   /* 'random' read (by key) */
     ls_readnext(LSBFPP,UINT),	     /* sequential read (next) logical record, given index */
     ls_readprev(LSBFPP,UINT),	     /* sequential read (prev) logical record, given index */
     ls_write(LSBFPP),		     /* write new record */
     ls_rewrite(LSBFPP,UINT,UCHAR *),/* update existing record */
     ls_delete(LSBFPP,UINT,UCHAR *), /* delete existing record */
     ls_close(LSBFPP),		     /* close base/index file set */
     ls_trace(UINT,UINT,LSBFPP,UINT),/* sets trace ON/OFF for ALL,BASE,INDEX */
     ls_fn_ret(void),	 /* display func, ret. code, desc. for last LSAM call */
     ls_release(void),		     /* release RTL memory and RETURN to caller*/
     ls_exit(int),		     /* call ls_release(), then EXIT w/code */
     lsam(void);       /* dummy call to force linker inclusion of lsam module */
LSBFPP ls_open(char *,int,UCHAR *,UCHAR *); /* open base/index file set using generated parm file */
extern int lsam(void);		     /* force linker inclusion this way */
extern LSSTATUS lstat;		     /* global last fn, ret. code structure */
