/*
       dlscan.c
       C J Starr
       03-06-88
       Description:
	   CIS data library scan for offline usage, intended as a
	   demo for users of the LSAM demo system I uploaded.
       Program usage:
		dlscan inp_parm
		     where:
			 inp_parm is a defined DOS environment variable
				  containing the exact path and filespec
				  of the binary parameter/control file
				  describing the INPUT or 'master' file/index.
*/
#define LINT_ARGS YES
/* Microsoft headers */
#include "stdio.h"
#include "dos.h"
#include "string.h"
/* non-MS headers */
#include "lsam.h"                      /* LSAM user required header file */
#include "dl_clf.h"                    /* DL Catalog LSAM Format structure */
	      /* symbolics for readability */
#define NO	    0			/* boolean switch constants */
#define YES	    1
#define FORWARD     0			/* browse direction values */
#define BACKWARD    1
#define BEEP	    7
#define BELL	    putch(BEEP)        /* ascii bell send */
#define ESC	    27		       /* decimal ESCAPE (exit pgm) char code */
#define F1	    59		       /* decimal f-key values */
#define F2	    60
#define F3	    61
#define F4	    62
#define F5	    63
#define F6	    64
#define F7	    65
#define F8	    66
#define F9	    67
#define F10	    68

CATREC dl_rec;			       /* DL Catalog LSAM format record area */

int  flush_ky(void);
int  char_kyb(int *);
int  select(void);
int  setindex(LSBFPP,UINT);
void display_header(void);
void banner(void);
void cls(void);
void show_dl_data(void);

void main(argc,argv)
int argc;
char **argv;
{
       register int ret = RGOOD;
       LSBFPP fp1;
       UINT which_ix = 0;
       int fkey = 0, direction = FORWARD;
       char fini = NO;

       banner();
       if(argc < 2) {
	   printf("\nDLSCAN Usage error: requires env. var. pointing to input parm file");
	   exit(1);
       }
   /* OPEN INPUT FILE,IX */
       fp1 = ls_open(strupr(argv[1]),PARM_ENV_VAR,"rb",(UCHAR *)&dl_rec);
   /* SET TRACE FACILITY ON FOR INDEX 1 only */
   /*  ls_trace(ON,INDEX,fp1,1); */
   /* test for open error(s) */
       if(fp1 == NULL) {
	   printf("DLSCAN Open error: input ptr = 0x%04x\n",fp1);
	   exit(2);
       } else {
	   if(ls_is_ix_new(fp1,0) == RIXISNEW)/*did we JUST NOW create index ?*/
	       setindex(fp1,0); 		 /* build index */
	   if(ls_is_ix_new(fp1,1) == RIXISNEW)/*did we JUST NOW create index ?*/
	       setindex(fp1,1); 		 /* build index */
	   if(ls_is_ix_new(fp1,2) == RIXISNEW)/*did we JUST NOW create index ?*/
	       setindex(fp1,2); 		 /* build index */
       }
       display_header();
       while(!fini) {
	   fkey = select();
	   switch(fkey) {
	   case F1:
	   case F2:
	       which_ix = 0;
	       break;
	   case F3:
	   case F4:
	       which_ix = 1;
	       break;
	   case F5:
	   case F6:
	       which_ix = 2;
	       break;
	   case ESC:		       /* exit program */
	       fini = YES;
	       continue;
	   default:		       /* handle wrong keys here */
	       BELL;
	       continue;
	   }
	   switch(fkey) {
	   case F1:
	   case F3:
	   case F5:
	       ret = ls_readnext(fp1,which_ix);  /* read next 'logical' master record */
	       if(ret == RGOOD || ret == REOF)	 /* return OK ? */
		   show_dl_data();		     /* display record */
	       else				 /* otherwise */
		   fini = YES;			     /* indicate loop end */
	       break;
	   case F2:
	   case F4:
	   case F6:
	       ret = ls_readprev(fp1,which_ix);  /* read prev 'logical' master record */
	       if(ret == RGOOD || ret == REOF)	 /* return OK ? */
		   show_dl_data();		     /* display record */
	       else				 /* otherwise */
		   fini = YES;			     /* indicate loop end */
	       break;
	   }
       }
       ret = ls_close(fp1);	       /* close input */
       fprintf(stderr,"DLSCAN: End of processing");
       ls_exit(0);		       /* deallocate RTL, return to DOS */
}
int setindex(base,ix)	/* build index for file BASE w/handle at slot IX */
LSBFPP base;
UINT ix;
{
       fprintf(stderr,"DLSCAN: Constructing index %d, please wait\n",ix);
       ls_bldindx(base,ix);
       fprintf(stderr,"DLSCAN: Index %d build complete\n",ix);
       return;
}
int select()
{
       register int i, k;
       int f_ky, scan;
       char done = NO;

       flush_ky();			/* flush the type-ahead keyboard buffer */
       while(done == NO) {
	   if(k = ready_ky()) { 	      /* is a character waiting ? */
	       i = char_kyb(&scan);	      /* get scan code, char. code */
	       f_ky = (i == 0) ? scan : i;    /* assign appropriate code */
	       done = YES;		      /* exit loop */
	   }
       }
       return f_ky;
}
void show_dl_data()		       /* display one DL description */
{
       display_header();
       printf("%s\n%s\n%-20s  %9s  %7s Accesses: %5s    %9s\n\nKeywords: %s\n\n%s\n",
	       dl_rec.dl_no,
	       dl_rec.userid,
	       dl_rec.filename,
	       dl_rec.upl_date,
	       dl_rec.filesize,
	       dl_rec.acc_count,
	       dl_rec.mod_date,
	       dl_rec.keywords,
	       dl_rec.descript);
}
void display_header()		       /* name, copyright and prompts */
{
       banner();
       fprintf(stderr,"%s%s%s",
	       "F1=Forward(DL,Filename) F2=Backward(DL,Filename)\n",
	       "F3=Forward(DL,User ID)  F4=Backward(DL,User ID)\n",
	       "F5=Forward(DL,Keywords) F6=Backward(DL,Keywords) ESC=Exit\n\n\n");
}
void banner()			       /* clear screen, show name, copyright */
{
       cls();
       fprintf(stderr,"%s%s",
	       "DLSCAN (C) Copyright 1988, Lydian Software\n",
	       "CompuServe Data Library Offline Scan Utility\n\n");
}
/* DOS/BIOS interface routines */
int flush_ky()			       /* flush type-ahead buffer */
{
       return(bdos(0x000C,0,0) & 0x00FF);
}
int ready_ky()			      /* return non-zero if char. in buffer */
{
       return(bdos(0x000B,0,0) & 0x00FF);
}
int char_kyb(scan_code) 	      /* return char., place scan code at */
int *scan_code; 		      /* address 'scan_code' */
{
       union REGS regs;

       regs.x.ax = 0;
       int86(0x0016,&regs,&regs);
       *scan_code = (int)regs.h.ah;
       return((int)regs.h.al);
}
void cls()			       /* clear screen, home cursor */
{
       union REGS regs;

       regs.h.ah = 6;		       /* service 6: scroll */
       regs.h.al = 0;		       /* 0 lines does whole screen */
       regs.h.bh = 7;		       /* attr. 7 = normal */
       regs.h.bl = 0;
       regs.h.ch = 0;		       /* co-ords. of top left corner */
       regs.h.cl = 0;
       regs.h.dh = 24;		       /* co-ords. of bottom right corner */
       regs.h.dl = 79;
       int86(0x10,&regs,&regs);        /* call BIOS video interrupt */
       regs.h.ah = 2;		       /* service 2: position cursor */
       regs.h.al = 0;
       regs.x.bx = 0;		       /* bh=page no=0 (req. for graphics) */
       regs.x.dx = 0;		       /* dh,dl = x-coord,y-coord = 0,0 */
       int86(0x10,&regs,&regs);        /* call BIOS video interrupt */
}
/* LSAM forced linker auto-inclusion routine - NEVER CALLED */
dummy() /* Please don't waste CPU cycles by calling this, it does nothing */
{
       lsam();
}
