/*
	dlformat.c     Filter pgm: Reads captured ASCII text from CIS
				   Data Libraries, converting input to
				   fixed-length record format file suit-
				   able for indexing via LSAM.
*/
#include "stdio.h"
#include "string.h"
#include "dl_clf.h"                    /* formatted DL record structure */
	      /* symbolics for readability */
#define NO		0	       /* boolean switch constants */
#define YES		1
#define  EOS	   '\0'   /* end of string symbolic constant */
#define  TAB	   '\t'   /* tab character symbolic constant */
#define  CR	   0x0d   /* carriage return character symbolic constant */
#define  LF	   0x0a   /* linefeed character symbolic constant */
#define  DOS1_PRT  9	  /* DOS 1.1 system print function req. # */
#define  S_INIT    0	  /* proc_state discrete values for input processing */
#define  S_USERID  1
#define  S_NAME    2
#define  S_KEYWDS  3
#define  S_DESCR   4

char *errmsg[] = {
    "Usage requires input filename$",
    "Input file not found$",
    "Output file open error$",
    "Output file write error$"
};
unsigned char space = 0x20;
unsigned int  line_no = 0;
unsigned char inddname[80],
	      outddname[80],
	      inbuffer[256];
#define  BUFFLEN sizeof(inbuffer)

CATREC catrec,			       /* declare record area */
       catrecinit;		       /* and initialized area for re-init */

extern FILE *fopen();
extern char *fgets();

main(argc,argv)
int argc;
char **argv;
{
       FILE *inp, *outp;
       unsigned char *sub0,	       /* substring pointers */
		     *sub1,
		     *ret,	       /* fgets() return ptr */
		     eofinp = NO,      /* input EOF switch */
		     got_keys = NO,    /* keyword, desrciption state switches */
		     got_desc = NO;
       unsigned bflen = BUFFLEN;
       unsigned lines_in = 0;
       unsigned proc_state = S_INIT;

       banner();
       if(argc < 2) {
	   bdos(DOS1_PRT,errmsg[0]);
	   _exit(0x0001);
       }
       strcpy(inddname,*++argv);
       if(!(inp = fopen(inddname,"rb"))) {
	   bdos(DOS1_PRT,errmsg[1]);
	   _exit(0x0002);
       }
       if(sub0 = strrchr(inddname,'.')) {    /* do we have a 'dot' */
	   *sub0 = EOS; 			/* terminate string at 'dot' */
       }
       strcpy(outddname,inddname);	    /* copy in to out filename */
       strcat(outddname,".clf");            /* append .clf extension */
       if(!(outp = fopen(outddname,"wb"))) {
	   bdos(DOS1_PRT,errmsg[2]);
	   exit(0x0003);
       }
    /* set up a pre-initialized record area for simple re-initialization */
       memset(&catrecinit,EOS,sizeof(CATREC)); /* zero it out first */
       strcpy(catrecinit.dl_no,"DL??");        /* DL is unknown so far */
       catrecinit.dlcrlf[0] = catrecinit.u_crlf[0] = catrecinit.f_crlf[0] =
       catrecinit.k_crlf[0] = catrecinit.d_crlf[0] = CR;
       catrecinit.dlcrlf[1] = catrecinit.u_crlf[1] = catrecinit.f_crlf[1] =
       catrecinit.k_crlf[1] = catrecinit.d_crlf[1] = LF;
       memcpy(&catrec,&catrecinit,sizeof(CATREC)); /* now initialize work recd*/
    /* now loop through the text, writing formatted records */
       while(eofinp != YES) {
	   ret = fgets(inbuffer,BUFFLEN,inp);
	   if(ret == NULL) {
	       if(lines_in == 0)
		   printf("DLFORMAT: EOF on first read of %s\n",inddname);
	       else
		   printf("DLFORMAT: EOF after line %d of %s\n",lines_in,inddname);
	       eofinp = YES;
	   } else {
	       lines_in++;
	       switch(proc_state) {
	       case S_INIT:
s_init: 	   if(*inbuffer == 'D') {    /* look for 'DL??' */
		       strcpy(catrec.dl_no,inbuffer);
		       strcpy(catrecinit.dl_no,inbuffer);
		       continue;
		   } else if(*inbuffer != '[') /*look for userid begin bracket*/
		       continue;
		   else 		   /* when found */
		       proc_state = S_USERID;	  /* then fall through */
	       case S_USERID:
		   if(*inbuffer == CR || *inbuffer == LF)
		       continue;
		   sub0 = inbuffer;
		   sub1 = catrec.userid;
		   while(*sub0 != CR)  /* copy up to CR */
		       *sub1++ = *sub0++;
		   *sub1 = EOS;        /* terminate string */
		   proc_state = S_NAME;
		   break;
	       case S_NAME:
		   if(*inbuffer == CR || *inbuffer == LF)
		       continue;
		   sub0 = strstr(inbuffer,"Accesses: ");
		   if(sub0 != NULL)		     /* captured ? */
		       sscanf(inbuffer,"%20s  %9s  %7s Accesses: %5s    %9s",
						      catrec.filename,
						      catrec.upl_date,
						      catrec.filesize,
						      catrec.acc_count,
						      catrec.mod_date);
		   else 			     /* no, assume TAPCIS */
		       sscanf(inbuffer,"%20s  %9s  %7s  %5s    %9s",
						      catrec.filename,
						      catrec.upl_date,
						      catrec.filesize,
						      catrec.acc_count,
						      catrec.mod_date);
		   proc_state = S_KEYWDS;
		   break;
	       case S_KEYWDS:
		   if((*inbuffer == CR || *inbuffer == LF) && got_keys == NO)
		       continue;
		   else if(*inbuffer == space) {
		       int sl, i = 0;
		       sub0 = (got_keys == NO) ? inbuffer + 14 : inbuffer + 4;
		       strcat(catrec.keywords,sub0);
		       sub1 = catrec.keywords;	 /* point to keywords */
		       sl = strlen(catrec.keywords); /* get length of string */
		       sl--;			   /* back off as max offset */
		       while(i <= sl) { 	   /* search for CR and */
			   if(*(sub1 + i) == CR) { /* if CR is found */
			       *(sub1 + i) = space; /* substitute a space */
			       *(sub1 + i + 1) = EOS; /* and follow w/EOS */
			       break;
			   }
			   i++;
		       }
		       got_keys = YES;
		   } else if(*inbuffer == CR || *inbuffer == LF) /* newlines */
		       proc_state = S_DESCR;
		   break;
	       case S_DESCR:
		   if((*inbuffer == CR || *inbuffer == LF) && got_desc == NO)
		       continue;
		   else if(*inbuffer == space) {
		       strcat(catrec.descript,inbuffer + 4);
		       got_desc = YES;
		   } else if(*inbuffer == 'P'      /* 'Press <CR> for more !' */
			  || *inbuffer == CR || *inbuffer == LF) /* newlines */
		       ;
		   else {
		       proc_state = S_INIT;	   /* return to initial state */
		       got_desc = got_keys = NO;
		       fwrite(&catrec,sizeof(CATREC),1,outp);
		   /* initialize record area from pre-initialized record area */
		       memcpy(&catrec,&catrecinit,sizeof(CATREC));
		       goto s_init;
		   }
		   break;
	       }
	   }
       }
       fclose(outp);
       fprintf(stderr,"DLFORMAT: DLSCAN-compatible file [%s] generated\n",
	       outddname);
       exit(0);
}
banner()
{
       fprintf(stderr,"%s%s","DLFORMAT (C) Copyright 1988, Lydian Software\n",
			     "CIS '.CAT' file generator for LSAM\n");
}
