echo off
goto start
rem	  batch file to set required environ vars and run demo DLSCAN
rem	  after it generates the required parameter file and runs DLFORMAT
rem	  to build the required fixed-length record format file for LSAM.
rem
:start
cls
echo ..........................................................................
echo .	 %0 is a demo providing a simple example of the usage of the LSAM
echo .	 system.  The sequence of events will be as follows:
echo .	      1)   Set environment variables required for demo.
echo .	      2)   Generate an input control file for DLSCAN using GENPARM.
echo .	      3)   Show a formatted display of this file using PARMLIST.
echo .	      4)   Generate a fixed-length file w/'.CLF' extension from an
echo .		   unformatted '.CAT' file using DLFORMAT.
echo .	      5)   Build 3 indices and then browse the formatted '.CLF' file
echo .		   in both directions on any of three 'key' fields using
echo .		   DLSCAN, which makes use of LSAM calls.
echo ..........................................................................
cd
echo .	  If the required files for this LSAM demo are NOT in the above direc-
echo .	  tory, hit CTL-C or CTL-BREAK and move them here to simplify things.
echo .	  When you are ready, restart this batch file.	If this is NOT
echo .	  the case, please proceed.  The required files are:
echo .	  GENPARM.EXE	  PARMLIST.EXE	  DLFORMAT.EXE	   DLSCAN.EXE
echo .	  LSAM.RTL	  DL3.TXT	  DL3.CAT
echo ..........................................................................
pause
cls
goto setenv
rem	  NOTICE  - If for some reason you have scattered these files,
rem		    insert 'd:\path' in environment vars below with demo
rem		    path information (i.e. where you dumped the demo files).
rem		    They should look similar to the following:
rem			 set inctl=d:\path\dl3.bin
rem			 set lsamrtl=d:\path\lsam.rtl
rem			 set lsamixalloc=3
:setenv
set inctl=dl3.bin
set lsamrtl=lsam.rtl
set lsamixalloc=3
set
echo .
echo .	  Note - Environment is now set for DLSCAN demo:
echo .		 Required LSAM variables LSAMRTL and LSAMIXALLOC are set,
echo .		 and a user variable 'INCTL' now points to the LSAM
echo .		 control file for DL3 - DL3.BIN - which contains all
echo .		 other required attribute information for LSAM to pro-
echo .		 cess requests against the multi-indexed DL3.CLF.
echo .
pause
cls
echo .
echo .	  GENPARM will now create a binary-image control file for LSAM: DL3.BIN
echo .		  using source in file DL3.TXT (ASCII text)
echo .
pause
rem
rem GENPARM command-line format:
rem   genparm	input .txt file name
rem
genparm dl3
echo .
pause
cls
echo .
echo .	  PARMLIST will now display a formatted report of DL3.BIN
echo .
pause
rem
rem PARMLIST command-line format:
rem   parmlist	 input .bin file name
rem
parmlist dl3 | more
echo .
pause
rem	       delete any pre-existing generated input for DLSCAN
del dl3.clf >nul
del dl3.i?? >nul
cls
echo .
echo .	  DLFORMAT will now generate required-format file for DLSCAN
echo .
pause
rem
rem DLFORMAT command-line format:
rem   dlformat	 unformatted '.cat' file name (full filespec required)
rem
dlformat dl3.cat
echo .
pause
cls
echo .
echo .	  DLSCAN will now build 3 indices to allow 3-way browse of DL3.CLF
echo .
pause
rem
rem DLSCAN command-line format:
rem   dlscan   env.var--input parm file
rem
dlscan inctl
echo .
pause
cls
echo .
echo .	  About to reset environment to previous setting
echo .
pause
set inctl=
set lsamrtl=
set lsamixalloc=
set
echo .
echo .	  Environment reset.  End of demo.  Consult LSAM.DOC and demo source
echo .	  in DLSCAN.C, DL_CLF.H and DL3.TXT for additional details.
echo .
pause
cls
