/************************************************************************/
/*  (c)  1987 by James N. Seed,  Dallas, TX  -  all rights reserved.	*/
/*									*/
/*  This program is provided for example purposes only.  It, and/or	*/
/*  its executable equivalent, may not be sold or distributed in any	*/
/*  form for profit, without the prior written consent of the author.	*/
/************************************************************************/

#define LINT_ARGS				/* wholly advisable!!! */

#pragma check_stack-				/* special for MSC */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <c_dates.h>

static	char *errtyp1 = "\nerror:  cannot interpret the %s in the %s date.\n";
static	char *errtyp2 = "\nerror:  %s date is not a valid date.\n";

static	char *fldnme[3] = { "month", "day", "year" };	/* this is for the */
static	char *dtenme[2] = { "first", "second" };	/* error output.   */

_setenvp()	{ }				/* special for MSC */

main( argc, argv )

int	  argc;
char	**argv;

{
	unsigned int	gregdte[3], i;		/* m, d, & y ( & index ) */
	unsigned long	julian[2];		/* holds 2 julian dates  */
	char		dtestr[29];		/* to hold verbose dates */
	char		*nxtfld;		/* for dividing parms	 */
	unsigned int	chkdte[3];		/* used to check date	 */

	if ( argc-- != 3 )			/* two parms input ? */
	{
	     printf( "\n DAYS   is a program that calculates the number of days that" );
	     printf( "\n ====   exist between any two dates.\n" );
	     printf( "\nusage:  DAYS date1 date2" );
	     printf( "\n\nwhere:" );
	     printf( "\n\tdate1 is the starting date of the period, and" );
	     printf( "\n\tdate2 is the ending   date of the period." );
	     printf( "\n\n- Both dates MUST be input in the \"month/day/year\" format.\n" );

	     return( 0 );
	}

	/*******************************************************************/
	/* The following loop converts the two input dates to julian longs */
	/*******************************************************************/

	while ( argc )					/* for both dates, */
	{
		for ( i = 0; i < 2; ++i )		/* pick off m & d  */
		{
		      if ( gregdte[i] = atoi( argv[argc] ) )
		      {
			   if ( nxtfld = strstr( argv[argc], "/" ) )
			   {
				argv[argc] = ++nxtfld;
			   }
			   else
			   {
				printf( errtyp1, fldnme[++i], dtenme[--argc] );
				return( 1 );
			   }
		      }
		      else
		      {
			   printf( errtyp1, fldnme[i], dtenme[--argc] );
			   return( 1 );
		      }
		}

		gregdte[i] = atoi( argv[argc] );	/* then pick off y */

		/*********************************************************/
		/*   this line converts the m, d, & y to a JULIAN date   */
		/*********************************************************/

		julian[--argc] = gtoj( gregdte[0], gregdte[1], gregdte[2] );

		/*****************************************************/
		/*   these lines check to see if the date is valid   */
		/*****************************************************/

		jtog( julian[argc], (char *)chkdte, 0 );

		for ( i = 0; i < 3; ++i )
		{
		      if ( chkdte[i] != gregdte[i] )
		      {
			   printf( errtyp2, dtenme[argc] );
			   return( 1 );
		      }
		}
	}

	/*******************************************************************/
	/*   this line computes the NUMBER OF DAYS between the two dates   */
	/*******************************************************************/

	printf( "\nThere are %li days between the two dates,",
		 daycnt( julian[0], julian[1], 0 ) );

	/******************************************************/
	/*   these lines create the VERBOSE GREGORIAN dates   */
	/******************************************************/

	fulldte( julian[0], dtestr );

	printf( "\n\n\t  %s", dtestr );

	fulldte( julian[1], dtestr );

	printf( " and %s.", dtestr );

	/*******************************************************************/
	/*   this line computes the weekday, Saturday, and Sunday counts   */
	/*******************************************************************/

	printf( "\n\nOf these, %li are weekdays, %li are Saturdays, and %li are Sundays.\n",
		 daycnt( julian[0], julian[1], 2 ),
		 satcnt( julian[0], julian[1] ),
		 suncnt( julian[0], julian[1] )  );

	return( 0 );
}
