/************************************************************************/
/*  (c)  1987 by James N. Seed,  Dallas, TX  -  all rights reserved.	*/
/*									*/
/*  This program is provided for example purposes only.  It, and/or	*/
/*  its executable equivalent, may not be sold or distributed in any	*/
/*  form for profit, without the prior written consent of the author.	*/
/************************************************************************/

#define LINT_ARGS				/* wholly advisable!!! */

#pragma check_stack-				/* special for MSC */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <c_dates.h>

static	char *errtyp1 = "\nerror:  cannot interpret the %s in the start date.\n";
static	char *errtyp2 = "\nerror:  start date is not a valid date.\n";

static	char *fldnme[3] = { "month", "day", "year" };	/* this is for the */
							/* error output.   */

_setenvp()	{ }				/* special for MSC */

main( argc, argv )

int	  argc;
char	**argv;

{
	unsigned int	gregdte[3], i;		/* m, d, & y ( & index )  */
	unsigned long	julian;			/* julian long start date */
	int		type = 0;		/* type of days to add	  */
	char		dtestr[29];		/* to hold verbose dates  */
	char		*nxtfld;		/* for dividing date parm */
	unsigned int	chkdte[3];		/* used to check date	 */

	if ( argc-- != 3 )			/* two parms input ? */
	{
	     printf( "\nNDATE   is a program that calculates a new date that is equal" );
	     printf( "\n=====   to the starting date input plus or minus the number of" );
	     printf( "\n        days of the specified type.\n" );
	     printf( "\nusage:  NDATE [ sdate [+/-]days[A|S|W] ]" );
	     printf( "\n\nwhere:" );
	     printf( "\n\tsdate is the starting date, and\n" );
	     printf( "\n\t[+/-]days is the ( signed ) number of days to be added," );
	     printf( "\n\t\t  defined as ONE of the following allowable types:\n" );
	     printf( "\n\t\t  A - all days (default)," );
	     printf( "\n\t\t  S - all days excluding Sundays," );
	     printf( "\n\t\t  W - all days excluding weekends" );
	     printf( "\n\n- The starting date MUST be input in the \"month/day/year\" format.\n" );

	     return( 0 );
	}

	/***********************************************************/
	/* First, convert the input date to the m, d, & y integers */
	/***********************************************************/

	for ( i = 0; i < 2; ++i )			/* pick off m & d  */
	{
	      if ( gregdte[i] = atoi( argv[1] ) )
	      {
		   if ( nxtfld = strstr( argv[1], "/" ) )
		   {
			argv[1] = ++nxtfld;
		   }
		   else
		   {
			printf( errtyp1, fldnme[++i] );
			return( 1 );
		   }
	      }
	      else
	      {
		   printf( errtyp1, fldnme[i] );
		   return( 1 );
	      }
	}

	gregdte[i] = atoi( argv[1] );			/* then pick off y */

	/***********************************************************/
	/*   this line converts the m, d, & y to the JULIAN date   */
	/***********************************************************/

	julian = gtoj( gregdte[0], gregdte[1], gregdte[2] );

	/*****************************************************/
	/*   these lines check to see if the date is valid   */
	/*****************************************************/

	jtog( julian, (char *)chkdte, 0 );

	for ( i = 0; i < 3; ++i )
	{
	      if ( chkdte[i] != gregdte[i] )
	      {
		   printf( errtyp2 );
		   return( 1 );
	      }
	}

	fulldte( julian, dtestr );	/* save verbose to print out later */

	/***********************************************/
	/*   these lines compute the new julian date   */
	/***********************************************/

	if ( strchr( argv[2], 'S' ) ) type = 1;
	if ( strchr( argv[2], 'W' ) ) type = 2;

	julian = newdate( julian, atol( argv[2] ), type );

	/******************************************/
	/*   these lines print out the new date   */
	/******************************************/

	printf( "\n\t  %li days from %s%s is", atol( argv[2] ), dtestr,
		 type ? type == 1 ? ", excluding Sundays,"
				  : ", excluding weekends," : "" );

	fulldte( julian, dtestr );

	printf( "\n\n\t  %s.\n", dtestr );

	return( 0 );
}
