// ************************************************************************
// *
// *    Copyright (c) 1992 Microsoft Corporation.  All Rights Reserved.
// *
// *-----------------------------------------------------------------------
// *
// *      Module:  test.c
// *
// ************************************************************************

#include "test.h"

HANDLE hInst ;

// ************************************************************************
// *  int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance,
// *                      LPSTR lpCmdLine, int nCmdShow )
// *
// *  Description:
// *     Main windows procedure
// *
// ************************************************************************

int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpCmdLine, int nCmdShow )
{
   MSG  msg ;

   if (!hPrevInstance)
      if (!InitApplication( hInstance ))
         return ( FALSE ) ;

   if (!InitInstance( hInstance, nCmdShow ))
      return ( FALSE ) ;

   while (GetMessage( &msg, NULL, NULL, NULL ))
   {
      TranslateMessage( &msg ) ;
      DispatchMessage( &msg ) ;
   }
   return ( msg.wParam ) ;

} /* end of WinMain() */

//************************************************************************
// *  BOOL InitApplication( HANDLE hInstance )
// *
// *  Description:
// *     Initializes application specific stuff (e.g. Window Classes)
// *
// ************************************************************************

BOOL InitApplication( HANDLE hInstance )
{
   WNDCLASS  wc ;

   wc.style = NULL ;
   wc.lpfnWndProc = MainWndProc ;
   wc.cbClsExtra = 0 ;
   wc.cbWndExtra = 0 ;
   wc.hInstance = hInstance ;
   wc.hIcon = LoadIcon( NULL, IDI_APPLICATION ) ;
   wc.hCursor = LoadCursor( NULL, IDC_ARROW ) ;
   wc.hbrBackground = GetStockObject( WHITE_BRUSH ) ;
   wc.lpszMenuName = "MainMenu" ;
   wc.lpszClassName = "TestWClass" ;

   return ( RegisterClass( &wc ) ) ;

} /* end of InitApplication() */

// ************************************************************************
// *  BOOL InitInstance( HANDLE hInstance, int nCmdShow )
// *
// *  Description:
// *     Initialization specific stuff.
// *
// *
// ************************************************************************

BOOL InitInstance( HANDLE hInstance, int nCmdShow )
{
   HWND  hWnd ;

   hInst = hInstance ;

   hWnd = CreateWindow( "TestWClass", "Test for StackSwitch DLL",
                       WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT,
                       CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL,
                       hInstance, NULL ) ;

   if (!hWnd)
      return ( FALSE ) ;

   ShowWindow( hWnd, nCmdShow ) ;
   UpdateWindow( hWnd ) ;
   return ( TRUE ) ;

} /* end of InitInstance() */

// ************************************************************************
// *  LRESULT FAR PASCAL MainWndProc( HWND hWnd, UINT uMsg,
// *                               WPARAM wParam, LPARAM lParam )
// *
// *  Description:
// *     Main window procedure
// *
// *  Comments:
// *      6/ 5/91  baw  Wrote this comment.
// *      4/20/92  tcs  Check return from PerformFunction
// *
// ************************************************************************

LRESULT WINAPI MainWndProc( HWND hWnd, UINT uMsg,
                                WPARAM wParam, LPARAM lParam )
{
   FARPROC              lpProcAbout ;


   switch (uMsg)
   {
      case WM_COMMAND:
         switch (wParam)
         {
            case IDM_FUNCTION:
               if (PerformFunction( hWnd ))    // Call function
                    MessageBox( GetFocus(), "Stack Switch Succeeded",
                              "Sample Test", MB_ICONASTERISK | MB_OK );

		  		   else

                    MessageBox( GetFocus(), "Stack Switch Failed",
                              "Sample Test", MB_ICONASTERISK | MB_OK );

					
               break ;

            case IDM_ABOUT:
               lpProcAbout = MakeProcInstance( AboutDlgProc, hInst ) ;
               DialogBox( hInst, "AboutBox", hWnd, lpProcAbout ) ;
               FreeProcInstance( lpProcAbout ) ;
               break ;
         }
         break ;

      case WM_DESTROY:
         PostQuitMessage( 0 ) ;
         break ;

      default:
         return ( DefWindowProc( hWnd, uMsg, wParam, lParam ) ) ;
   }
   return ( NULL ) ;

} /* end of MainWndProc() */

// ************************************************************************
// *  BOOL FAR PASCAL AboutDlgProc( HWND hDlg, UINT uMsg,
// *                                WPARAM wParam, LPARAM lParam )
// *
// *  Description:
// *     The about dialog procedure.
// *
// ************************************************************************/

BOOL WINAPI AboutDlgProc( HWND hDlg, UINT uMsg,
                              WPARAM wParam, LPARAM lParam )
{
   switch (uMsg) {
      case WM_INITDIALOG:
         return ( TRUE ) ;

      case WM_COMMAND:
         if (wParam == IDOK || wParam == IDCANCEL) {
            EndDialog( hDlg, TRUE ) ;
            return ( TRUE ) ;
         }
         break ;
   }
   return ( FALSE ) ;

} /* end of AboutDlgProc() */

/************************************************************************
 * End of File: test.c
 ************************************************************************/

