// ************************************************************************
// *
// *-----------------------------------------------------------------------
// *
// *     Project:  Stack switch example
// *
// *     Module:  perform.c
// *
// *
// *     Remarks:  This calls two helper functions - NewStack() and
// *               OldStack(). NewStack will call SwitchStackTo for 
// *				     Windows 3.1 and up, otherwise it will perform
// *					  it's own switching because of the bug in Switch
// *					  StackBack in Windows 3.0.
// *     
// *		Development Team: Bryan Woodruff
// *                       Tammy Steele
// *     
// *     Written by Microsoft Product Support Services, Windows Developer Support.
// *     Copyright (c) 1992 Microsoft Corporation. All rights reserved.
// *
// ************************************************************************

#include "testdll.h"

BOOL fRetVal ;

// ************************************************************************
// *  BOOL FAR PASCAL PerformFunction( HWND hWnd )
// *
// *  Description:
// *     Uses NewStack() and OldStack() to perform a function
// *     a temporary stack of the DLL.  
// *
// *  Comments:
// *
// *     Note:  This assumes that the new stack that we allocate
// *     in the _DLL_'s DS is a size of a multiple of 4.
// *
// ************************************************************************

BOOL WINAPI PerformFunction( HWND hWnd )
{
   HWND     hWndDlgParent = hWnd ;
   WORD     wNewSS ;
   NPSTR    npNewStack ;

   wNewSS = HIWORD( GlobalLock( hInstLib ) ) ; // Get DLL's SS
   if (!wNewSS)
      return ( FALSE );

   npNewStack = (NPSTR) LocalAlloc( LPTR, 0x4000 ) ;	// Allocate new stack area
   if (!npNewStack)
      return( FALSE );

   NewStack( (UINT) wNewSS, (UINT) npNewStack + 0x4000,
             (UINT) npNewStack ) ;			  // Run on new stack

   DialogBox( hInstLib, "DialogBox", hWndDlgParent, DialogBoxProc ) ;
   
   OldStack() ;   // Return to regular stack

   LocalFree( (HLOCAL) npNewStack ) ;
   GlobalUnlock( hInstLib ) ;

   return ( TRUE ) ;

} /* end of PerformFunction() */

//------------------------------------------------------------------------
//  BOOL FAR PASCAL DialogBoxProc( HWND hDlg, UINT uMsg,
//                                 WPARAM wParam, LPARAM lParam )
//
//  Description:
//     A modal dialog box... used for our testing purposes.
//
//  Parameters:
//     HWND hDlg
//     UINT uMsg
//     WPARAM wParam
//     LPARAM lParam
//
//
//------------------------------------------------------------------------

BOOL WINAPI DialogBoxProc( HWND hDlg, UINT uMsg,
                               WPARAM wParam, LPARAM lParam )
{
   switch (uMsg)
   {
      case WM_COMMAND:
         switch (wParam)
         {
            case IDOK:
            case IDCANCEL:
               EndDialog( hDlg, TRUE ) ;
               
         }
         break ;
   }
   return ( FALSE ) ;

} // end of DialogBoxProc()

/************************************************************************
 * End of File: perform.c
 ************************************************************************/

