/*---------------------------------------------------------------------------
	WINLIB.H  -- window management

	Version 1.0

	(C) Copyright 1992
	All Rights Reserved

	Andrew Trzeciak
	PO Box 1521
	Lombard IL 60148-8521
*/

#if ! defined (_H_WINLIB_)
#define _H_WINLIB_

#if	!defined(__COLORS)
#define __COLORS

enum COLORS {
	BLACK,			/* dark colors */
	BLUE,
	GREEN,
	CYAN,
	RED,
	MAGENTA,
	BROWN,
	LIGHTGRAY,		/* 7 */
	DARKGRAY,		/* light colors */
	LIGHTBLUE,
	LIGHTGREEN,
	LIGHTCYAN,
	LIGHTRED,		/* 12 */
	LIGHTMAGENTA,
	YELLOW,
	WHITE
};
#endif

typedef enum {
	NOTITLE,
	TOPLEFTTITLE,TOPCENTERTITLE,TOPRIGHTTITLE,
	BOTTOMLEFTTITLE,BOTTOMCENTERTITLE,BOTTOMRIGHTTITLE
} TITLEMODE;

typedef unsigned char framestr[8];	/* Characters for frame */
	/*  0     1     2  */
	/*  3           4  */
	/*  5     6     7  */

/*================================* T B L R                  */
#define SSDDFrame  "ķĽ"		/* O O E I    S = Single    */
#define DDSSFrame  "͸;"		/* P T F G    D = Double    */
#define DDDDFrame  "ͻͼ"		/*   T T H                  */
#define SSSSFrame  "Ŀ"		/*   O   T                  */
#define NONEFrame  "        "
/*================================*   M                      */

typedef struct {
	int xleft,xtop;
	int xright,xbottom;	/* outer co-ordinates of opposite corners */
	int Wfore,Wback;
	unsigned char fillch;
	int iscursor;			/* if cursor active    */
	int iswrap;				/* if EOL wrap enabled */
	int hidden;				/* if window on view   */
	int isframe;			/* if frame            */
	framestr framedef;	/* only used if frame  */
	int Ffore,Fback;
} WINDEF;

typedef struct windescriptortype *WINTYPE;

typedef struct windescriptortype {
	unsigned int guard;
	WINTYPE next;
	WINTYPE cursor_chain;
	WINDEF wdef;
	int xwidth,xdepth;			/* outer window */
	int left,top,right,bottom;	/* inner window pane */
	int width, depth;				/* inner pane */
	int curx, cury;
	unsigned int *wbuf;			/* window buffer */
	char *title;
	TITLEMODE tmode;
	void far *user_record;
} WINDESC;

typedef struct UseListLink *UseListPtr;

typedef struct UseListLink {
	UseListPtr next;
	WINTYPE wind;
} USELIST;

/*=========================================================================*/


WINTYPE wn_screen (void);

WINTYPE wn_curwin (void);

WINTYPE wn_open (WINDEF *wd);
/*
	creates a new window, clears the window, and puts it on view
	on top of any existing windows
*/

WINTYPE wn_use (WINTYPE w);
/*
   Causes all subsequent output (by the current process)
   to appear in the specified Window
   NB does not have to be Top Window (or in fact on the screen at all)
*/

void wn_putontop (WINTYPE w);
/*
   Puts the specified window on the top of the window stack,
   ensuring that it is fully visible.
   If this results in other windows becoming obscured then a buffer
   is allocated for each of these windows.
   All otherwise undirected output (i.e. with no Use) will appear
   within this window.
*/

void wn_hide (WINTYPE w);
/*
    Removes window from the Window stack and also the screen,
    placing the windows contents in a buffer for possible re-display later.
    Uncovers obscured windows.
*/

void wn_putbeneath (WINTYPE w, WINTYPE wa);
/*
	 Puts window w beneath window wa
*/

void wn_snapshot (void);
/*
   Updates the Window buffer from the screen
	To capture the screen,
		first Open should be used with hidden set in WINDEF,
		then SnapShot can be called to capture the screen contents
		then PutOnTop can be used to 'unhide' the window.
*/

WINTYPE wn_close (WINTYPE w);
/*
     Removes the specified window from the screen,
     deletes window descriptor and
     de-allocates any buffers previously allocated.
     Also sets W to Nil to prevent further use of window.
*/

WINTYPE wn_used (void);
/*
    Returns the current window being used for output for this process.
    If no window assigned by Use then returns Top.
*/

WINTYPE wn_top (void);
/*
    Returns the current top Window.
*/

WINTYPE wn_winatpos (unsigned int x, unsigned int y);
/*
    Returns the window displayed at the absolute position X,Y
*/

int wn_obscuredat (WINTYPE w, unsigned int x, unsigned int y);
/*
    Returns if the specified window is obscured at the specified position.
*/

void wn_setframe (WINTYPE w, char *frame, int fore, int back);
/*
   Changes the frame around the specified window,
   redisplaying title if required
*/

void wn_settitle (WINTYPE w, char *Newtitle, TITLEMODE Mode);
/*
  updates the window title within the window frame,
  positioning it in the position defined by the title mode
*/

void wn_move (int dx, int dy);
/*
	Changes the position of the top window.
	The contents of the window will be moved with it.
*/

void wn_cursoron (void);
/*
    Turns the cursor on in the current window.
    NB cursor is only visible when turned on AND window is on top.
*/

void wn_cursoroff (void);
/*
   Turns the cursor off in the current window.
*/

void wn_clear (void);
/*
    clears the current window
*/

void wn_clreol (void);
/*
   Clears from the cursor to the end of line
*/

void wn_gotoxy (unsigned int x, unsigned int y);
/*
    Sets the current X Y position of the window currently being used
*/

int wn_wherex (void);
/*
    Returns the current X position of the window currently being used
*/

int wn_wherey (void);
/*
    Returns the current Y position of the window currently being used
*/

void wn_convertcoords (WINTYPE w, unsigned int x, unsigned int y, unsigned int *xo, unsigned int *yo);
/*
    Converts window relative co-ordinates to absolute screen co-ordinates
*/

void wn_insline (void);
/*
   Inserts a blank line at the cursor position
   scrolling the screen down beneath
*/

void wn_delline (void);
/*
   Deletes the line at the cursor position
   scrolling the screen up below
*/

void wn_setcolor (int c);
/*
   Sets the text foreground color of the current window
*/

void wn_setbkcolor (int  c);
/*
   Sets the text background color of the current window
*/

void wn_setwrap (int  on);
/*
   Enables/disables automatic wrap when writing beyond the right end of
   the current window
*/

WINDEF *wn_getdef (WINTYPE w);
/*
	gets information for the specified window
*/

void wn_directwrite ( unsigned int x, unsigned int y, char *str, unsigned int len, unsigned int attr);
void wn_directwritestr ( unsigned int x, unsigned int y, char *str, unsigned int len);
void wn_directwriteattr (unsigned int x, unsigned int y, unsigned int len, unsigned int attr);
/*
   Writes directly to current window at the specified X,Y coordinates
   with no check for special (i.e. control) chars or eol wrap.
*/

void wn_wputch (WINTYPE w, char c);
void wn_putch (char c);

int  wn_wputs (WINTYPE w, char *msg);
int  wn_puts (char *msg);

int  wn_wprintf (WINTYPE w, char *fmt, ...);
int  wn_printf (char *fmt, ...);

int wn_video (void);

int wn_init (WINDEF *InitDef,int ClearOnEntry);

void wn_exit (void);
/*
  close & destroy all windows
*/

#endif

